/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar;

public enum EPlatform {
    WINDOWS("Windows", false),
    LINUX("Linux", true),
    MACOS("macOS", true),
    BSD("BSD", true),
    UNIX("Unix", true);

    private static final EPlatform current;
    private final String name;
    private final boolean isUnix;

    private EPlatform(String name, boolean isUnix) {
        this.name = name;
        this.isUnix = isUnix;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnix() {
        return this.isUnix;
    }

    public static EPlatform get() {
        return current;
    }

    public static EArchitecture getArchitecture() {
        return EArchitecture.current;
    }

    public String toString() {
        return this.getName();
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            current = WINDOWS;
        } else if (osName.contains("linux")) {
            current = LINUX;
        } else if (osName.contains("mac") || osName.contains("darwin")) {
            current = MACOS;
        } else if (osName.startsWith("bsd")) {
            current = BSD;
        } else if (osName.startsWith("unix")) {
            current = UNIX;
        } else {
            throw new LinkageError("Unknown platform: " + osName);
        }
    }

    public static final class EArchitecture
    extends Enum<EArchitecture> {
        public static final /* enum */ EArchitecture X86;
        public static final /* enum */ EArchitecture X64;
        public static final /* enum */ EArchitecture ARM32;
        public static final /* enum */ EArchitecture ARM64;
        static final EArchitecture current;
        final boolean is64Bit;
        private static final /* synthetic */ EArchitecture[] $VALUES;

        public static EArchitecture[] values() {
            return (EArchitecture[])$VALUES.clone();
        }

        public static EArchitecture valueOf(String name) {
            return Enum.valueOf(EArchitecture.class, name);
        }

        private EArchitecture(boolean is64Bit) {
            this.is64Bit = is64Bit;
        }

        private static /* synthetic */ EArchitecture[] $values() {
            return new EArchitecture[]{X86, X64, ARM32, ARM64};
        }

        static {
            boolean is64Bit;
            X86 = new EArchitecture(false);
            X64 = new EArchitecture(true);
            ARM32 = new EArchitecture(false);
            ARM64 = new EArchitecture(true);
            $VALUES = EArchitecture.$values();
            String osArch = System.getProperty("os.arch");
            boolean bl = is64Bit = osArch.contains("64") || osArch.startsWith("armv8");
            current = osArch.startsWith("arm") || osArch.startsWith("aarch64") ? (is64Bit ? ARM64 : ARM32) : (is64Bit ? X64 : X86);
        }
    }
}

