/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import me.fzzyhmstrs.fzzy_config.api.SaveType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigContext;
import me.fzzyhmstrs.fzzy_config.event.impl.EventApiImpl;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.NetworkEvents;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.PortingUtils;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002WXB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u0013\u001a\u00020\u00102\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012JK\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJI\u0010!\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b\u001f\u0010 Ju\u0010)\u001a\u00020\u00102\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00142\u0006\u0010%\u001a\u00020$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b'\u0010(Jc\u00101\u001a\u00020\u00102\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b/\u00100J\u0015\u00105\u001a\b\u0012\u0004\u0012\u00020\u000502H\u0000\u00a2\u0006\u0004\b3\u00104J;\u0010=\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00052\u0014\u00109\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u000108072\f\u0010:\u001a\b\u0012\u0004\u0012\u0002080\rH\u0000\u00a2\u0006\u0004\b;\u0010<J\u001f\u0010@\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b>\u0010?J\u001f\u0010B\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\bA\u0010?J\u0017\u0010F\u001a\u00020C2\u0006\u0010,\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\bD\u0010EJ\u0019\u0010J\u001a\u0004\u0018\u00010G2\u0006\u0010,\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\bH\u0010IJ\u001f\u0010P\u001a\u00020\u00102\u0006\u0010K\u001a\u00020G2\u0006\u0010M\u001a\u00020LH\u0000\u00a2\u0006\u0004\bN\u0010OR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060Q8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010RR \u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020T0S8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bU\u0010V\u00a8\u0006Y"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry;", "", "<init>", "()V", "", "", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$SyncedConfigEntry;", "syncedConfigs$fzzy_config", "()Ljava/util/Map;", "syncedConfigs", "Ljava/util/function/Predicate;", "Lnet/minecraft/class_8710$class_9154;", "canSender", "Ljava/util/function/Consumer;", "Lnet/minecraft/class_8710;", "sender", "", "onConfigure$fzzy_config", "(Ljava/util/function/Predicate;Ljava/util/function/Consumer;)V", "onConfigure", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/server/MinecraftServer;", "server", "Ljava/util/function/BiPredicate;", "Ljava/util/function/BiConsumer;", "onJoin$fzzy_config", "(Lnet/minecraft/class_3222;Lnet/minecraft/server/MinecraftServer;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "onJoin", "", "players", "onEndDataReload$fzzy_config", "(Ljava/util/List;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "onEndDataReload", "serializedConfigs", "serverPlayer", "", "clientPerm", "changes", "receiveConfigUpdate$fzzy_config", "(Ljava/util/Map;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;ILjava/util/List;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "receiveConfigUpdate", "Ljava/util/UUID;", "uuid", "scope", "update", "summary", "receiveSettingForward$fzzy_config", "(Ljava/util/UUID;Lnet/minecraft/class_3222;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "receiveSettingForward", "", "quarantineList$fzzy_config", "()Ljava/util/Set;", "quarantineList", "id", "Ljava/util/function/Function;", "Lnet/minecraft/class_2561;", "nameFinder", "messageSender", "inspectQuarantine$fzzy_config", "(Ljava/lang/String;Ljava/util/function/Function;Ljava/util/function/Consumer;)V", "inspectQuarantine", "acceptQuarantine$fzzy_config", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;)V", "acceptQuarantine", "rejectQuarantine$fzzy_config", "rejectQuarantine", "", "hasConfig$fzzy_config", "(Ljava/lang/String;)Z", "hasConfig", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "getConfig$fzzy_config", "(Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/config/Config;", "getConfig", "config", "Lme/fzzyhmstrs/fzzy_config/api/RegisterType;", "registerType", "registerConfig$fzzy_config", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Lme/fzzyhmstrs/fzzy_config/api/RegisterType;)V", "registerConfig", "", "Ljava/util/Map;", "Lit/unimi/dsi/fastutil/objects/Object2ObjectLinkedOpenHashMap;", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$QuarantinedUpdate;", "quarantinedUpdates", "Lit/unimi/dsi/fastutil/objects/Object2ObjectLinkedOpenHashMap;", "QuarantinedUpdate", "SyncedConfigEntry", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nSyncedConfigRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncedConfigRegistry.kt\nme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1755#2,3:314\n1755#2,3:317\n*S KotlinDebug\n*F\n+ 1 SyncedConfigRegistry.kt\nme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry\n*L\n187#1:314,3\n264#1:317,3\n*E\n"})
public final class SyncedConfigRegistry {
    @NotNull
    public static final SyncedConfigRegistry INSTANCE = new SyncedConfigRegistry();
    @NotNull
    private static final Map<String, SyncedConfigEntry> syncedConfigs = new LinkedHashMap();
    @NotNull
    private static final Object2ObjectLinkedOpenHashMap<String, QuarantinedUpdate> quarantinedUpdates = new Object2ObjectLinkedOpenHashMap();

    private SyncedConfigRegistry() {
    }

    @NotNull
    public final Map<String, SyncedConfigEntry> syncedConfigs$fzzy_config() {
        return syncedConfigs;
    }

    public final void onConfigure$fzzy_config(@NotNull Predicate<class_8710.class_9154<?>> canSender, @NotNull Consumer<class_8710> sender) {
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        if (!canSender.test(ConfigSyncS2CCustomPayload.Companion.getType())) {
            return;
        }
        for (Map.Entry<String, SyncedConfigEntry> entry : syncedConfigs.entrySet()) {
            String id = entry.getKey();
            SyncedConfigEntry configEntry = entry.getValue();
            if (configEntry.skipSync()) continue;
            List syncErrors = new ArrayList();
            ConfigSyncS2CCustomPayload payload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(configEntry.getConfig(), syncErrors, (byte)0));
            if (!((Collection)syncErrors).isEmpty()) {
                ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C configuration stage sync.");
                syncError.writeError(syncErrors);
            }
            sender.accept(payload);
            try {
                configEntry.getConfig().onSyncServer();
            }
            catch (Throwable e) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with login onSyncServer method of config " + id + "!", e);
            }
            try {
                EventApiImpl.INSTANCE.fireOnSyncServer$fzzy_config(configEntry.getId(), configEntry.getConfig());
            }
            catch (Throwable e) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running login onSyncServer event for config " + id + "!", e);
            }
        }
    }

    public final void onJoin$fzzy_config(@NotNull class_3222 player, @NotNull MinecraftServer server, @NotNull BiPredicate<class_3222, class_8710.class_9154<?>> canSender, @NotNull BiConsumer<class_3222, class_8710> sender) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        if (server.method_3724()) {
            ValidatedIdentifier.Companion.createSpSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(player));
            return;
        }
        if (canSender.test(player, ConfigPermissionsS2CCustomPayload.Companion.getType())) {
            for (Map.Entry<String, SyncedConfigEntry> object : syncedConfigs.entrySet()) {
                String id = object.getKey();
                SyncedConfigEntry configEntry = object.getValue();
                if (configEntry.skipSync()) continue;
                Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)player, configEntry.getConfig(), (byte)0);
                ConfigPermissionsS2CCustomPayload payload = new ConfigPermissionsS2CCustomPayload(id, perms);
                sender.accept(player, payload);
            }
        }
        if (!canSender.test(player, DynamicIdsS2CCustomPayload.Companion.getType())) {
            return;
        }
        List<DynamicIdsS2CCustomPayload> dynamicIdSyncs = ValidatedIdentifier.Companion.createSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(player));
        if (dynamicIdSyncs.isEmpty()) {
            return;
        }
        for (DynamicIdsS2CCustomPayload sync : dynamicIdSyncs) {
            sender.accept(player, sync);
        }
    }

    public final void onEndDataReload$fzzy_config(@NotNull List<? extends class_3222> players, @NotNull BiPredicate<class_3222, class_8710.class_9154<?>> canSender, @NotNull BiConsumer<class_3222, class_8710> sender) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        for (class_3222 class_32222 : players) {
            if (!canSender.test(class_32222, ConfigSyncS2CCustomPayload.Companion.getType())) continue;
            for (Map.Entry<String, SyncedConfigEntry> entry : syncedConfigs.entrySet()) {
                String id = entry.getKey();
                SyncedConfigEntry configEntry = entry.getValue();
                if (configEntry.skipSync()) continue;
                List syncErrors = new ArrayList();
                ConfigSyncS2CCustomPayload syncPayload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(configEntry.getConfig(), syncErrors, (byte)0));
                if (!((Collection)syncErrors).isEmpty()) {
                    ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C datapack reload sync.");
                    syncError.writeError(syncErrors);
                }
                sender.accept(class_32222, syncPayload);
                if (!canSender.test(class_32222, ConfigPermissionsS2CCustomPayload.Companion.getType())) continue;
                Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)class_32222, configEntry, (byte)0);
                ConfigPermissionsS2CCustomPayload permsPayload = new ConfigPermissionsS2CCustomPayload(id, perms);
                sender.accept(class_32222, permsPayload);
                try {
                    configEntry.getConfig().onSyncServer();
                }
                catch (Throwable e) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with reload onSyncServer method of config " + id + ", for player " + class_32222 + "!", e);
                }
                try {
                    EventApiImpl.INSTANCE.fireOnSyncServer$fzzy_config(configEntry.getId(), configEntry.getConfig());
                }
                catch (Throwable e) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running reload onSyncServer event for config " + id + ", for player " + class_32222 + "!", e);
                }
            }
            if (class_32222.field_13995.method_3724()) {
                ValidatedIdentifier.Companion.createSpSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(class_32222));
                continue;
            }
            List<DynamicIdsS2CCustomPayload> dynamicIdSyncs = ValidatedIdentifier.Companion.createSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(class_32222));
            if (dynamicIdSyncs.isEmpty()) continue;
            for (DynamicIdsS2CCustomPayload sync : dynamicIdSyncs) {
                sender.accept(class_32222, sync);
            }
        }
    }

    public final void receiveConfigUpdate$fzzy_config(@NotNull Map<String, String> serializedConfigs, @NotNull MinecraftServer server, @NotNull class_3222 serverPlayer, int clientPerm, @NotNull List<String> changes, @NotNull BiPredicate<class_3222, class_8710.class_9154<?>> canSender, @NotNull BiConsumer<class_3222, class_8710> sender) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        Map successfulUpdates = new LinkedHashMap();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            boolean bl;
            ValidationResult<ConfigContext<SyncedConfigEntry>> result;
            SyncedConfigEntry configEntry;
            String configString;
            String id;
            block14: {
                ValidationResult<List<String>> validationResult;
                id = entry.getKey();
                configString = entry.getValue();
                configEntry = syncedConfigs.get(id);
                if (configEntry == null) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Config " + id + " wasn't found!, Skipping update");
                    continue;
                }
                if (!server.method_3724() && (validationResult = ConfigApiImpl.INSTANCE.validatePermissions$fzzy_config(serverPlayer, id, configEntry.getConfig(), configString, clientPerm)).isError()) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Player [" + serverPlayer.method_5477() + "] may have tried to cheat changes onto the Server Config! Problem settings found: " + CollectionsKt.joinToString$default((Iterable)validationResult.get(), (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null));
                    FC.INSTANCE.getLOGGER$fzzy_config().error("This update has not been applied, and has been moved to quarantine. Use the configure_update command to inspect and permit or deny the update.");
                    FC.INSTANCE.getLOGGER$fzzy_config().warn("If no action is taken, the quarantined update will be flushed on the next server restart, and its changes will not be applied");
                    ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
                    UUID uUID = serverPlayer.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
                    QuarantinedUpdate quarantine = new QuarantinedUpdate(uUID, changes, id, configString);
                    String quarantineId = id + " @" + serverPlayer.method_5477().getString() + " @" + formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.systemDefault()));
                    ((Map)quarantinedUpdates).put(quarantineId, quarantine);
                    if (quarantinedUpdates.size() > 128) {
                        quarantinedUpdates.pollFirstEntry();
                    }
                    for (class_3222 player : server.method_3760().method_14571()) {
                        Intrinsics.checkNotNull((Object)player);
                        if (ConfigApiImpl.INSTANCE.isConfigAdmin$fzzy_config((class_1657)player, configEntry.getConfig())) {
                            Object[] objectArray = new Object[]{serverPlayer.method_5477()};
                            player.method_43502((class_2561)FcText.INSTANCE.translate("fc.networking.permission.cheat", objectArray), false);
                        }
                        player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$0(id, arg_0)), false);
                        player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$1(id, arg_0)), false);
                        player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$2(id, arg_0)), false);
                    }
                    continue;
                }
                List errors = new ArrayList();
                result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(configEntry, configString, errors, (byte)10);
                Set actions = result.get().getOrDefault(ConfigContext.Keys.getRESTART_ACTIONS(), SetsKt.emptySet());
                result.writeError(errors);
                result.get().getConfig().getConfig().save();
                Iterable $this$any$iv = actions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Action it = (Action)((Object)element$iv);
                        boolean bl2 = false;
                        if (!it.getRestartPrompt()) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn("The server has received a config update that may require a restart. Connected clients have been automatically updated and notified of the potential for restart.");
                Set<String> records = result.get().get(ConfigContext.Keys.getRESTART_RECORDS());
                Collection collection = records;
                if (!(collection == null || collection.isEmpty())) {
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Server prompted for a restart due to received config changes");
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Restart-prompting changes:");
                    for (String record : records) {
                        FC.INSTANCE.getLOGGER$fzzy_config().info(record);
                    }
                }
            }
            successfulUpdates.put(id, configString);
            server.execute(() -> SyncedConfigRegistry.receiveConfigUpdate$lambda$4(configEntry, serverPlayer, id));
        }
        if (!server.method_3724()) {
            for (class_3222 player : serverPlayer.field_13995.method_3760().method_14571()) {
                if (Intrinsics.areEqual((Object)player, (Object)serverPlayer) || !canSender.test(player, ConfigUpdateS2CCustomPayload.Companion.getType())) continue;
                ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(successfulUpdates);
                sender.accept(player, newPayload);
            }
        }
        ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
    }

    public final void receiveSettingForward$fzzy_config(@NotNull UUID uuid, @NotNull class_3222 player, @NotNull String scope, @NotNull String update, @NotNull String summary, @NotNull BiPredicate<class_3222, class_8710.class_9154<?>> canSender, @NotNull BiConsumer<class_3222, class_8710> sender) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        class_3222 class_32222 = player.field_13995.method_3760().method_14602(uuid);
        if (class_32222 == null) {
            return;
        }
        class_3222 receivingPlayer = class_32222;
        if (!canSender.test(receivingPlayer, SettingForwardCustomPayload.Companion.getType())) {
            player.method_64398((class_2561)FcText.INSTANCE.translate("fc.config.forwarded_error.s2c", new Object[0]));
            return;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        sender.accept(receivingPlayer, new SettingForwardCustomPayload(update, uUID, scope, summary));
    }

    @NotNull
    public final Set<String> quarantineList$fzzy_config() {
        Set set = quarantinedUpdates.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return set;
    }

    public final void inspectQuarantine$fzzy_config(@NotNull String id, @NotNull Function<UUID, class_2561> nameFinder, @NotNull Consumer<class_2561> messageSender) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(nameFinder, (String)"nameFinder");
        Intrinsics.checkNotNullParameter(messageSender, (String)"messageSender");
        QuarantinedUpdate quarantinedUpdate = (QuarantinedUpdate)quarantinedUpdates.get((Object)id);
        if (quarantinedUpdate == null) {
            return;
        }
        QuarantinedUpdate quarantinedUpdate2 = quarantinedUpdate;
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.config", new Object[0]));
        messageSender.accept((class_2561)FcText.INSTANCE.translate(quarantinedUpdate2.getConfigId(), new Object[0]));
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.player", new Object[0]));
        String string = quarantinedUpdate2.getPlayerUuid().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        messageSender.accept((class_2561)FcText.INSTANCE.lit(string));
        class_2561 class_25612 = nameFinder.apply(quarantinedUpdate2.getPlayerUuid());
        if (class_25612 != null) {
            class_2561 it = class_25612;
            boolean bl = false;
            messageSender.accept(it);
        }
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.history", new Object[0]));
        for (String str : quarantinedUpdate2.getChangeHistory()) {
            messageSender.accept((class_2561)FcText.INSTANCE.lit(str));
        }
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.inspectQuarantine$lambda$6(id, arg_0)));
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.reject", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.inspectQuarantine$lambda$7(id, arg_0)));
    }

    public final void acceptQuarantine$fzzy_config(@NotNull String id, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        QuarantinedUpdate quarantinedUpdate = (QuarantinedUpdate)quarantinedUpdates.get((Object)id);
        if (quarantinedUpdate == null) {
            return;
        }
        QuarantinedUpdate quarantinedUpdate2 = quarantinedUpdate;
        SyncedConfigEntry config = syncedConfigs.get(quarantinedUpdate2.getConfigId());
        class_3222 player = server.method_3760().method_14602(quarantinedUpdate2.getPlayerUuid());
        if (config != null) {
            boolean bl;
            block10: {
                List errors = new ArrayList();
                ValidationResult<ConfigContext<SyncedConfigEntry>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, quarantinedUpdate2.getConfigString(), errors, (byte)2);
                Set actions = result.get().getOrDefault(ConfigContext.Keys.getRESTART_ACTIONS(), SetsKt.emptySet());
                result.writeError(errors);
                result.get().getConfig().getConfig().save();
                Iterable $this$any$iv = actions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Action it = (Action)((Object)element$iv);
                        boolean bl2 = false;
                        if (!it.getRestartPrompt()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn("The server accepted a quarantined config update that may require a restart, please consult the change history below for details. Connected clients have been automatically updated and notified of the potential for restart.");
            }
            for (class_3222 p : server.method_3760().method_14571()) {
                if (Intrinsics.areEqual((Object)p, (Object)player)) continue;
                Intrinsics.checkNotNull((Object)p);
                if (!NetworkEvents.INSTANCE.canSend(p, ConfigUpdateS2CCustomPayload.Companion.getType())) continue;
                ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(MapsKt.mapOf((Pair)TuplesKt.to((Object)quarantinedUpdate2.getConfigId(), (Object)quarantinedUpdate2.getConfigString())));
                NetworkEvents.INSTANCE.send(p, newPayload);
            }
        }
        class_3222 class_32222 = player;
        if (class_32222 != null) {
            class_3222 it = class_32222;
            boolean bl = false;
            if (NetworkEvents.INSTANCE.canSend(player, ConfigPermissionsS2CCustomPayload.Companion.getType())) {
                for (Map.Entry<String, SyncedConfigEntry> entry : syncedConfigs.entrySet()) {
                    String id2 = entry.getKey();
                    SyncedConfigEntry config2 = entry.getValue();
                    Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)player, config2, (byte)0);
                    ConfigPermissionsS2CCustomPayload payload = new ConfigPermissionsS2CCustomPayload(id2, perms);
                    NetworkEvents.INSTANCE.send(player, payload);
                }
            }
        }
        quarantinedUpdates.remove((Object)id);
    }

    public final void rejectQuarantine$fzzy_config(@NotNull String id, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        quarantinedUpdates.remove((Object)id);
    }

    public final boolean hasConfig$fzzy_config(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return syncedConfigs.containsKey(scope);
    }

    @Nullable
    public final Config getConfig$fzzy_config(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        SyncedConfigEntry syncedConfigEntry = syncedConfigs.get(scope);
        return syncedConfigEntry != null ? syncedConfigEntry.getConfig() : null;
    }

    public final void registerConfig$fzzy_config(@NotNull Config config, @NotNull RegisterType registerType) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)registerType), (String)"registerType");
        syncedConfigs.put(config.getId().method_42094(), new SyncedConfigEntry(config, registerType == RegisterType.SERVER));
        EventApiImpl.INSTANCE.fireOnRegisteredServer$fzzy_config(config.getId(), config);
    }

    private static final class_2583 receiveConfigUpdate$lambda$0(String $id, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10609("/configure_update \"" + $id + "\" inspect"));
    }

    private static final class_2583 receiveConfigUpdate$lambda$1(String $id, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10609("/configure_update \"" + $id + "\" accept"));
    }

    private static final class_2583 receiveConfigUpdate$lambda$2(String $id, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10609("/configure_update \"" + $id + "\" reject"));
    }

    private static final void receiveConfigUpdate$lambda$4(SyncedConfigEntry $configEntry, class_3222 $serverPlayer, String $id) {
        try {
            $configEntry.getConfig().onUpdateServer($serverPlayer);
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with onUpdateServer method of config " + $id + "!", e);
        }
        try {
            EventApiImpl.INSTANCE.fireOnUpdateServer$fzzy_config($configEntry.getId(), $configEntry.getConfig(), $serverPlayer);
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running onUpdateServer event for config " + $id + "!", e);
        }
    }

    private static final class_2583 inspectQuarantine$lambda$6(String $id, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10609("/configure_update \"" + $id + "\" accept"));
    }

    private static final class_2583 inspectQuarantine$lambda$7(String $id, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10609("/configure_update \"" + $id + "\" reject"));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$QuarantinedUpdate;", "", "Ljava/util/UUID;", "playerUuid", "", "", "changeHistory", "configId", "configString", "<init>", "(Ljava/util/UUID;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/util/UUID;", "getPlayerUuid", "()Ljava/util/UUID;", "Ljava/util/List;", "getChangeHistory", "()Ljava/util/List;", "Ljava/lang/String;", "getConfigId", "()Ljava/lang/String;", "getConfigString", "fzzy_config"})
    public static final class QuarantinedUpdate {
        @NotNull
        private final UUID playerUuid;
        @NotNull
        private final List<String> changeHistory;
        @NotNull
        private final String configId;
        @NotNull
        private final String configString;

        public QuarantinedUpdate(@NotNull UUID playerUuid, @NotNull List<String> changeHistory, @NotNull String configId, @NotNull String configString) {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
            Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
            Intrinsics.checkNotNullParameter((Object)configString, (String)"configString");
            this.playerUuid = playerUuid;
            this.changeHistory = changeHistory;
            this.configId = configId;
            this.configString = configString;
        }

        @NotNull
        public final UUID getPlayerUuid() {
            return this.playerUuid;
        }

        @NotNull
        public final List<String> getChangeHistory() {
            return this.changeHistory;
        }

        @NotNull
        public final String getConfigId() {
            return this.configId;
        }

        @NotNull
        public final String getConfigString() {
            return this.configString;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\tJ$\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0013\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\t\u00a8\u0006\u001f"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$SyncedConfigEntry;", "", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "config", "", "server", "<init>", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Z)V", "skipSync", "()Z", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "component1", "()Lme/fzzyhmstrs/fzzy_config/config/Config;", "component2", "copy", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Z)Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$SyncedConfigEntry;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "getConfig", "Z", "getServer", "fzzy_config"})
    public static final class SyncedConfigEntry {
        @NotNull
        private final Config config;
        private final boolean server;

        public SyncedConfigEntry(@NotNull Config config, boolean server) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            this.server = server;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        public final boolean getServer() {
            return this.server;
        }

        public final boolean skipSync() {
            return this.config.saveType() == SaveType.SEPARATE && this.server;
        }

        @NotNull
        public final class_2960 getId() {
            return this.config.getId();
        }

        @NotNull
        public final Config component1() {
            return this.config;
        }

        public final boolean component2() {
            return this.server;
        }

        @NotNull
        public final SyncedConfigEntry copy(@NotNull Config config, boolean server) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new SyncedConfigEntry(config, server);
        }

        public static /* synthetic */ SyncedConfigEntry copy$default(SyncedConfigEntry syncedConfigEntry, Config config, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                config = syncedConfigEntry.config;
            }
            if ((n & 2) != 0) {
                bl = syncedConfigEntry.server;
            }
            return syncedConfigEntry.copy(config, bl);
        }

        @NotNull
        public String toString() {
            return "SyncedConfigEntry(config=" + this.config + ", server=" + this.server + ")";
        }

        public int hashCode() {
            int result = this.config.hashCode();
            result = result * 31 + Boolean.hashCode(this.server);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SyncedConfigEntry)) {
                return false;
            }
            SyncedConfigEntry syncedConfigEntry = (SyncedConfigEntry)other;
            if (!Intrinsics.areEqual((Object)this.config, (Object)syncedConfigEntry.config)) {
                return false;
            }
            return this.server == syncedConfigEntry.server;
        }
    }
}

