/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.workarounds.context_creation;

import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import net.caffeinemc.mods.sodium.client.compatibility.checks.ModuleScanner;
import net.caffeinemc.mods.sodium.client.compatibility.checks.PostLaunchChecks;
import net.caffeinemc.mods.sodium.client.compatibility.environment.GlContextInfo;
import net.caffeinemc.mods.sodium.client.platform.NativeWindowHandle;
import net.minecraft.class_10219;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.opengl.WGL;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderSystem.class})
public class RenderSystemMixin {
    @Shadow
    @Final
    static Logger LOGGER;
    @Unique
    private static long wglPrevContext;

    @Inject(method={"initRenderer(JIZLjava/util/function/BiFunction;Z)V"}, at={@At(value="RETURN")})
    private static void postContextReady(long window, int i, boolean bl, BiFunction<class_2960, ShaderType, String> biFunction, boolean bl2, CallbackInfo ci) {
        GlContextInfo context = GlContextInfo.create();
        LOGGER.info("OpenGL Vendor: {}", (Object)context.vendor());
        LOGGER.info("OpenGL Renderer: {}", (Object)context.renderer());
        LOGGER.info("OpenGL Version: {}", (Object)context.version());
        wglPrevContext = class_156.method_668() == class_156.class_158.field_1133 ? WGL.wglGetCurrentContext() : 0L;
        NativeWindowHandle handle = () -> GLFWNativeWin32.glfwGetWin32Window((long)window);
        PostLaunchChecks.onContextInitialized(handle, context);
        ModuleScanner.checkModules(handle);
    }

    @Inject(method={"flipFrame(JLnet/minecraft/class_10219;)V"}, at={@At(value="RETURN")})
    private static void preSwapBuffers(long window, class_10219 tracyFrameCapture, CallbackInfo ci) {
        if (wglPrevContext == 0L) {
            return;
        }
        long context = WGL.wglGetCurrentContext();
        if (wglPrevContext == context) {
            return;
        }
        LOGGER.warn("The OpenGL context appears to have been suddenly replaced! Something has likely just injected into the game process.");
        ModuleScanner.checkModules(() -> GLFWNativeWin32.glfwGetWin32Window((long)window));
        wglPrevContext = context;
    }
}

