/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.DistantHorizons2CompatImpl;
import com.qendolin.betterclouds.compat.DistantHorizons3CompatImpl;
import com.qendolin.betterclouds.compat.DistantHorizons4CompatImpl;
import com.qendolin.betterclouds.compat.ModLoaded;
import com.seibel.distanthorizons.api.DhApi;
import java.util.Optional;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public abstract class DistantHorizonsCompat {
    public static final Matrix4f NOOP_MATRIX = new Matrix4f((Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), (Vector4fc)new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
    private static DistantHorizonsCompat instance;
    private static boolean isActive;

    public static void initialize() {
        if (instance != null) {
            return;
        }
        if (!ModLoaded.DISTANT_HORIZONS) {
            BetterCloudsStatic.getLogger().info("DistantHorizons: not loaded");
            instance = new Stub();
            return;
        }
        BetterCloudsStatic.getLogger().info("DistantHorizons: initializing compat");
        int apiVersion = 0;
        try {
            Class.forName("com.seibel.distanthorizons.api.DhApi");
            apiVersion = DhApi.getApiMajorVersion();
            BetterCloudsStatic.getLogger().info("DistantHorizons API version is {}.{}.{}", DhApi.getApiMajorVersion(), DhApi.getApiMinorVersion(), DhApi.getApiPatchVersion());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (apiVersion == 4) {
                BetterCloudsStatic.getLogger().warn("Using EXPERIMENTAL DistantHorizons 4 compat. The game might crash!");
                instance = new DistantHorizons4CompatImpl();
            } else if (apiVersion == 3) {
                BetterCloudsStatic.getLogger().info("Using DistantHorizons 3 compat");
                instance = new DistantHorizons3CompatImpl();
            } else if (apiVersion == 2) {
                BetterCloudsStatic.getLogger().info("Using DistantHorizons 2 compat");
                instance = new DistantHorizons2CompatImpl();
            } else {
                BetterCloudsStatic.getLogger().error("DistantHorizons version not compatible");
            }
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("DistantHorizons version not compatible", e);
        }
        if (instance == null) {
            instance = new Stub();
        } else {
            isActive = true;
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public static DistantHorizonsCompat instance() {
        return instance;
    }

    public abstract boolean isReady();

    public abstract boolean isEnabled();

    public abstract Matrix4f getProjectionMatrix();

    public abstract Optional<Integer> getDepthTextureId();

    public abstract void disableLodClouds();

    static {
        isActive = false;
    }

    private static class Stub
    extends DistantHorizonsCompat {
        private Stub() {
        }

        @Override
        public boolean isReady() {
            return false;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public Matrix4f getProjectionMatrix() {
            return NOOP_MATRIX;
        }

        @Override
        public Optional<Integer> getDepthTextureId() {
            return Optional.empty();
        }

        @Override
        public void disableLodClouds() {
        }
    }
}

