/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.EnhancedCelestials1CompatImpl;
import com.qendolin.betterclouds.compat.EnhancedCelestials2CompatImpl;
import com.qendolin.betterclouds.compat.ModLoaded;
import net.minecraft.class_1937;
import org.joml.Vector3f;

public abstract class EnhancedCelestialsCompat {
    private static EnhancedCelestialsCompat instance;
    private static boolean isActive;

    public static void initialize() {
        if (instance != null) {
            return;
        }
        if (!ModLoaded.ENHANCED_CELESTIALS) {
            BetterCloudsStatic.getLogger().info("EnhancedCelestials: not loaded");
            instance = new Stub();
            return;
        }
        BetterCloudsStatic.getLogger().info("EnhancedCelestials: initializing compat");
        int version = 0;
        boolean v1devPackage = true;
        try {
            Class.forName("dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData");
            version = 2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (version == 0) {
            try {
                Class.forName("corgitaco.enhancedcelestials.EnhancedCelestialsWorldData");
                version = 1;
                v1devPackage = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (version == 0) {
            try {
                Class.forName("dev.corgitaco.enhancedcelestials.EnhancedCelestialsWorldData");
                version = 1;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            if (version == 1) {
                BetterCloudsStatic.getLogger().info("Using EnhancedCelestials 1 compat");
                instance = new EnhancedCelestials1CompatImpl(v1devPackage);
            } else if (version == 2) {
                BetterCloudsStatic.getLogger().info("Using EnhancedCelestials 2 compat");
                instance = new EnhancedCelestials2CompatImpl();
            } else {
                BetterCloudsStatic.getLogger().error("EnhancedCelestials version not compatible");
            }
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("EnhancedCelestials version not compatible", e);
        }
        if (instance == null) {
            instance = new Stub();
        } else {
            isActive = true;
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public static EnhancedCelestialsCompat instance() {
        return instance;
    }

    public abstract Vector3f getEventTint(class_1937 var1);

    public abstract boolean isEventActive(class_1937 var1);

    public abstract float getMoonSize(class_1937 var1);

    static {
        isActive = false;
    }

    private static class Stub
    extends EnhancedCelestialsCompat {
        private Stub() {
        }

        @Override
        public Vector3f getEventTint(class_1937 world) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }

        @Override
        public boolean isEventActive(class_1937 world) {
            return false;
        }

        @Override
        public float getMoonSize(class_1937 world) {
            return 1.0f;
        }
    }
}

