/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.FabricSeasonsCompatImpl;
import com.qendolin.betterclouds.compat.ModLoaded;
import com.qendolin.betterclouds.config.FabricSeasonsConfig;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1937;

public abstract class FabricSeasonsCompat {
    public static final Map<String, Function<FabricSeasonsConfig, Float>> SEASON_CLOUDINESS_LOOKUP = Map.ofEntries(Map.entry("spring", config -> Float.valueOf(config.springCloudiness)), Map.entry("summer", config -> Float.valueOf(config.summerCloudiness)), Map.entry("fall", config -> Float.valueOf(config.fallCloudiness)), Map.entry("winter", config -> Float.valueOf(config.winterCloudiness)));
    private static FabricSeasonsCompat instance;
    private static boolean isActive;

    public static void initialize() {
        if (instance != null) {
            return;
        }
        if (!ModLoaded.FABRIC_SEASONS) {
            BetterCloudsStatic.getLogger().info("FabricSeasons: not loaded");
            instance = new Stub();
            return;
        }
        BetterCloudsStatic.getLogger().info("FabricSeasons: initializing compat");
        try {
            instance = new FabricSeasonsCompatImpl();
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("FabricSeasons version not compatible", e);
        }
        if (instance == null) {
            instance = new Stub();
        } else {
            isActive = true;
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public static FabricSeasonsCompat instance() {
        return instance;
    }

    public abstract float getCloudinessFactor(class_1937 var1);

    static {
        isActive = false;
    }

    protected static class Stub
    extends FabricSeasonsCompat {
        protected Stub() {
        }

        @Override
        public float getCloudinessFactor(class_1937 world) {
            return 1.0f;
        }
    }
}

