/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin.required;

import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.ProfilerWrapper;
import com.qendolin.betterclouds.compat.Telemetry;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.duck.WorldRendererDuck;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9960;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class}, priority=900)
public abstract class WorldRendererMixin
implements WorldRendererDuck {
    @Unique
    private final Vector3d tempVector = new Vector3d();
    @Unique
    private Renderer cloudRenderer;
    @Shadow
    private class_4604 field_27740;
    @Shadow
    @Nullable
    private class_4604 field_4056;
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Shadow
    private int field_4073;
    @Shadow
    @Final
    private class_9960 field_53081;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(class_310 client, class_898 entityRenderDispatcher, class_824 blockEntityRenderDispatcher, class_4599 bufferBuilders, CallbackInfo ci) {
        if (GLCompat.glCompat.isIncompatible()) {
            return;
        }
        this.cloudRenderer = new Renderer(client);
    }

    @Shadow
    public abstract class_4604 method_62222();

    @Override
    public Renderer betterclouds$getRenderer() {
        return this.cloudRenderer;
    }

    @Inject(at={@At(value="TAIL")}, method={"reload(Lnet/minecraft/resource/ResourceManager;)V"})
    private void onReload(class_3300 manager, CallbackInfo ci) {
        if (!BetterClouds.isInitialized()) {
            return;
        }
        if (GLCompat.glCompat.isIncompatible()) {
            return;
        }
        try {
            if (this.cloudRenderer != null) {
                this.cloudRenderer.reload(manager);
            }
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setWorld"})
    private void onSetWorld(class_638 world, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.setWorld(world);
        }
    }

    @Unique
    private Vector3d getCapturedFrustumPosition() {
        return new Vector3d(this.method_62222().field_20995, this.method_62222().field_20996, this.method_62222().field_20997);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds"}, cancellable=true)
    private void renderClouds(class_9909 frameGraphBuilder, class_4063 _mode, class_243 cameraPos, float _ticks, int _color, float _cloudHeight, CallbackInfo ci) {
        double camX = cameraPos.field_1352;
        double camY = cameraPos.field_1351;
        double camZ = cameraPos.field_1350;
        float tickDelta = class_3532.method_22450((float)_ticks);
        Matrix4f viewMat = RenderSystem.getModelViewMatrix();
        Matrix4f projMat = RenderSystem.getProjectionMatrix();
        if (this.cloudRenderer == null) {
            return;
        }
        if (GLCompat.glCompat.isIncompatible()) {
            return;
        }
        if (this.field_4085 == null) {
            return;
        }
        if (!ConfigManager.instance().enabledDimensions.contains(this.field_4085.method_40134().method_40230().orElse(null))) {
            return;
        }
        if (!BetterClouds.isEnabled()) {
            return;
        }
        ProfilerWrapper.getProfiler().method_15396("betterclouds");
        GLCompat.glCompat.pushDebugGroupDev("Better Clouds");
        Vector3d cam = this.tempVector.set(camX, camY, camZ);
        class_4604 frustum = this.field_27740;
        Vector3d frustumPos = cam;
        if (this.field_4056 != null) {
            frustumPos = this.getCapturedFrustumPosition();
            frustum = this.field_4056;
            frustum.method_23088(frustumPos.x, frustumPos.y, frustumPos.z);
        }
        int ticks = this.field_4073;
        if (Debug.animationPause >= 0) {
            if (Debug.animationPause == 0) {
                Debug.animationPause = ticks;
            } else {
                ticks = Debug.animationPause;
            }
            tickDelta = 0.0f;
        }
        try {
            Renderer.PrepareResult prepareResult = this.cloudRenderer.prepare(viewMat, projMat, ticks, tickDelta, cam);
            if (RenderDoc.isFrameCapturing()) {
                GLCompat.glCompat.debugMessage("renderer prepare returned " + prepareResult.name());
            }
            if (prepareResult != Renderer.PrepareResult.FALLBACK) {
                ci.cancel();
            }
            if (prepareResult == Renderer.PrepareResult.RENDER) {
                class_9916 renderPass = frameGraphBuilder.method_61911("clouds");
                if (this.field_53081.field_53096 != null) {
                    this.field_53081.field_53096 = renderPass.method_61933(this.field_53081.field_53096);
                } else {
                    this.field_53081.field_53091 = renderPass.method_61933(this.field_53081.field_53091);
                }
                int fticks = ticks;
                float ftickDelta = tickDelta;
                Vector3d fcam = cam;
                Vector3d ffrustumPos = frustumPos;
                class_4604 ffrustum = frustum;
                renderPass.method_61929(() -> {
                    GLCompat.glCompat.pushDebugGroupDev("Better Clouds");
                    this.cloudRenderer.render(fticks, ftickDelta, fcam, ffrustumPos, ffrustum);
                    GLCompat.glCompat.popDebugGroupDev();
                });
            }
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
        ProfilerWrapper.getProfiler().method_15407();
        GLCompat.glCompat.popDebugGroupDev();
    }

    @Inject(at={@At(value="HEAD")}, method={"close"})
    private void close(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.close();
        }
    }
}

