/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.widget;

import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTextureElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TRefreshablePanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UIExternalTexture;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryInfoProvider;
import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryUserInfo;
import io.github.thecsdev.tcdcommons.util.io.http.TcdWebApiPerson;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1255;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public final class CreditsTabPersonWidget
extends TRefreshablePanelElement {
    public static final class_2561 TEXT_OPEN_LINK = TextUtils.translatable((String)"mco.notification.visitUrl.buttonText.default", (Object[])new Object[0]);
    private final TcdWebApiPerson person;
    private final boolean fetchGitHubInfo;

    public CreditsTabPersonWidget(int x, int y, int width, TcdWebApiPerson person, boolean fetchGitHubInfo) throws NullPointerException {
        super(x, y, width, 20);
        this.setBackgroundColor(0x22000000);
        this.setOutlineColor(0);
        this.person = Objects.requireNonNull(person);
        this.fetchGitHubInfo = fetchGitHubInfo;
    }

    protected final void init() {
        TTextureElement icon = new TTextureElement(2, 2, 16, 16);
        this.addChild((TElement)icon, true);
        TLabelElement nameLabel = new TLabelElement(25, 0, this.getWidth(), 20, (class_2561)TextUtils.literal((String)this.person.getName()));
        nameLabel.setTextScale(0.9f);
        this.addChild((TElement)nameLabel, true);
        @Nullable URL visitUrl = this.person.getContact().getHomepageUrl();
        TButtonWidget visitBtn = new TButtonWidget(this.getEndX() - 102, this.getY() + 2, 100, 16);
        TLabelElement visitBtnLbl = new TLabelElement(0, 0, visitBtn.getWidth(), visitBtn.getHeight());
        visitBtnLbl.setText(TEXT_OPEN_LINK);
        visitBtnLbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        visitBtnLbl.setTextScale(0.9f);
        visitBtn.addChild((TElement)visitBtnLbl, true);
        visitBtn.setEnabled(visitUrl != null);
        visitBtn.setOnClick(btn -> GuiUtils.showUrlPrompt((String)visitUrl.toString(), (boolean)false));
        this.addChild((TElement)visitBtn, false);
        if (!this.fetchGitHubInfo) {
            return;
        }
        String host = visitUrl.getHost();
        if (!Objects.equals(host, "github.com") && !Objects.equals(host, "www.github.com")) {
            return;
        }
        URI visitUri = null;
        try {
            visitUri = visitUrl.toURI();
        }
        catch (URISyntaxException use) {
            return;
        }
        RepositoryInfoProvider.getUserInfoAsync((URI)visitUri, (class_1255)BetterStatsClient.MC_CLIENT, userInfo -> {
            class_5250 descr;
            nameLabel.setText(CreditsTabPersonWidget.getDisplayNameFromGHUser(userInfo));
            class_5250 ttt = TextUtils.literal((String)"").method_10852((class_2561)TextUtils.literal((String)nameLabel.getText().getString()).method_27692(class_124.field_1054));
            class_5250 class_52502 = descr = userInfo.getBiography() != null ? TextUtils.literal((String)userInfo.getBiography()) : null;
            if (descr != null) {
                ttt.method_27693("\n").method_10852((class_2561)TextUtils.literal((String)descr.getString()).method_27692(class_124.field_1080));
            }
            this.setTooltip(class_7919.method_47407((class_2561)ttt));
            userInfo.getAvatarImageAsync((class_1255)BetterStatsClient.MC_CLIENT, avatarBytes -> UIExternalTexture.loadTextureAsync((byte[])avatarBytes, avatarImg -> icon.setTexture((UITexture)avatarImg), err -> {
                System.err.println("Failed to load image for " + userInfo.getAccountName());
                err.printStackTrace();
            }), err -> {});
        }, err -> {});
    }

    public static final class_2561 getDisplayNameFromGHUser(RepositoryUserInfo userInfo) throws NullPointerException {
        String name = userInfo.getAccountName();
        String dName = userInfo.getDisplayName();
        class_5250 finalDName = TextUtils.literal((String)"");
        if (name == null && dName == null) {
            finalDName.method_27693("-");
        } else if (name != null && dName != null) {
            if (Objects.equals(name, dName)) {
                finalDName.method_27693("@" + name);
            } else {
                finalDName.method_27693(dName).method_27693(" (@").method_27693(name).method_27693(")");
            }
        } else if (name != null && dName == null) {
            finalDName.method_27693(name);
        } else if (name == null && dName != null) {
            finalDName.method_27693("@").method_27693(dName);
        }
        return finalDName;
    }
}

