/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.sound.context;

import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.context.DynamicSoundContext;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import net.minecraft.class_1113;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public class ScreenHandlerSoundContext
implements DynamicSoundContext<class_1703> {
    private final boolean isOpening;

    public ScreenHandlerSoundContext() {
        this(true);
    }

    public ScreenHandlerSoundContext(boolean isOpening) {
        this.isOpening = isOpening;
    }

    public static ScreenHandlerSoundContext of(boolean isOpening) {
        return new ScreenHandlerSoundContext(isOpening);
    }

    @Override
    public class_1113 handleContext(class_1703 context, class_2960 fallback, float pitch, float volume) {
        class_2960 soundEvent = null;
        try {
            class_3917 type = context.method_17358();
            for (SoundDefinition definition : DynamicSoundHelper.getDefinitions("screens")) {
                if (!definition.getKeys().isValid(type)) continue;
                soundEvent = definition.getSoundEvent();
                if (definition.getPitch().isPresent()) {
                    pitch = definition.getPitch().get().floatValue();
                }
                if (definition.getVolume().isPresent()) {
                    volume = definition.getVolume().get().floatValue();
                }
                break;
            }
        }
        catch (Exception ignored) {
            SoundsClient.LOGGER.debug("Screen of type {} has no declared ScreenHandlerType - ignoring.", (Object)context.getClass().getName());
        }
        fallback = this.isOpening ? SoundsConfig.get(UISoundsConfig.class).inventoryOpenSoundEffect.getSoundEvent() : SoundsConfig.get(UISoundsConfig.class).inventoryCloseSoundEffect.getSoundEvent();
        if (soundEvent == null) {
            soundEvent = fallback;
        }
        return this.createSoundInstance(soundEvent, pitch, volume);
    }
}

