/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ExtendedBlockEntityType;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.MeshTaskSizeEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.PresentTranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.services.PlatformLevelRenderHooks;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_10209;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3695;
import net.minecraft.class_5539;
import net.minecraft.class_827;
import net.minecraft.class_852;
import org.joml.Vector3dc;

public class ChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final ChunkRenderContext renderContext;
    private final SortBehavior sortBehavior;
    private final boolean forceSort;

    public ChunkBuilderMeshingTask(RenderSection render, int buildTime, Vector3dc absoluteCameraPos, ChunkRenderContext renderContext, SortBehavior sortBehavior, boolean forceSort) {
        super(render, buildTime, absoluteCameraPos);
        this.renderContext = renderContext;
        this.sortBehavior = sortBehavior;
        this.forceSort = forceSort;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext buildContext, CancellationToken cancellationToken) {
        class_3695 profiler = class_10209.method_64146();
        BuiltSectionInfo.Builder renderData = new BuiltSectionInfo.Builder();
        class_852 occluder = new class_852();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        LevelSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        class_2338.class_2339 blockPos = new class_2338.class_2339(minX, minY, minZ);
        class_2338.class_2339 modelOffset = new class_2338.class_2339();
        boolean sortEnabled = this.sortBehavior != SortBehavior.OFF;
        TranslucentGeometryCollector collector = sortEnabled ? new TranslucentGeometryCollector(this.render.getPosition(), this.sortBehavior) : null;
        BlockRenderer blockRenderer = cache.getBlockRenderer();
        blockRenderer.prepare(buffers, slice, collector);
        profiler.method_15396("render blocks");
        try {
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    return null;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        class_827 renderer;
                        TerrainRenderPass[] entity;
                        class_3610 fluidState;
                        class_2680 blockState = slice.getBlockState(x, y, z);
                        if (blockState.method_26215() && !blockState.method_31709()) continue;
                        blockPos.method_10103(x, y, z);
                        modelOffset.method_10103(x & 0xF, y & 0xF, z & 0xF);
                        if (blockState.method_26217() == class_2464.field_11458) {
                            class_1087 model = cache.getBlockModels().method_3335(blockState);
                            blockRenderer.renderModel(model, blockState, (class_2338)blockPos, (class_2338)modelOffset);
                        }
                        if (!(fluidState = blockState.method_26227()).method_15769()) {
                            cache.getFluidRenderer().render(slice, blockState, fluidState, (class_2338)blockPos, (class_2338)modelOffset, collector, buffers);
                        }
                        if (blockState.method_31709() && (entity = slice.method_8321((class_2338)blockPos)) != null && ExtendedBlockEntityType.shouldRender(entity.method_11017(), (class_1922)slice, (class_2338)blockPos, entity) && (renderer = class_310.method_1551().method_31975().method_3550((class_2586)entity)) != null) {
                            renderData.addBlockEntity((class_2586)entity, !renderer.method_3563());
                        }
                        if (!blockState.method_26216()) continue;
                        occluder.method_3682((class_2338)blockPos);
                    }
                }
            }
        }
        catch (class_148 ex) {
            throw this.fillCrashInfo(ex.method_631(), slice, (class_2338)blockPos);
        }
        catch (Exception ex) {
            throw this.fillCrashInfo(class_128.method_560((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (class_2338)blockPos);
        }
        profiler.method_15405("mesh appenders");
        PlatformLevelRenderHooks.INSTANCE.runChunkMeshAppenders(this.renderContext.getRenderers(), type -> buffers.get(DefaultMaterials.forChunkLayer(type)).asFallbackVertexConsumer(DefaultMaterials.forChunkLayer(type), collector), slice);
        blockRenderer.release();
        SortType sortType = SortType.NONE;
        if (sortEnabled) {
            sortType = collector.finishRendering();
        }
        if (cancellationToken.isCancelled()) {
            profiler.method_15407();
            return null;
        }
        profiler.method_15405("translucency sorting");
        boolean reuseUploadedData = false;
        TranslucentData translucentData = null;
        if (sortEnabled) {
            TranslucentData oldData = this.render.getTranslucentData();
            translucentData = collector.getTranslucentData(oldData, this);
            reuseUploadedData = !this.forceSort && translucentData == oldData;
        }
        profiler.method_15405("meshing");
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        int visibleSlices = DefaultChunkRenderer.getVisibleFaces((int)this.absoluteCameraPos.x(), (int)this.absoluteCameraPos.y(), (int)this.absoluteCameraPos.z(), this.render.getChunkX(), this.render.getChunkY(), this.render.getChunkZ());
        if (translucentData != null && translucentData.meshesWereModified()) {
            meshes.put(DefaultTerrainRenderPasses.TRANSLUCENT, buffers.createModifiedTranslucentMesh(translucentData.getUpdatedQuads()));
            renderData.addRenderPass(DefaultTerrainRenderPasses.TRANSLUCENT);
        }
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            boolean sliceReordering;
            boolean translucentBehavior;
            boolean forceUnassigned;
            BuiltSectionMeshParts mesh;
            if (meshes.containsKey(pass) || (mesh = buffers.createMesh(pass, visibleSlices, forceUnassigned = (translucentBehavior = sortEnabled && pass.isTranslucent()) && sortType.needsDirectionMixing, sliceReordering = !translucentBehavior || sortType.allowSliceReordering)) == null) continue;
            meshes.put(pass, mesh);
            renderData.addRenderPass(pass);
        }
        renderData.setOcclusionData(occluder.method_3679());
        ChunkBuildOutput output = new ChunkBuildOutput(this.render, this.submitTime, translucentData, renderData.build(), (Map<TerrainRenderPass, BuiltSectionMeshParts>)meshes);
        if (sortEnabled) {
            if (reuseUploadedData) {
                output.markAsReusingUploadedData();
            } else if (translucentData instanceof PresentTranslucentData) {
                PresentTranslucentData present = (PresentTranslucentData)translucentData;
                Sorter sorter = present.getSorter();
                sorter.writeIndexBuffer(this, true);
                output.setSorter(sorter);
            }
        }
        profiler.method_15407();
        return output;
    }

    private class_148 fillCrashInfo(class_128 report, LevelSlice slice, class_2338 pos) {
        class_129 crashReportSection = report.method_556("Block being rendered", 1);
        class_2680 state = null;
        try {
            state = slice.method_8320(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        class_129.method_586((class_129)crashReportSection, (class_5539)slice, (class_2338)pos, (class_2680)state);
        crashReportSection.method_578("Chunk section", (Object)this.render);
        if (this.renderContext != null) {
            crashReportSection.method_578("Render context volume", (Object)this.renderContext.getVolume());
        }
        return new class_148(report);
    }

    @Override
    public long estimateTaskSizeWith(MeshTaskSizeEstimator estimator) {
        return estimator.estimateSize(this.render);
    }
}

