/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.VariantsCitMod;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class NbtPath {
    public static final Codec<NbtPath> CODEC = Codec.STRING.comapFlatMap(NbtPath::Parse, NbtPath::toString);
    public static final NbtPath IDENTITY = new NbtPath(new Token[0]);
    @Deprecated
    public static final Codec<NbtPath> DOT_SEPARATED_CODEC = Codec.STRING.comapFlatMap(NbtPath::DotSeparatedPath, NbtPath::toString).validate(_0 -> {
        VariantsCitMod.LOGGER.warn("The value of `nbtPath` Uses an obsolete path format. Please add a `.` at the start of the path.");
        return DataResult.success((Object)_0);
    });
    @Deprecated
    public static final Codec<NbtPath> NBTKEY_CODEC = Codec.STRING.xmap(s -> new NbtPath(new Token[]{new MapKey((String)s)}), NbtPath::toString).validate(_0 -> {
        VariantsCitMod.LOGGER.warn("The parameter `nbtKey` is being deprecated. Use `nbtPath` instead.");
        return DataResult.success((Object)_0);
    });
    private final Token[] tokens;

    private NbtPath(Token[] tokens) {
        this.tokens = tokens;
    }

    private NbtPath(List<Token> tokens) {
        this.tokens = (Token[])tokens.toArray(Token[]::new);
    }

    @Nullable
    public class_2520 Resolve(class_2520 nbt) {
        for (Token tk : this.tokens) {
            if ((nbt = tk.Resolve(nbt)) != null) continue;
            return null;
        }
        return nbt;
    }

    @Deprecated
    public static DataResult<NbtPath> DotSeparatedPath(String rawPath) throws IllegalStateException {
        if (rawPath.isEmpty()) {
            return DataResult.success((Object)new NbtPath(new Token[0]));
        }
        String[] names = rawPath.split("\\.");
        Token[] tokens = new Token[names.length];
        for (int i = 0; i < names.length; ++i) {
            tokens[i] = new MapKey(names[i]);
        }
        return DataResult.success((Object)new NbtPath(tokens));
    }

    public static DataResult<NbtPath> Parse(String input) {
        Function[] parsers = new Function[]{MapKey::Next, ArrayIndex::Next, MapIndex::Next};
        ArrayList<Token> tokens = new ArrayList<Token>();
        String remainder = input;
        while (!remainder.isEmpty()) {
            Parsed result = null;
            for (int i = 0; i < parsers.length && result == null; ++i) {
                result = (Parsed)parsers[i].apply(remainder);
            }
            if (result == null) {
                return DataResult.error(() -> "Invalid token in path: " + input, (Object)new NbtPath(tokens));
            }
            tokens.add(result.token);
            remainder = result.remainder;
        }
        return DataResult.success((Object)new NbtPath(tokens));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Token tk : this.tokens) {
            builder.append(tk.toString());
        }
        return builder.toString();
    }

    private static interface Token {
        @Nullable
        public class_2520 Resolve(class_2520 var1);
    }

    private record MapKey(String name) implements Token
    {
        @Override
        public class_2520 Resolve(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                return compound.method_10580(this.name);
            }
            return null;
        }

        @Override
        public String toString() {
            return "." + this.name;
        }

        private static Parsed Next(String input) {
            char c;
            int end;
            if (input.length() < 2 || input.charAt(0) != '.') {
                return null;
            }
            for (end = 1; end < input.length() && ((c = input.charAt(end)) >= 'A' && 'Z' >= c || class_2960.method_12831((char)c) && c != '.'); ++end) {
            }
            return new Parsed(new MapKey(input.substring(1, end)), input.substring(end));
        }
    }

    private record Parsed(Token token, String remainder) {
    }

    private record MapIndex(int index) implements Token
    {
        @Override
        public class_2520 Resolve(class_2520 nbt) {
            if (!(nbt instanceof class_2487)) {
                return null;
            }
            class_2487 compound = (class_2487)nbt;
            int size = compound.method_10546();
            if (this.index < -size || size <= this.index) {
                return null;
            }
            int i = this.index;
            if (i < 0) {
                i += size;
            }
            String key = null;
            for (String k : compound.method_10541()) {
                if (i-- > 0) continue;
                key = k;
                break;
            }
            if (key == null) {
                return null;
            }
            class_2487 result = new class_2487();
            result.method_10582("key", key);
            result.method_10566("value", compound.method_10580(key));
            return result;
        }

        private static Parsed Next(String input) {
            int index;
            if (input.length() < 3 || input.charAt(0) != '{') {
                return null;
            }
            int end = input.indexOf(125);
            if (end < 0) {
                return null;
            }
            try {
                index = Integer.parseUnsignedInt(input.substring(1, end));
            }
            catch (NumberFormatException e) {
                return null;
            }
            return new Parsed(new MapIndex(index), input.substring(end + 1));
        }

        @Override
        public String toString() {
            return "{" + this.index + "}";
        }
    }

    private record ArrayIndex(int index) implements Token
    {
        @Override
        public class_2520 Resolve(class_2520 nbt) {
            if (!(nbt instanceof class_2483)) {
                return null;
            }
            class_2483 list = (class_2483)nbt;
            int size = list.size();
            if (this.index < -size || size <= this.index) {
                return null;
            }
            if (this.index >= 0) {
                return list.method_10534(this.index);
            }
            return list.method_10534(size + this.index);
        }

        @Override
        public String toString() {
            return "[" + this.index + "]";
        }

        private static Parsed Next(String input) {
            int index;
            if (input.length() < 3 || input.charAt(0) != '[') {
                return null;
            }
            int end = input.indexOf(93);
            if (end < 0) {
                return null;
            }
            try {
                index = Integer.parseUnsignedInt(input.substring(1, end));
            }
            catch (NumberFormatException e) {
                return null;
            }
            return new Parsed(new ArrayIndex(index), input.substring(end + 1));
        }
    }
}

