/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.events;

import com.mojang.brigadier.CommandDispatcher;
import com.natamus.collective_common_forge.cmds.CommandCollective;
import com.natamus.collective_common_forge.config.GenerateJSONFiles;
import com.natamus.collective_common_forge.events.CollectiveEvents;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import java.lang.invoke.MethodHandles;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class RegisterCollectiveForgeEvents {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), RegisterCollectiveForgeEvents.class);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerAboutToStartEvent e) {
        GenerateJSONFiles.initGeneration(e.getServer());
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (level == null) {
            return;
        }
        CollectiveEvents.onWorldLoad(level);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent.Pre e) {
        Level level = e.level();
        if (level.isClientSide()) {
            return;
        }
        CollectiveEvents.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent.Post e) {
        CollectiveEvents.onServerTick(e.server());
    }

    @SubscribeEvent(priority=127)
    public static void onMobSpawnerSpecialSpawn(MobSpawnEvent.FinalizeSpawn e) {
        Level Level2 = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (Level2 == null) {
            return;
        }
        if (!e.isSpawnCancelled() && e.getSpawner() != null) {
            e.getEntity().addTag("collective.fromspawner");
        }
    }

    @SubscribeEvent
    public static boolean onEntityJoinLevel(EntityJoinLevelEvent e) {
        return !CollectiveEvents.onEntityJoinLevel(e.getLevel(), e.getEntity());
    }

    @SubscribeEvent
    public static boolean onBlockBreak(BlockEvent.BreakEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getLevel());
        if (level == null) {
            return false;
        }
        return !CollectiveEvents.onBlockBreak(level, e.getPlayer(), e.getPos(), e.getState(), null);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent e) {
        CommandCollective.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }
}

