/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.natamus.collective_common_fabric.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_fabric.functions.UUIDFunctions;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class HeadFunctions {
    public static class_1799 getNewPlayerHead(class_3218 serverLevel, String playerName, Integer amount) {
        return HeadFunctions.getNewPlayerHead(serverLevel, playerName, "", amount);
    }

    public static class_1799 getNewPlayerHead(class_3218 serverLevel, String playerName, String noteBlockSound, Integer amount) {
        GameProfile gameProfile = HeadFunctions.getGameProfileFromPlayerName(serverLevel, playerName);
        if (gameProfile == null) {
            return null;
        }
        return HeadFunctions.getNewPlayerHead(gameProfile, noteBlockSound, amount);
    }

    public static class_1799 getNewPlayerHead(GameProfile gameProfile, Integer amount) {
        return HeadFunctions.getNewPlayerHead(gameProfile, "", amount);
    }

    public static class_1799 getNewPlayerHead(GameProfile gameProfile, String noteBlockSound, Integer amount) {
        if (gameProfile == null) {
            return null;
        }
        String playerName = gameProfile.name();
        PropertyMap propertyMap = gameProfile.properties();
        String texturePropertyValue = "";
        for (Property textureProperty : propertyMap.get((Object)"textures")) {
            if (!textureProperty.name().equals("textures")) continue;
            texturePropertyValue = textureProperty.value();
            break;
        }
        if (!texturePropertyValue.contains("cHJvZmlsZUlk")) {
            return null;
        }
        String textures = "ewogICJ0aW1lc3RhbXAiIDogMCwKICAicHJvZmlsZUlk" + texturePropertyValue.split("cHJvZmlsZUlk")[1];
        class_1799 playerHeadStack = HeadFunctions.getNewTexturedHead(playerName, textures, gameProfile.id(), noteBlockSound, amount);
        playerHeadStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(playerName + "'s Head")));
        return playerHeadStack;
    }

    public static class_1799 getNewTexturedHead(String entityName, String texture, String uuidString, Integer amount) {
        return HeadFunctions.getNewTexturedHead(entityName, texture, uuidString, "", amount);
    }

    public static class_1799 getNewTexturedHead(String entityName, String texture, String uuidString, String noteBlockSound, Integer amount) {
        UUID uuid = UUIDFunctions.getUUIDFromStringLenient(uuidString);
        int[] intArray = class_4844.method_26275((UUID)uuid);
        return HeadFunctions.getNewTexturedHead(entityName, texture, uuid, noteBlockSound, amount);
    }

    public static class_1799 getNewTexturedHead(String entityName, String texture, UUID uuid, Integer amount) {
        return HeadFunctions.getNewTexturedHead(entityName, texture, uuid, "", amount);
    }

    public static class_1799 getNewTexturedHead(String entityName, String texture, UUID uuid, String noteBlockSound, Integer amount) {
        if (entityName.length() > 16) {
            entityName = entityName.substring(0, 16);
        }
        class_1799 texturedHeadStack = new class_1799((class_1935)class_1802.field_8575, amount.intValue());
        GameProfile gameProfile = new GameProfile(uuid, entityName.replace(" ", "_"));
        PropertyMap propertyMap = gameProfile.properties();
        HashMultimap mutableProperties = HashMultimap.create((Multimap)propertyMap);
        mutableProperties.put((Object)"textures", (Object)new Property("textures", texture));
        GameProfile newGameProfile = new GameProfile(uuid, entityName.replace(" ", "_"), new PropertyMap((Multimap)mutableProperties));
        texturedHeadStack.method_57379(class_9334.field_49617, (Object)class_9296.method_73307((GameProfile)newGameProfile));
        if (!noteBlockSound.isEmpty()) {
            texturedHeadStack.method_57379(class_9334.field_49618, (Object)class_2960.method_60654((String)noteBlockSound));
        }
        return texturedHeadStack;
    }

    public static GameProfile getGameProfileFromPlayerName(class_3218 serverLevel, String playerName) {
        GameProfile gameProfile;
        UUID headUUID;
        MinecraftSessionService minecraftSessionService = serverLevel.method_8503().method_73550().comp_837();
        MinecraftServer minecraftServer = serverLevel.method_8503();
        class_11561 userNameToIdResolver = minecraftServer.method_73550().comp_4407();
        if (PlayerHeadCacheFeature.cachedPlayerNamesMap.containsKey(playerName.toLowerCase())) {
            headUUID = PlayerHeadCacheFeature.cachedPlayerNamesMap.get(playerName.toLowerCase());
            playerName = PlayerHeadCacheFeature.cachedPlayerUUIDsMap.get(headUUID);
        } else {
            Optional optionalNameAndId = userNameToIdResolver.method_14515(playerName);
            if (optionalNameAndId.isEmpty()) {
                return null;
            }
            headUUID = ((class_11560)optionalNameAndId.get()).comp_4422();
            Optional optionalGameProfile = minecraftServer.method_73550().comp_4624().method_73289(playerName);
            if (optionalGameProfile.isEmpty() && (optionalGameProfile = minecraftServer.method_73550().comp_4624().method_73290(headUUID)).isEmpty()) {
                return null;
            }
            GameProfile playerNameGameProfile = (GameProfile)optionalGameProfile.get();
            PlayerHeadCacheFeature.cachedPlayerNamesMap.put(playerNameGameProfile.name().toLowerCase(), headUUID);
            PlayerHeadCacheFeature.cachedPlayerUUIDsMap.put(headUUID, playerNameGameProfile.name());
        }
        if (PlayerHeadCacheFeature.cachedGameProfileMap.containsKey(headUUID)) {
            gameProfile = PlayerHeadCacheFeature.cachedGameProfileMap.get(headUUID);
        } else {
            ProfileResult profileResult = minecraftSessionService.fetchProfile(headUUID, false);
            if (profileResult == null) {
                return null;
            }
            gameProfile = profileResult.profile();
            if (gameProfile == null) {
                return null;
            }
            PlayerHeadCacheFeature.cachedGameProfileMap.put(headUUID, gameProfile);
        }
        return gameProfile;
    }

    public static boolean hasStandardHead(String mobname) {
        return mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton");
    }
}

