/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.core.fluid.fabric;

import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
class ArchitecturyFluidRenderingFabric
implements FluidVariantRenderHandler,
FluidRenderHandler {
    private final ArchitecturyFluidAttributes attributes;
    private class_1059 atlas = null;
    private final class_1058[] sprites = new class_1058[2];
    private final class_1058[] spritesOverlaid = new class_1058[3];
    private final class_1058[] spritesOther = new class_1058[2];
    private final class_1058[] spritesOtherOverlaid = new class_1058[3];

    public ArchitecturyFluidRenderingFabric(ArchitecturyFluidAttributes attributes) {
        this.attributes = attributes;
    }

    @Nullable
    public class_1058[] getSprites(FluidVariant variant) {
        FluidStack stack = FluidStackHooksFabric.fromFabric(variant, FluidStack.bucketAmount());
        class_2960 overlayTexture = this.attributes.getOverlayTexture(stack);
        class_1058 overlaySprite = overlayTexture == null ? null : this.atlas.method_4608(overlayTexture);
        class_1058[] sprites = overlaySprite == null ? this.sprites : this.spritesOverlaid;
        sprites[0] = this.atlas.method_4608(this.attributes.getSourceTexture(stack));
        sprites[1] = this.atlas.method_4608(this.attributes.getFlowingTexture(stack));
        if (overlaySprite != null) {
            sprites[2] = overlaySprite;
        }
        return sprites;
    }

    public int getColor(FluidVariant variant, @Nullable class_1920 view, @Nullable class_2338 pos) {
        return this.attributes.getColor(FluidStackHooksFabric.fromFabric(variant, FluidStack.bucketAmount()), view, pos);
    }

    public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        class_2960 overlayTexture = this.attributes.getOverlayTexture(state, view, pos);
        class_1058 overlaySprite = overlayTexture == null ? null : this.atlas.method_4608(overlayTexture);
        class_1058[] sprites = overlaySprite == null ? this.spritesOther : this.spritesOtherOverlaid;
        sprites[0] = this.atlas.method_4608(this.attributes.getSourceTexture(state, view, pos));
        sprites[1] = this.atlas.method_4608(this.attributes.getFlowingTexture(state, view, pos));
        if (overlaySprite != null) {
            sprites[2] = overlaySprite;
        }
        return sprites;
    }

    public int getFluidColor(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        return this.attributes.getColor(state, view, pos);
    }

    public void reloadTextures(class_1059 atlas) {
        this.atlas = atlas;
    }
}

