/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node.parent;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.impl.GeneralUtils;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_9848;

public final class DynamicShadowNode
extends ParentNode {
    private final float scale;
    private final float alpha;

    public DynamicShadowNode(TextNode[] children) {
        this(children, 0.25f, 1.0f);
    }

    public DynamicShadowNode(TextNode[] children, float scale, float alpha) {
        super(children);
        this.scale = scale;
        this.alpha = alpha;
    }

    @Override
    protected class_2561 applyFormatting(class_5250 out, ParserContext context) {
        Transformer transformer = context.get(ParserContext.Key.DEFAULT_SHADOW_STYLER);
        if (transformer == null) {
            int defaultColor = DynamicShadowNode.modifiedColor(out.method_10866().method_10973() != null ? out.method_10866().method_10973().method_27716() : 0xFFFFFF, this.scale, this.alpha);
            return GeneralUtils.cloneTransformText((class_2561)out, text -> {
                class_5251 color = text.method_10866().method_10973();
                return text.method_10862(text.method_10866().method_65302(color != null ? DynamicShadowNode.modifiedColor(color.method_27716(), this.scale, this.alpha) : defaultColor));
            }, text -> text == out || text.method_10866().method_65301() == null && text.method_10866().method_10973() != null);
        }
        return transformer.applyShadowColors((class_2561)out, this.scale, this.alpha, context);
    }

    public static int modifiedColor(int color, float scale, float alpha) {
        return class_9848.method_61321((int)color, (float)scale) | 0xFF000000;
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children) {
        return new DynamicShadowNode(children, this.scale, this.alpha);
    }

    @Override
    public String toString() {
        return "DynamicShadowNode{scale=" + this.scale + "}";
    }

    public static interface Transformer {
        public class_2561 applyShadowColors(class_2561 var1, float var2, float var3, ParserContext var4);

        default public boolean hasShadowColor(ParserContext context) {
            return true;
        }
    }

    public static interface SimpleColoredTransformer
    extends Transformer {
        @Override
        default public class_2561 applyShadowColors(class_2561 out, float scale, float alpha, ParserContext context) {
            int defaultColor = this.getDefaultShadowColor(out, scale, alpha, context);
            return GeneralUtils.cloneTransformText(out, text -> {
                class_5251 color = text.method_10866().method_10973();
                return text.method_10862(text.method_10866().method_65302(color != null ? DynamicShadowNode.modifiedColor(color.method_27716(), scale, alpha) : defaultColor));
            }, text -> text == out || text.method_10866().method_65301() == null && text.method_10866().method_10973() != null);
        }

        public int getDefaultShadowColor(class_2561 var1, float var2, float var3, ParserContext var4);
    }
}

