/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.timeline;

import net.minecraft.class_11910;
import net.minecraft.class_3417;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.client.gui.control.timeline.GuiClientTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiClientTimelineChannel<T extends GuiTimelineChannel<K>, K>
extends GuiClientParent<T>
implements GuiTimelineChannel.GuiTimelineChannelDist<K> {
    private GuiTimelineKey<T> dragged;

    public GuiClientTimelineChannel(T control) {
        super(control);
    }

    public GuiClientTimeline timeline() {
        return (GuiClientTimeline)((GuiTimelineChannel)this.control).timeline.dist();
    }

    @Override
    public void keyInitialFlow(GuiTimelineKey<K> key) {
        GuiControlRect rect = ((GuiClientControl)((Object)key.dist())).rect;
        rect.setWidth(rect.getPreferredWidth(0), 0);
        rect.flowX();
        rect.setHeight(rect.getPreferredHeight(0), 0);
        rect.flowY();
        rect.setY((int)Math.ceil((double)this.rect.getContentHeight() / 2.0 - (double)rect.getHeight() / 2.0));
    }

    @Override
    public void dragKey(GuiTimelineKey key) {
        this.dragged = key;
    }

    @Override
    public void flowX(int width, int preferred) {
        for (GuiClientControl control : this.controls()) {
            control.rect.setWidth(control.rect.getPreferredWidth(0), 0);
            control.rect.flowX();
        }
        ((GuiTimelineChannel)this.control).timeline.adjustKeysPositionX();
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.NESTED;
    }

    @Override
    public double getOffsetX() {
        return -this.timeline().scrolledX();
    }

    @Override
    public void mouseMoved(double x, double y) {
        int tick;
        if (this.dragged != null && this.dragged.channel.isSpaceFor(this.dragged, tick = Math.max(0, this.timeline().getTimeAt(x)))) {
            this.dragged.tick = tick;
            ((GuiTimelineChannel)this.control).timeline.adjustKeyPositionX(this.dragged);
        }
        super.mouseMoved(x, y);
    }

    @Override
    public void mouseReleased(double x, double y, class_11910 info) {
        if (this.dragged != null) {
            this.dragged.channel.movedKey(this.dragged);
            this.dragged = null;
        }
        super.mouseReleased(x, y, info);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double delta) {
        this.timeline().scrolled(this.rect.getWidth(), x, delta);
        return true;
    }

    @Override
    public boolean mouseClicked(double x, double y, class_11910 info) {
        boolean result = super.mouseClicked(x, y, info);
        if (!result && info.comp_4801() == 1) {
            GuiTimelineKey key;
            int time = this.timeline().getTimeAt(x);
            if (((GuiTimelineChannel)this.control).isSpaceFor(null, time) && (key = ((GuiTimelineChannel)this.control).addKey(time, ((GuiTimelineChannel)this.control).getValueAt(time))) != null) {
                ((GuiTimelineChannel)this.control).select(key);
                this.playSound(class_3417.field_14667, 0.1f, 0.6f);
            }
            return true;
        }
        return result;
    }
}

