/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.box;

import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_777;
import team.creative.creativecore.client.render.box.QuadGeneratorContext;
import team.creative.creativecore.client.render.face.RenderBoxFace;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class RenderBox
extends AlignedBox {
    private static final VectorFan DOWN = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 1.0f)});
    private static final VectorFan UP = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    private static final VectorFan NORTH = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f)});
    private static final VectorFan SOUTH = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f)});
    private static final VectorFan WEST = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 1.0f)});
    private static final VectorFan EAST = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    public class_2680 state;
    public int color = -1;
    public boolean keepVU = false;
    public boolean allowOverlap = false;
    public boolean doesNeedQuadUpdate = true;
    public boolean needsResorting = false;
    public boolean emissive = false;
    private RenderBoxFace renderEast = RenderBoxFace.RENDER;
    private RenderBoxFace renderWest = RenderBoxFace.RENDER;
    private RenderBoxFace renderUp = RenderBoxFace.RENDER;
    private RenderBoxFace renderDown = RenderBoxFace.RENDER;
    private RenderBoxFace renderSouth = RenderBoxFace.RENDER;
    private RenderBoxFace renderNorth = RenderBoxFace.RENDER;
    private Object quadEast = null;
    private Object quadWest = null;
    private Object quadUp = null;
    private Object quadDown = null;
    private Object quadSouth = null;
    private Object quadNorth = null;
    public Object customData;

    public RenderBox(AlignedBox cube) {
        super(cube);
    }

    public RenderBox(AlignedBox cube, RenderBox box) {
        super(cube);
        this.state = box.state;
        this.color = box.color;
        this.renderEast = box.renderEast;
        this.renderWest = box.renderWest;
        this.renderUp = box.renderUp;
        this.renderDown = box.renderDown;
        this.renderSouth = box.renderSouth;
        this.renderNorth = box.renderNorth;
    }

    public RenderBox(AlignedBox cube, class_2680 state) {
        super(cube);
        this.state = state;
    }

    public RenderBox(AlignedBox cube, class_2248 block) {
        this(cube, block.method_9564());
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, class_2680 state) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.state = state;
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, class_2248 block) {
        this(minX, minY, minZ, maxX, maxY, maxZ, block.method_9564());
    }

    public RenderBox setColor(int color) {
        this.color = color;
        return this;
    }

    public RenderBox setKeepUV(boolean keep) {
        this.keepVU = keep;
        return this;
    }

    public void setQuad(Facing facing, List<class_777> quads) {
        class_777 quad = quads == null || quads.isEmpty() ? null : (quads.size() == 1 ? quads.get(0) : quads);
        switch (facing) {
            case DOWN: {
                this.quadDown = quad;
                break;
            }
            case EAST: {
                this.quadEast = quad;
                break;
            }
            case NORTH: {
                this.quadNorth = quad;
                break;
            }
            case SOUTH: {
                this.quadSouth = quad;
                break;
            }
            case UP: {
                this.quadUp = quad;
                break;
            }
            case WEST: {
                this.quadWest = quad;
            }
        }
    }

    public Object getQuad(Facing facing) {
        switch (facing) {
            case DOWN: {
                return this.quadDown;
            }
            case EAST: {
                return this.quadEast;
            }
            case NORTH: {
                return this.quadNorth;
            }
            case SOUTH: {
                return this.quadSouth;
            }
            case UP: {
                return this.quadUp;
            }
            case WEST: {
                return this.quadWest;
            }
        }
        return null;
    }

    public int countQuads() {
        int quads = 0;
        if (this.quadUp != null) {
            quads += this.quadUp instanceof List ? ((List)this.quadUp).size() : 1;
        }
        if (this.quadDown != null) {
            quads += this.quadDown instanceof List ? ((List)this.quadDown).size() : 1;
        }
        if (this.quadEast != null) {
            quads += this.quadEast instanceof List ? ((List)this.quadEast).size() : 1;
        }
        if (this.quadWest != null) {
            quads += this.quadWest instanceof List ? ((List)this.quadWest).size() : 1;
        }
        if (this.quadSouth != null) {
            quads += this.quadSouth instanceof List ? ((List)this.quadSouth).size() : 1;
        }
        if (this.quadNorth != null) {
            quads += this.quadNorth instanceof List ? ((List)this.quadNorth).size() : 1;
        }
        return quads;
    }

    public void setFace(Facing facing, RenderBoxFace face) {
        switch (facing) {
            case DOWN: {
                this.renderDown = face;
                break;
            }
            case EAST: {
                this.renderEast = face;
                break;
            }
            case NORTH: {
                this.renderNorth = face;
                break;
            }
            case SOUTH: {
                this.renderSouth = face;
                break;
            }
            case UP: {
                this.renderUp = face;
                break;
            }
            case WEST: {
                this.renderWest = face;
            }
        }
    }

    public RenderBoxFace getFace(Facing facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Facing.EAST -> this.renderEast;
            case Facing.WEST -> this.renderWest;
            case Facing.UP -> this.renderUp;
            case Facing.DOWN -> this.renderDown;
            case Facing.SOUTH -> this.renderSouth;
            case Facing.NORTH -> this.renderNorth;
        };
    }

    public boolean shouldRenderFace(Facing facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Facing.EAST -> this.renderEast.shouldRender();
            case Facing.WEST -> this.renderWest.shouldRender();
            case Facing.UP -> this.renderUp.shouldRender();
            case Facing.DOWN -> this.renderDown.shouldRender();
            case Facing.SOUTH -> this.renderSouth.shouldRender();
            case Facing.NORTH -> this.renderNorth.shouldRender();
        };
    }

    public boolean intersectsWithFace(Facing facing, QuadGeneratorContext holder, class_2338 offset) {
        switch (facing.axis) {
            case X: {
                return holder.maxY > this.minY - (float)offset.method_10264() && holder.minY < this.maxY - (float)offset.method_10264() && holder.maxZ > this.minZ - (float)offset.method_10260() && holder.minZ < this.maxZ - (float)offset.method_10260();
            }
            case Y: {
                return holder.maxX > this.minX - (float)offset.method_10263() && holder.minX < this.maxX - (float)offset.method_10263() && holder.maxZ > this.minZ - (float)offset.method_10260() && holder.minZ < this.maxZ - (float)offset.method_10260();
            }
            case Z: {
                return holder.maxX > this.minX - (float)offset.method_10263() && holder.minX < this.maxX - (float)offset.method_10263() && holder.maxY > this.minY - (float)offset.method_10264() && holder.minY < this.maxY - (float)offset.method_10264();
            }
        }
        return false;
    }

    protected Object getRenderQuads(Facing facing) {
        if (this.getFace(facing).hasCachedFans()) {
            return this.getFace(facing).getCachedFans();
        }
        switch (facing) {
            case DOWN: {
                return DOWN;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    protected float getOffsetX() {
        return this.minX;
    }

    protected float getOffsetY() {
        return this.minY;
    }

    protected float getOffsetZ() {
        return this.minZ;
    }

    protected float getOverallScale(Facing facing) {
        return this.getFace(facing).getScale();
    }

    protected float getScaleX() {
        return this.maxX - this.minX;
    }

    protected float getScaleY() {
        return this.maxY - this.minY;
    }

    protected float getScaleZ() {
        return this.maxZ - this.minZ;
    }

    protected boolean scaleAndOffsetQuads(Facing facing) {
        return true;
    }

    protected boolean onlyScaleOnceNoOffset(Facing facing) {
        return this.getFace(facing).hasCachedFans();
    }

    public void deleteQuadCache() {
        this.doesNeedQuadUpdate = true;
        this.quadEast = null;
        this.quadWest = null;
        this.quadUp = null;
        this.quadDown = null;
        this.quadSouth = null;
        this.quadNorth = null;
    }

    protected boolean previewScalingAndOffset() {
        return true;
    }

    public float getPreviewOffX() {
        return this.minX;
    }

    public float getPreviewOffY() {
        return this.minY;
    }

    public float getPreviewOffZ() {
        return this.minZ;
    }

    public float getPreviewScaleX() {
        return this.maxX - this.minX;
    }

    public float getPreviewScaleY() {
        return this.maxY - this.minY;
    }

    public float getPreviewScaleZ() {
        return this.maxZ - this.minZ;
    }

    public boolean isTranslucent() {
        if (ColorUtils.isTransparent(this.color)) {
            return true;
        }
        return !this.state.method_51367();
    }

    private static class VectorFanSimple
    extends VectorFan {
        public VectorFanSimple(Vec3f[] coords) {
            super(coords);
        }
    }
}

