/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.key.ConfigKeyType;
import team.creative.creativecore.common.config.sync.ConfigurationChangePacket;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.parent.GuiTable;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.mc.JsonUtils;
import team.creative.creativecore.common.util.text.TextBuilder;

public class ConfigGuiLayer
extends GuiLayer {
    public JsonObject ROOT = new JsonObject();
    public Side side;
    public final ICreativeConfigHolder rootHolder;
    public ICreativeConfigHolder holder;
    public int nextAction;
    public boolean force;

    public ConfigGuiLayer(boolean client, ICreativeConfigHolder holder, Side side) {
        super(client, "config", 420, 234);
        this.setFlow(GuiFlow.STACK_Y);
        this.rootHolder = holder;
        this.holder = holder;
        this.side = side;
    }

    @Override
    public void create() {
        this.loadHolder(this.holder);
    }

    public void savePage() {
        GuiTable table = (GuiTable)this.get("box.table");
        JsonObject parent = null;
        for (GuiControl control : table) {
            GuiConfigControl c;
            JsonElement element;
            if (!(control instanceof GuiConfigControl) || (element = (c = (GuiConfigControl)control).save()) == null) continue;
            if (parent == null) {
                parent = JsonUtils.get(this.ROOT, this.holder.path());
            }
            parent.add(c.field.name, element);
        }
    }

    public void loadHolder(ICreativeConfigHolder holder) {
        if (!this.isEmpty()) {
            this.savePage();
            this.clear();
        }
        GuiLeftRightBox upperBox = new GuiLeftRightBox(this);
        upperBox.addLeft(new GuiLabel(this, "path").setTitle((class_2561)class_2561.method_43470((String)("/" + String.join((CharSequence)"/", holder.path())))));
        upperBox.addRight(new GuiButton(this, "back", x -> this.loadHolder(holder.parent())).setTranslate("gui.back").setEnabled(holder != this.rootHolder));
        this.holder = holder;
        this.add((GuiControl)upperBox);
        GuiScrollY box = new GuiScrollY((IGuiParent)this, "box").setDim(100, 100).setExpandable();
        this.add((GuiControl)box);
        GuiTable table = new GuiTable((IGuiParent)this, "table").setExpandable();
        box.add((GuiControl)table);
        JsonObject json = JsonUtils.tryGet(this.ROOT, holder.path());
        for (ConfigKey configKey : holder.fields()) {
            if (configKey.requiresRestart || configKey.hideFromGUI) continue;
            String path = "config." + String.join((CharSequence)".", holder.path());
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            String caption = ConfigGuiLayer.translateOrDefault(path + configKey.name + ".name", configKey.name);
            String comment = path + configKey.name + ".comment";
            if (configKey.isFolder()) {
                if (configKey.holder().isEmpty(this.side)) continue;
                GuiRow row = new GuiRow(this);
                table.addRow(row);
                GuiColumn col = new GuiColumn(this);
                row.addColumn(col);
                col.add(new GuiButton(this, caption, x -> this.loadHolder(key.holder())).setTitle((class_2561)class_2561.method_43470((String)caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
                continue;
            }
            if (!configKey.is(this.side)) continue;
            GuiConfigControl control = new GuiConfigControl((IGuiParent)this, (ConfigKeyType)configKey, this.side, caption, comment);
            table.addRow(control);
            control.init(json != null ? json.get(configKey.name) : null);
        }
        GuiLeftRightBox lowerBox = new GuiLeftRightBox(this).addLeft(new GuiButton(this, "cancel", x -> {
            this.nextAction = 0;
            this.closeTopLayer();
        }).setTitle((class_2561)class_2561.method_43471((String)"gui.cancel")));
        if (this.side.isServer()) {
            lowerBox.addLeft(new GuiButton(this, "client-config", x -> {
                this.nextAction = 1;
                this.closeTopLayer();
            }).setTitle((class_2561)class_2561.method_43471((String)"gui.client-config")));
        }
        lowerBox.addRight(new GuiButton(this, "save", x -> {
            this.nextAction = 0;
            this.savePage();
            this.sendUpdate();
            this.force = true;
            this.closeTopLayer();
        }).setTranslate("gui.save"));
        this.add((GuiControl)lowerBox);
        this.reinit();
    }

    public void sendUpdate() {
        if (this.side.isServer()) {
            this.getIntegratedParent().send(new ConfigurationChangePacket(this.rootHolder, this.ROOT));
        } else {
            this.rootHolder.load(this.provider(), false, true, JsonUtils.get(this.ROOT, this.rootHolder.path()), Side.CLIENT);
            CreativeCore.CONFIG_HANDLER.save(this.provider(), Side.CLIENT);
        }
    }

    @Override
    public void closeTopLayer() {
        this.savePage();
        if (this.force || this.ROOT.size() == 0) {
            if (this.nextAction == 0) {
                super.closeTopLayer();
            } else if (this.nextAction == 1) {
                CreativeCore.CONFIG_CLIENT_SYNC_OPEN.open(this.getPlayer());
            }
        } else {
            GuiDialogHandler.openDialog(this.getIntegratedParent(), "savechanges", (x, y) -> {
                if (y == DialogGuiLayer.DialogButton.YES) {
                    this.savePage();
                    this.sendUpdate();
                }
                if (y != DialogGuiLayer.DialogButton.CANCEL) {
                    this.force = true;
                    this.closeTopLayer();
                }
            }, DialogGuiLayer.DialogButton.YES, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.CANCEL);
        }
    }
}

