/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.player;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_3222;
import net.minecraft.class_3327;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorButton;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class PlayerSelector {
    public static final NamedTypeRegistry<PlayerSelector> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);

    public static PlayerSelector read(class_2487 nbt) {
        Class<PlayerSelector> clazz = REGISTRY.get(nbt.method_68564("id", ""));
        if (clazz == null) {
            throw new RuntimeException("Could not find player selector for " + String.valueOf(nbt.method_10558("id")));
        }
        try {
            PlayerSelector selector = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            selector.readFromNBT(nbt);
            return selector;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("PlayerSelector type " + String.valueOf(nbt.method_10558("id")) + " does not have an empty constructor!");
        }
    }

    public abstract boolean is(class_1657 var1);

    public abstract void readFromNBT(class_2487 var1);

    protected abstract void write(class_2487 var1);

    public abstract String info();

    public class_2487 writeToNBT(class_2487 nbt) {
        this.write(nbt);
        nbt.method_10582("id", REGISTRY.getId(this.getClass()));
        return nbt;
    }

    static {
        REGISTRY.register("and", PlayerSelectorAnd.class);
        REGISTRY.register("or", PlayerSelectorOr.class);
        REGISTRY.register("not", PlayerSelectorNot.class);
        REGISTRY.register("level", PlayerSelectorLevel.class);
        REGISTRY.register("mode", PlayerSelectorGamemode.class);
        REGISTRY.register("selector", PlayerSelectorCommandSelector.class);
        ConfigTypeConveration.registerSpecialType(PlayerSelector.class::isAssignableFrom, new ConfigTypeConveration.SimpleConfigTypeConveration<PlayerSelector>(){

            @Override
            public PlayerSelector readElement(ConfigKey key, PlayerSelector defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return PlayerSelector.read(class_2522.method_67315((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        CreativeCore.LOGGER.error((Object)e);
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(PlayerSelector value, ConfigKey key, Side side) {
                return new JsonPrimitive(value.writeToNBT(new class_2487()).toString());
            }

            @Override
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add((GuiControl)new GuiPlayerSelectorButton((IGuiParent)parent, "data", new PlayerSelectorLevel(0)));
            }

            @Override
            public void loadValue(PlayerSelector value, GuiParent parent) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)parent.get("data");
                button.set(value);
            }

            @Override
            protected PlayerSelector saveValue(GuiParent parent, ConfigKey key) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)parent.get("data");
                return button.get();
            }

            @Override
            public PlayerSelector set(ConfigKey key, PlayerSelector value) {
                return value;
            }
        });
    }

    public static class PlayerSelectorAnd
    extends PlayerSelector {
        public PlayerSelector[] selectors;

        public PlayerSelectorAnd() {
        }

        public PlayerSelectorAnd(PlayerSelector ... selector) {
            this.selectors = selector;
        }

        @Override
        public boolean is(class_1657 player) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].is(player)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void readFromNBT(class_2487 nbt) {
            class_2499 list = nbt.method_68569("selectors");
            this.selectors = new PlayerSelector[list.size()];
            for (int i = 0; i < this.selectors.length; ++i) {
                this.selectors[i] = PlayerSelector.read(list.method_68582(i));
            }
        }

        @Override
        protected void write(class_2487 nbt) {
            class_2499 list = new class_2499();
            for (int i = 0; i < this.selectors.length; ++i) {
                list.add((Object)this.selectors[i].writeToNBT(new class_2487()));
            }
            nbt.method_10566("selectors", (class_2520)list);
        }

        @Override
        public String info() {
            StringBuilder text = new StringBuilder("[");
            for (int i = 0; i < this.selectors.length; ++i) {
                if (i > 0) {
                    text.append("&");
                }
                text.append(this.selectors[i].info());
            }
            return String.valueOf(text) + "]";
        }
    }

    public static class PlayerSelectorOr
    extends PlayerSelector {
        public PlayerSelector[] selectors;

        public PlayerSelectorOr() {
        }

        public PlayerSelectorOr(PlayerSelector ... selector) {
            this.selectors = selector;
        }

        @Override
        public boolean is(class_1657 player) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (!this.selectors[i].is(player)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void readFromNBT(class_2487 nbt) {
            class_2499 list = nbt.method_68569("selectors");
            this.selectors = new PlayerSelector[list.size()];
            for (int i = 0; i < this.selectors.length; ++i) {
                this.selectors[i] = PlayerSelector.read(list.method_68582(i));
            }
        }

        @Override
        protected void write(class_2487 nbt) {
            class_2499 list = new class_2499();
            for (int i = 0; i < this.selectors.length; ++i) {
                list.add((Object)this.selectors[i].writeToNBT(new class_2487()));
            }
            nbt.method_10566("selectors", (class_2520)list);
        }

        @Override
        public String info() {
            StringBuilder text = new StringBuilder("[");
            for (int i = 0; i < this.selectors.length; ++i) {
                if (i > 0) {
                    text.append("|");
                }
                text.append(this.selectors[i].info());
            }
            return String.valueOf(text) + "]";
        }
    }

    public static class PlayerSelectorNot
    extends PlayerSelector {
        public PlayerSelector selector;

        public PlayerSelectorNot() {
        }

        public PlayerSelectorNot(PlayerSelector selector) {
            this.selector = selector;
        }

        @Override
        public boolean is(class_1657 player) {
            return !this.selector.is(player);
        }

        @Override
        public void readFromNBT(class_2487 nbt) {
            this.selector = PlayerSelector.read(nbt.method_68568("child"));
        }

        @Override
        protected void write(class_2487 nbt) {
            nbt.method_10566("child", (class_2520)this.selector.writeToNBT(new class_2487()));
        }

        @Override
        public String info() {
            return "!" + this.selector.info();
        }
    }

    public static class PlayerSelectorLevel
    extends PlayerSelector {
        public int permissionLevel;

        public PlayerSelectorLevel() {
        }

        public PlayerSelectorLevel(int permissionLevel) {
            this.permissionLevel = permissionLevel;
        }

        @Override
        public boolean is(class_1657 player) {
            if (player instanceof class_3222) {
                class_3327 entry = (class_3327)player.method_73183().method_8503().method_3760().method_14603().method_14640((Object)player.method_72498());
                if (entry != null) {
                    return entry.method_14623() >= this.permissionLevel;
                }
                return player.method_73183().method_8503().method_3798() >= this.permissionLevel;
            }
            return true;
        }

        @Override
        public void readFromNBT(class_2487 nbt) {
            this.permissionLevel = nbt.method_68083("level", 0);
        }

        @Override
        protected void write(class_2487 nbt) {
            nbt.method_10569("level", this.permissionLevel);
        }

        @Override
        public String info() {
            return "level>=" + this.permissionLevel;
        }
    }

    public static class PlayerSelectorGamemode
    extends PlayerSelector {
        public class_1934 type;

        public PlayerSelectorGamemode() {
        }

        public PlayerSelectorGamemode(class_1934 type) {
            this.type = type;
        }

        @Override
        public boolean is(class_1657 player) {
            return player.method_68876() == this.type;
        }

        @Override
        public void readFromNBT(class_2487 nbt) {
            this.type = class_1934.method_8384((int)nbt.method_68083("mode", 0));
        }

        @Override
        protected void write(class_2487 nbt) {
            nbt.method_10569("mode", this.type.method_8379());
        }

        @Override
        public String info() {
            return this.type.method_8381();
        }
    }

    public static class PlayerSelectorCommandSelector
    extends PlayerSelector {
        public String pattern;

        public PlayerSelectorCommandSelector() {
        }

        public PlayerSelectorCommandSelector(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean is(class_1657 player) {
            try {
                if (player instanceof class_3222) {
                    return class_2186.method_9308().method_61178(new StringReader(this.pattern)).method_9813(player.method_73183().method_8503().method_3739()).contains(player);
                }
                return true;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return false;
            }
        }

        @Override
        public void readFromNBT(class_2487 nbt) {
            this.pattern = nbt.method_68564("pattern", "");
        }

        @Override
        protected void write(class_2487 nbt) {
            nbt.method_10582("pattern", this.pattern);
        }

        @Override
        public String info() {
            return this.pattern;
        }
    }
}

