/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import dzwdz.chat_heads.ChatHeads;
import dzwdz.chat_heads.HeadData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_11722;
import net.minecraft.class_11724;
import net.minecraft.class_11885;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9296;
import org.jetbrains.annotations.Nullable;

public class ComponentProcessor {
    public static void walkTree(class_2561 component, Consumer<class_2561> consumer) {
        consumer.accept(component);
        for (class_2561 sibling : component.method_10855()) {
            ComponentProcessor.walkTree(sibling, consumer);
        }
    }

    public static ArrayList<class_2561> split(class_2561 component) {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        ComponentProcessor.walkTree(component, c -> {
            class_5250 copy = c.method_27662().method_10862(c.method_10866());
            components.add((class_2561)copy);
        });
        return components;
    }

    public static class_2561 join(List<class_2561> components) {
        if (components.isEmpty()) {
            return class_2561.method_43473();
        }
        class_2561 combined = components.getFirst();
        components.stream().skip(1L).forEach(c -> combined.method_10855().add(c));
        return combined;
    }

    public static void walkLiteralSequencesAndTranslatables(ArrayList<class_2561> components, Predicate<FoundLiteralSequence> literalsCallback, Predicate<FoundTranslatable> translatableCallback) {
        StringBuilder textSequence = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < components.size(); ++i) {
            class_2588 translatableContents;
            class_7417 contents = components.get(i).method_10851();
            if (contents instanceof class_8828) {
                class_8828 textContents = (class_8828)contents;
                if (startIndex == -1) {
                    startIndex = i;
                }
                endIndex = i;
                textSequence.append(textContents.comp_737());
                continue;
            }
            if (!textSequence.isEmpty() && literalsCallback.test(new FoundLiteralSequence(textSequence.toString(), startIndex, endIndex))) {
                return;
            }
            textSequence = new StringBuilder();
            startIndex = -1;
            if (!(contents instanceof class_2588) || !translatableCallback.test(new FoundTranslatable(translatableContents = (class_2588)contents, i))) continue;
            return;
        }
        endIndex = components.size() - 1;
        if (!textSequence.isEmpty() && literalsCallback.test(new FoundLiteralSequence(textSequence.toString(), startIndex, endIndex))) {
            return;
        }
    }

    public static String codePointSubstring(String string, int start) {
        return string.substring(string.offsetByCodePoints(0, start));
    }

    public static String codePointSubstring(String string, int start, int end) {
        int i = string.offsetByCodePoints(0, start);
        int j = string.offsetByCodePoints(i, end - start);
        return string.substring(i, j);
    }

    @Nullable
    public static Pair<class_5250, class_5250> splitLiteral(class_2561 literal, int i) {
        if (i == 0) {
            return null;
        }
        String text = ((class_8828)literal.method_10851()).comp_737();
        String leftText = ComponentProcessor.codePointSubstring(text, 0, i);
        String rightText = ComponentProcessor.codePointSubstring(text, i);
        class_5250 left = class_2561.method_43470((String)leftText).method_10862(literal.method_10866());
        class_5250 right = class_2561.method_43470((String)rightText).method_10862(literal.method_10866());
        literal.method_10855().forEach(arg_0 -> ((class_5250)right).method_10852(arg_0));
        return new Pair((Object)left, (Object)right);
    }

    @Nullable
    public static class_640 addChatHeadForClickTellCommand(ArrayList<class_2561> components, ChatHeads.PlayerInfoCache playerInfoCache) {
        for (int i = 0; i < components.size(); ++i) {
            int finalI;
            class_2588 translatable;
            class_640 playerInfo;
            class_640 playerInfo2;
            class_2561 c = components.get(i);
            String profileName = ComponentProcessor.getTellReceiver(c);
            if (profileName != null && (playerInfo2 = playerInfoCache.get(profileName)) != null) {
                class_5250 decorated = ComponentProcessor.createChatHeadComponent(playerInfo2).method_10852(c);
                components.set(i, (class_2561)decorated);
                return playerInfo2;
            }
            class_7417 decorated = c.method_10851();
            if (!(decorated instanceof class_2588) || (playerInfo = ComponentProcessor.processTranslatableArguments(translatable = (class_2588)decorated, splitArg -> ComponentProcessor.addChatHeadForClickTellCommand(splitArg, playerInfoCache), arg_0 -> ComponentProcessor.lambda$addChatHeadForClickTellCommand$3(components, finalI = i, arg_0))) == null) continue;
            return playerInfo;
        }
        return null;
    }

    @Nullable
    public static <T> T processTranslatableArguments(class_2588 translatable, Function<ArrayList<class_2561>, @Nullable T> processSplitArg, Consumer<class_2561> processedCallback) {
        Object[] args = translatable.method_11023();
        int argsLength = Objects.equals(translatable.method_11022(), "chat.type.text") ? 1 : args.length;
        for (int i = 0; i < argsLength; ++i) {
            class_2561 argComponent;
            ArrayList<class_2561> splitArg;
            T returnValue;
            Object object = args[i];
            if (object instanceof String) {
                String text = (String)object;
                args[i] = class_2561.method_43470((String)text);
            }
            if (!((object = args[i]) instanceof class_2561) || (returnValue = processSplitArg.apply(splitArg = ComponentProcessor.split(argComponent = (class_2561)object))) == null) continue;
            class_2561 processedArg = ComponentProcessor.join(splitArg);
            Object[] processedArgs = Arrays.copyOf(args, args.length);
            processedArgs[i] = processedArg;
            class_5250 processed = class_2561.method_48322((String)translatable.method_11022(), (String)translatable.method_48323(), (Object[])processedArgs);
            processedCallback.accept((class_2561)processed);
            return returnValue;
        }
        return null;
    }

    public static class_640 addChatHeadForPlayerName(ArrayList<class_2561> components, ChatHeads.PlayerInfoCache playerInfoCache) {
        class_640[] returnValue = new class_640[1];
        ComponentProcessor.walkLiteralSequencesAndTranslatables(components, literals -> {
            HeadData headData = ChatHeads.scanForPlayerName(literals.text, playerInfoCache);
            if (headData == HeadData.EMPTY) {
                return false;
            }
            int codePointIndex = headData.codePointIndex();
            for (int i = literals.startIndex; i <= literals.endIndex; ++i) {
                class_5250 decorated;
                class_2561 literal = (class_2561)components.get(i);
                class_8828 contents = (class_8828)literal.method_10851();
                int codePointCount = (int)contents.comp_737().replaceAll("\u00a7.", "").codePoints().count();
                if (codePointIndex >= codePointCount) {
                    codePointIndex -= codePointCount;
                    continue;
                }
                class_5250 chatHead = ComponentProcessor.createChatHeadComponent(headData.playerInfo());
                Pair<class_5250, class_5250> pair = ComponentProcessor.splitLiteral(literal, codePointIndex);
                if (pair == null) {
                    decorated = chatHead.method_10852(literal);
                } else {
                    class_5250 left = (class_5250)pair.getFirst();
                    class_5250 right = (class_5250)pair.getSecond();
                    decorated = left.method_10852((class_2561)chatHead).method_10852((class_2561)right);
                }
                components.set(i, (class_2561)decorated);
                returnValue[0] = headData.playerInfo();
                return true;
            }
            return false;
        }, foundTranslatable -> {
            class_2588 translatable = foundTranslatable.contents;
            class_640 foundPlayerInfo = ComponentProcessor.processTranslatableArguments(translatable, splitArg -> ComponentProcessor.addChatHeadForPlayerName(splitArg, playerInfoCache), decorated -> components.set(foundTranslatable.index, (class_2561)decorated));
            if (foundPlayerInfo != null) {
                returnValue[0] = foundPlayerInfo;
                return true;
            }
            return false;
        });
        return returnValue[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsPlayerSprite(ArrayList<class_2561> components) {
        Iterator<class_2561> iterator = components.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return false;
            }
            class_2561 c = iterator.next();
            class_7417 class_74172 = c.method_10851();
            if (!(class_74172 instanceof class_11722)) continue;
            class_11722 class_117222 = (class_11722)class_74172;
            try {
                // empty try
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            class_11724 class_117242 = class_117222.comp_4591();
            class_11724 objectInfo = class_117242;
            if (objectInfo instanceof class_11885) break;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getTellReceiver(class_2561 component) {
        class_2558 class_25582 = component.method_10866().method_10970();
        if (!(class_25582 instanceof class_2558.class_10610)) return null;
        class_2558.class_10610 class_106102 = (class_2558.class_10610)class_25582;
        try {
            String string;
            String command = string = class_106102.comp_3507();
            if (command == null) return null;
            if (!command.startsWith("/tell ")) return null;
            return command.substring("/tell ".length()).trim();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static class_5250 createChatHeadComponent(class_640 playerInfo) {
        return class_2561.method_74062((class_11724)new class_11885(class_9296.method_73307((GameProfile)playerInfo.method_2966()), playerInfo.method_65195()));
    }

    private static /* synthetic */ void lambda$addChatHeadForClickTellCommand$3(ArrayList components, int finalI, class_2561 decorated) {
        components.set(finalI, decorated);
    }

    public record FoundLiteralSequence(String text, int startIndex, int endIndex) {
    }

    public record FoundTranslatable(class_2588 contents, int index) {
    }
}

