/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import fuzs.forgeconfigapiport.fabric.impl.config.ForgeConfigApiPortConfig;
import fuzs.forgeconfigapiport.fabric.impl.config.ModConfigValues;
import fuzs.forgeconfigapiport.impl.services.CommonAbstractions;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4667;
import net.minecraft.class_500;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_638;
import net.minecraft.class_6382;
import net.minecraft.class_642;
import net.minecraft.class_7172;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import net.minecraft.class_9017;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationScreen
extends class_4667 {
    private static final String LANG_PREFIX = "neoforge.configuration.uitext.";
    private static final String SECTION = "neoforge.configuration.uitext.section";
    private static final String SECTION_TEXT = "neoforge.configuration.uitext.sectiontext";
    public static final class_2561 CRUMB_SEPARATOR = class_2561.method_43471((String)"neoforge.configuration.uitext.breadcrumb.separator").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067});
    private static final String CRUMB = "neoforge.configuration.uitext.breadcrumb.order";
    private static final String LIST_ELEMENT = "neoforge.configuration.uitext.listelement";
    private static final String RANGE_TOOLTIP = "neoforge.configuration.uitext.rangetooltip";
    private static final class_124 RANGE_TOOLTIP_STYLE = class_124.field_1080;
    private static final String FILENAME_TOOLTIP = "neoforge.configuration.uitext.filenametooltip";
    private static final class_124 FILENAME_TOOLTIP_STYLE = class_124.field_1080;
    private static final class_5250 EMPTY_LINE = class_2561.method_43470((String)"\n\n");
    public static final class_2561 TOOLTIP_CANNOT_EDIT_THIS_WHILE_ONLINE = class_2561.method_43471((String)"neoforge.configuration.uitext.notonline").method_27692(class_124.field_1061);
    public static final class_2561 TOOLTIP_CANNOT_EDIT_THIS_WHILE_OPEN_TO_LAN = class_2561.method_43471((String)"neoforge.configuration.uitext.notlan").method_27692(class_124.field_1061);
    public static final class_2561 TOOLTIP_CANNOT_EDIT_NOT_LOADED = class_2561.method_43471((String)"neoforge.configuration.uitext.notloaded").method_27692(class_124.field_1061);
    public static final class_2561 NEW_LIST_ELEMENT = class_2561.method_43471((String)"neoforge.configuration.uitext.newlistelement");
    public static final class_2561 MOVE_LIST_ELEMENT_UP = class_2561.method_43471((String)"neoforge.configuration.uitext.listelementup");
    public static final class_2561 MOVE_LIST_ELEMENT_DOWN = class_2561.method_43471((String)"neoforge.configuration.uitext.listelementdown");
    public static final class_2561 REMOVE_LIST_ELEMENT = class_2561.method_43471((String)"neoforge.configuration.uitext.listelementremove");
    public static final class_2561 UNSUPPORTED_ELEMENT = class_2561.method_43471((String)"neoforge.configuration.uitext.unsupportedelement").method_27692(class_124.field_1061);
    public static final class_2561 LONG_STRING = class_2561.method_43471((String)"neoforge.configuration.uitext.longstring").method_27692(class_124.field_1061);
    public static final class_2561 GAME_RESTART_TITLE = class_2561.method_43471((String)"neoforge.configuration.uitext.restart.game.title");
    public static final class_2561 GAME_RESTART_MESSAGE = class_2561.method_43471((String)"neoforge.configuration.uitext.restart.game.text");
    public static final class_2561 GAME_RESTART_YES = class_2561.method_43471((String)"menu.quit");
    public static final class_2561 SERVER_RESTART_TITLE = class_2561.method_43471((String)"neoforge.configuration.uitext.restart.server.title");
    public static final class_2561 SERVER_RESTART_MESSAGE = class_2561.method_43471((String)"neoforge.configuration.uitext.restart.server.text");
    public static final class_2561 RETURN_TO_MENU = class_2561.method_43471((String)"menu.returnToMenu");
    public static final class_2561 SAVING_LEVEL = class_2561.method_43471((String)"menu.savingLevel");
    public static final class_2561 RESTART_NO = class_2561.method_43471((String)"neoforge.configuration.uitext.restart.return");
    public static final class_2561 RESTART_NO_TOOLTIP = class_2561.method_43471((String)"neoforge.configuration.uitext.restart.return.tooltip").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    public static final class_2561 UNDO = class_2561.method_43471((String)"neoforge.configuration.uitext.undo");
    public static final class_2561 UNDO_TOOLTIP = class_2561.method_43471((String)"neoforge.configuration.uitext.undo.tooltip");
    public static final class_2561 RESET = class_2561.method_43471((String)"neoforge.configuration.uitext.reset");
    public static final class_2561 RESET_TOOLTIP = class_2561.method_43471((String)"neoforge.configuration.uitext.reset.tooltip");
    public static final int BIG_BUTTON_WIDTH = 310;
    protected static final TranslationChecker translationChecker = new TranslationChecker();
    protected final String mod;
    private final Function4<ConfigurationScreen, ModConfig.Type, ModConfig, class_2561, class_437> sectionScreen;
    public ModConfigSpec.RestartType needsRestart = ModConfigSpec.RestartType.NONE;
    private boolean autoClose = false;

    public ConfigurationScreen(String mod, class_437 parent) {
        this(mod, parent, (Function4<ConfigurationScreen, ModConfig.Type, ModConfig, class_2561, class_437>)((Function4)ConfigurationSectionScreen::new));
    }

    public ConfigurationScreen(String mod, class_437 parent, ConfigurationSectionScreen.Filter filter) {
        this(mod, parent, (Function4<ConfigurationScreen, ModConfig.Type, ModConfig, class_2561, class_437>)((Function4)(a, b, c, d) -> new ConfigurationSectionScreen((class_437)a, (ModConfig.Type)((Object)b), (ModConfig)c, (class_2561)d, filter)));
    }

    public ConfigurationScreen(String mod, class_437 parent, Function4<ConfigurationScreen, ModConfig.Type, ModConfig, class_2561, class_437> sectionScreen) {
        super(parent, class_310.method_1551().field_1690, (class_2561)class_2561.method_43469((String)translationChecker.check(mod + ".configuration.title", "neoforge.configuration.uitext.title"), (Object[])new Object[]{FabricLoader.getInstance().getModContainer(mod).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(mod)}));
        this.mod = mod;
        this.sectionScreen = sectionScreen;
    }

    protected void method_60325() {
        class_4185 btn = null;
        int count = 0;
        for (ModConfig.Type type : ModConfig.Type.values()) {
            boolean headerAdded = false;
            for (ModConfig modConfig : ModConfigs.getConfigSet(type)) {
                if (!modConfig.getModId().equals(this.mod) || !(modConfig.getSpec() instanceof ModConfigSpec)) continue;
                if (!headerAdded) {
                    this.field_51824.method_20407((class_339)new class_7842(310, 20, (class_2561)class_2561.method_43471((String)(LANG_PREFIX + type.name().toLowerCase(Locale.ENGLISH))).method_27692(class_124.field_1073), this.field_22793), null);
                    headerAdded = true;
                }
                btn = class_4185.method_46430((class_2561)class_2561.method_43469((String)SECTION, (Object[])new Object[]{this.translatableConfig(modConfig, "", "neoforge.configuration.uitext.type." + modConfig.getType().name().toLowerCase(Locale.ROOT))}), button -> this.field_22787.method_1507((class_437)this.sectionScreen.apply((Object)this, (Object)type, (Object)modConfig, (Object)this.translatableConfig(modConfig, ".title", "neoforge.configuration.uitext.title." + type.name().toLowerCase(Locale.ROOT))))).method_46432(310).method_46431();
                class_5250 tooltip = class_2561.method_43473();
                if (!((ModConfigSpec)modConfig.getSpec()).isLoaded()) {
                    tooltip.method_10852(TOOLTIP_CANNOT_EDIT_NOT_LOADED).method_10852((class_2561)EMPTY_LINE);
                    btn.field_22763 = false;
                    count = 99;
                } else if (type == ModConfig.Type.SERVER && this.field_22787.method_1558() != null && !this.field_22787.method_47392()) {
                    tooltip.method_10852(TOOLTIP_CANNOT_EDIT_THIS_WHILE_ONLINE).method_10852((class_2561)EMPTY_LINE);
                    btn.field_22763 = false;
                    count = 99;
                } else if (type == ModConfig.Type.SERVER && this.field_22787.method_1496() && this.field_22787.method_1576().method_3860()) {
                    tooltip.method_10852(TOOLTIP_CANNOT_EDIT_THIS_WHILE_OPEN_TO_LAN).method_10852((class_2561)EMPTY_LINE);
                    btn.field_22763 = false;
                    count = 99;
                }
                tooltip.method_10852((class_2561)class_2561.method_43469((String)FILENAME_TOOLTIP, (Object[])new Object[]{modConfig.getFileName()}).method_27692(FILENAME_TOOLTIP_STYLE));
                btn.method_47400(class_7919.method_47407((class_2561)tooltip));
                this.field_51824.method_20407((class_339)btn, null);
                ++count;
            }
        }
        if (count == 1) {
            this.autoClose = true;
            btn.method_25306((class_11907)new class_11909((double)btn.method_46426() + (double)btn.method_25368() / 2.0, (double)btn.method_46427() + (double)btn.method_25364() / 2.0, new class_11910(0, 0)));
        }
    }

    public class_2561 translatableConfig(ModConfig modConfig, String suffix, String fallback) {
        return class_2561.method_43469((String)translationChecker.check(this.mod + ".configuration.section." + modConfig.getFileName().replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase(Locale.ENGLISH) + suffix, fallback), (Object[])new Object[]{FabricLoader.getInstance().getModContainer(this.mod).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(this.mod)});
    }

    public void method_49589() {
        super.method_49589();
        if (this.autoClose) {
            this.autoClose = false;
            this.method_25419();
        }
    }

    public void method_25419() {
        translationChecker.finish();
        switch (this.needsRestart) {
            case GAME: {
                this.field_22787.method_1507((class_437)new TooltipConfirmScreen(b -> {
                    if (b) {
                        this.field_22787.method_1592();
                    } else {
                        super.method_25419();
                    }
                }, GAME_RESTART_TITLE, GAME_RESTART_MESSAGE, GAME_RESTART_YES, RESTART_NO));
                return;
            }
            case WORLD: {
                if (this.field_22787.field_1687 == null) break;
                this.field_22787.method_1507((class_437)new TooltipConfirmScreen(b -> {
                    if (b) {
                        this.onDisconnect();
                    } else {
                        super.method_25419();
                    }
                }, SERVER_RESTART_TITLE, SERVER_RESTART_MESSAGE, this.field_22787.method_1542() ? RETURN_TO_MENU : class_5244.field_45692, RESTART_NO));
                return;
            }
        }
        super.method_25419();
    }

    private void onDisconnect() {
        boolean flag = this.field_22787.method_1542();
        class_642 serverdata = this.field_22787.method_1558();
        this.field_22787.field_1687.method_8525(class_638.field_61021);
        if (flag) {
            this.field_22787.method_72099();
        } else {
            this.field_22787.method_72100();
        }
        class_442 titlescreen = new class_442();
        if (flag) {
            this.field_22787.method_1507((class_437)titlescreen);
        } else if (serverdata != null && serverdata.method_52811()) {
            this.field_22787.method_1507((class_437)new class_4325((class_437)titlescreen));
        } else {
            this.field_22787.method_1507((class_437)new class_500((class_437)titlescreen));
        }
    }

    public static class ConfigurationSectionScreen
    extends class_4667 {
        protected static final long MAX_SLIDER_SIZE = 256L;
        protected final Context context;
        protected boolean changed = false;
        protected ModConfigSpec.RestartType needsRestart = ModConfigSpec.RestartType.NONE;
        protected final Map<String, ConfigurationSectionScreen> sectionCache = new HashMap<String, ConfigurationSectionScreen>();
        @Nullable
        protected class_4185 undoButton;
        @Nullable
        protected class_4185 resetButton;
        protected final class_4185 doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(120).method_46431();
        protected final UndoManager undoManager = new UndoManager();

        public ConfigurationSectionScreen(class_437 parent, ModConfig.Type type, ModConfig modConfig, class_2561 title) {
            this(parent, type, modConfig, title, (c, k, e) -> e);
        }

        public ConfigurationSectionScreen(class_437 parent, ModConfig.Type type, ModConfig modConfig, class_2561 title, Filter filter) {
            this(Context.top(modConfig.getModId(), parent, modConfig, filter), title);
            this.needsRestart = type == ModConfig.Type.STARTUP ? ModConfigSpec.RestartType.GAME : ModConfigSpec.RestartType.NONE;
        }

        public ConfigurationSectionScreen(Context parentContext, class_437 parent, Map<String, Object> valueSpecs, String key, Set<? extends UnmodifiableConfig.Entry> entrySet, class_2561 title) {
            this(Context.section(parentContext, parent, entrySet, valueSpecs, key), (class_2561)class_2561.method_43469((String)ConfigurationScreen.CRUMB, (Object[])new Object[]{parent.method_25440(), CRUMB_SEPARATOR, title}));
        }

        protected ConfigurationSectionScreen(Context context, class_2561 title) {
            super(context.parent, class_310.method_1551().field_1690, title);
            this.context = context;
        }

        @Nullable
        protected ModConfigSpec.ValueSpec getValueSpec(String key) {
            Object object = this.context.valueSpecs.get(key);
            if (object instanceof ModConfigSpec.ValueSpec) {
                ModConfigSpec.ValueSpec vs = (ModConfigSpec.ValueSpec)object;
                return vs;
            }
            return null;
        }

        protected String getTranslationKey(String key) {
            ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
            String result = valueSpec != null ? valueSpec.getTranslationKey() : this.context.modSpec.getLevelTranslationKey(this.context.makeKeyList(key));
            return result != null ? result : this.context.modId + ".configuration." + key;
        }

        protected class_5250 getTranslationComponent(String key) {
            return class_2561.method_43471((String)translationChecker.check(this.getTranslationKey(key)));
        }

        protected String getComment(String key) {
            ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
            return valueSpec != null ? this.getValueSpec(key).getComment() : this.context.modSpec.getLevelComment(this.context.makeKeyList(key));
        }

        protected <T> class_7172.class_7277<T> getTooltip(String key, @Nullable ModConfigSpec.Range<?> range) {
            return class_7172.method_42717((class_2561)this.getTooltipComponent(key, range));
        }

        protected class_2561 getTooltipComponent(String key, @Nullable ModConfigSpec.Range<?> range) {
            String tooltipKey = this.getTranslationKey(key) + ".tooltip";
            String comment = this.getComment(key);
            boolean hasTranslatedTooltip = translationChecker.existsWithFallback(tooltipKey);
            class_5250 component = class_2561.method_43473().method_10852((class_2561)this.getTranslationComponent(key).method_27692(class_124.field_1067));
            if (hasTranslatedTooltip || !Strings.isBlank((String)comment)) {
                component = component.method_10852((class_2561)EMPTY_LINE).method_10852((class_2561)class_2561.method_48321((String)tooltipKey, (String)comment));
            }
            component = component.method_10852(translationChecker.optional((class_2561)EMPTY_LINE, tooltipKey + ".warning", class_124.field_1061, class_124.field_1067));
            if (hasTranslatedTooltip && range != null) {
                component = component.method_10852((class_2561)EMPTY_LINE).method_10852((class_2561)class_2561.method_43469((String)ConfigurationScreen.RANGE_TOOLTIP, (Object[])new Object[]{range.toString()}).method_27692(RANGE_TOOLTIP_STYLE));
            }
            return component;
        }

        protected void onChanged(String key) {
            this.changed = true;
            ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
            if (valueSpec != null) {
                this.needsRestart = this.needsRestart.with(valueSpec.restartType());
            }
        }

        protected void method_60325() {
            this.rebuild();
        }

        protected ConfigurationSectionScreen rebuild() {
            if (this.field_51824 != null) {
                this.field_51824.method_25339();
                boolean hasUndoableElements = false;
                ArrayList<@Nullable ? extends Element> elements = new ArrayList<Element>();
                block20: for (UnmodifiableConfig.Entry entry : this.context.entries) {
                    String key = entry.getKey();
                    Object rawValue = entry.getRawValue();
                    Objects.requireNonNull(entry.getRawValue());
                    int n = 0;
                    block21: while (true) {
                        Object object;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModConfigSpec.ConfigValue.class, UnmodifiableConfig.class}, (Object)object, n)) {
                            case 0: {
                                Element element;
                                ModConfigSpec.ConfigValue cv = (ModConfigSpec.ConfigValue)object;
                                ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
                                Object object2 = valueSpec;
                                int n2 = 0;
                                block22: while (true) {
                                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModConfigSpec.ListValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class}, (Object)object2, n2)) {
                                        case 0: {
                                            ModConfigSpec.ListValueSpec listValueSpec = (ModConfigSpec.ListValueSpec)object2;
                                            element = this.createList(key, listValueSpec, cv);
                                            break block22;
                                        }
                                        case 1: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof String)) {
                                                n2 = 2;
                                                continue block22;
                                            }
                                            element = this.createStringValue(key, valueSpec::test, () -> (String)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 2: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Integer)) {
                                                n2 = 3;
                                                continue block22;
                                            }
                                            element = this.createIntegerValue(key, valueSpec, () -> (Integer)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 3: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Long)) {
                                                n2 = 4;
                                                continue block22;
                                            }
                                            element = this.createLongValue(key, valueSpec, () -> (Long)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 4: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Double)) {
                                                n2 = 5;
                                                continue block22;
                                            }
                                            element = this.createDoubleValue(key, valueSpec, () -> (Double)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 5: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Enum)) {
                                                n2 = 6;
                                                continue block22;
                                            }
                                            element = this.createEnumValue(key, valueSpec, cv::getRaw, cv::set);
                                            break block22;
                                        }
                                        case -1: {
                                            element = null;
                                            break block22;
                                        }
                                        default: {
                                            ModConfigSpec.ConfigValue configValue;
                                            Objects.requireNonNull(cv);
                                            int n3 = 0;
                                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModConfigSpec.BooleanValue.class, ModConfigSpec.IntValue.class, ModConfigSpec.LongValue.class, ModConfigSpec.DoubleValue.class, ModConfigSpec.EnumValue.class}, (Object)configValue, n3)) {
                                                case 0: {
                                                    ModConfigSpec.BooleanValue value = (ModConfigSpec.BooleanValue)configValue;
                                                    element = this.createBooleanValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 1: {
                                                    ModConfigSpec.IntValue value = (ModConfigSpec.IntValue)configValue;
                                                    element = this.createIntegerValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 2: {
                                                    ModConfigSpec.LongValue value = (ModConfigSpec.LongValue)configValue;
                                                    element = this.createLongValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 3: {
                                                    ModConfigSpec.DoubleValue value = (ModConfigSpec.DoubleValue)configValue;
                                                    element = this.createDoubleValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 4: {
                                                    ModConfigSpec.EnumValue value = (ModConfigSpec.EnumValue)configValue;
                                                    element = this.createEnumValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                            }
                                            element = this.createOtherValue(key, cv);
                                            break block22;
                                        }
                                    }
                                    break;
                                }
                                Element element2 = element;
                                elements.add(this.context.filter.filterEntry(this.context, key, element2));
                                continue block20;
                            }
                            case 1: {
                                UnmodifiableConfig subsection = (UnmodifiableConfig)object;
                                Object object2 = this.context.valueSpecs.get(key);
                                if (!(object2 instanceof UnmodifiableConfig)) {
                                    n = 2;
                                    continue block21;
                                }
                                UnmodifiableConfig subconfig = (UnmodifiableConfig)object2;
                                elements.add(this.createSection(key, subconfig, subsection));
                                continue block20;
                            }
                        }
                        break;
                    }
                    elements.add(this.context.filter.filterEntry(this.context, key, this.createOtherSection(key, rawValue)));
                }
                elements.addAll(this.createSyntheticValues());
                for (Element element : elements) {
                    if (element == null) continue;
                    if (element.name() == null) {
                        this.field_51824.method_20407((class_339)new class_7842(150, 20, (class_2561)class_2561.method_43473(), this.field_22793), element.getWidget(this.field_21336));
                    } else {
                        class_7842 label = new class_7842(150, 20, element.name, this.field_22793);
                        label.method_47400(class_7919.method_47407((class_2561)element.tooltip));
                        this.field_51824.method_20407((class_339)label, element.getWidget(this.field_21336));
                    }
                    hasUndoableElements |= element.undoable;
                }
                if (hasUndoableElements && this.undoButton == null) {
                    this.createUndoButton();
                    this.createResetButton();
                }
            }
            return this;
        }

        protected Collection<? extends Element> createSyntheticValues() {
            return Collections.emptyList();
        }

        protected boolean isNonDefault(ModConfigSpec.ConfigValue<?> cv) {
            return !Objects.equals(cv.getRaw(), cv.getDefault());
        }

        protected boolean isAnyNondefault() {
            for (UnmodifiableConfig.Entry entry : this.context.entries) {
                Object object = entry.getRawValue();
                if (!(object instanceof ModConfigSpec.ConfigValue)) continue;
                ModConfigSpec.ConfigValue cv = (ModConfigSpec.ConfigValue)object;
                if (this.getValueSpec(entry.getKey()) instanceof ModConfigSpec.ListValueSpec || !this.isNonDefault(cv)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        protected Element createStringValue(String key, Predicate<String> tester, Supplier<String> source, Consumer<String> target) {
            if (source.get().length() > 192) {
                class_7842 label = new class_7842(150, 20, (class_2561)class_2561.method_43470((String)source.get().substring(0, 128)), this.field_22793);
                label.method_47400(class_7919.method_47407((class_2561)LONG_STRING));
                return new Element((class_2561)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (class_339)label, false);
            }
            class_342 box = new class_342(this.field_22793, 150, 20, (class_2561)this.getTranslationComponent(key));
            box.method_1888(true);
            box.method_47400(class_7919.method_47407((class_2561)this.getTooltipComponent(key, null)));
            box.method_1880(class_3532.method_15340((int)(source.get().length() + 5), (int)128, (int)192));
            box.method_1852(source.get());
            box.method_1863(newValue -> {
                if (newValue != null && tester.test((String)newValue)) {
                    if (!newValue.equals(source.get())) {
                        this.undoManager.add(v -> {
                            target.accept((String)v);
                            this.onChanged(key);
                        }, newValue, v -> {
                            target.accept((String)v);
                            this.onChanged(key);
                        }, (String)source.get());
                    }
                    box.method_1868(-2039584);
                    return;
                }
                box.method_1868(-65536);
            });
            return new Element((class_2561)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (class_339)box);
        }

        @Nullable
        protected Element createOtherSection(String key, Object value) {
            return null;
        }

        @Nullable
        protected Element createOtherValue(String key, ModConfigSpec.ConfigValue<?> value) {
            class_7842 label = new class_7842(150, 20, (class_2561)class_2561.method_43470((String)Objects.toString(value.getRaw())), this.field_22793);
            label.method_47400(class_7919.method_47407((class_2561)UNSUPPORTED_ELEMENT));
            return new Element((class_2561)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (class_339)label, false);
        }

        @Nullable
        protected Element createBooleanValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Boolean> source, Consumer<Boolean> target) {
            return new Element((class_2561)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new class_7172(this.getTranslationKey(key), this.getTooltip(key, null), class_7172.field_41333, Custom.BOOLEAN_VALUES_NO_PREFIX, (Object)source.get(), newValue -> this.undoManager.add(v -> {
                target.accept((Boolean)v);
                this.onChanged(key);
            }, newValue, v -> {
                target.accept((Boolean)v);
                this.onChanged(key);
            }, (Boolean)source.get())));
        }

        @Nullable
        protected <T extends Enum<T>> Element createEnumValue(String key, ModConfigSpec.ValueSpec spec, Supplier<T> source, Consumer<T> target) {
            Class<?> clazz = spec.getClazz();
            assert (clazz != null);
            List<Enum> list = Arrays.stream((Enum[])clazz.getEnumConstants()).filter(spec::test).toList();
            return new Element((class_2561)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new class_7172(this.getTranslationKey(key), this.getTooltip(key, null), (caption, displayvalue) -> {
                class_5250 class_52502;
                if (displayvalue instanceof TranslatableEnum) {
                    TranslatableEnum tenum = (TranslatableEnum)((Object)displayvalue);
                    class_52502 = tenum.getTranslatedName();
                } else {
                    class_52502 = class_2561.method_43470((String)displayvalue.name());
                }
                return class_52502;
            }, new Custom<Enum>(list), (Object)((Enum)source.get()), newValue -> this.undoManager.add(v -> {
                target.accept(v);
                this.onChanged(key);
            }, newValue, v -> {
                target.accept(v);
                this.onChanged(key);
            }, (Enum)source.get())));
        }

        @Nullable
        protected Element createIntegerValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Integer> source, Consumer<Integer> target) {
            int max;
            ModConfigSpec.Range<Integer> range = spec.getRange();
            int min = range != null ? (Integer)range.getMin() : 0;
            int n = max = range != null ? (Integer)range.getMax() : Integer.MAX_VALUE;
            if ((long)max - (long)min < 256L) {
                return this.createSlider(key, source, target, range);
            }
            return this.createNumberBox(key, spec, source, target, null, Integer::decode, 0);
        }

        @Nullable
        protected Element createSlider(String key, Supplier<Integer> source, Consumer<Integer> target, @Nullable ModConfigSpec.Range<Integer> range) {
            return new Element((class_2561)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new class_7172(this.getTranslationKey(key), this.getTooltip(key, range), (caption, displayvalue) -> class_2561.method_43470((String)("" + displayvalue)), (class_7172.class_7178)new class_7172.class_7174(range != null ? range.getMin() : 0, range != null ? range.getMax() : Integer.MAX_VALUE), null, (Object)source.get(), newValue -> {
                if (!newValue.equals(source.get())) {
                    this.undoManager.add(v -> {
                        target.accept((Integer)v);
                        this.onChanged(key);
                    }, newValue, v -> {
                        target.accept((Integer)v);
                        this.onChanged(key);
                    }, (Integer)source.get());
                }
            }));
        }

        @Nullable
        protected Element createLongValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Long> source, Consumer<Long> target) {
            return this.createNumberBox(key, spec, source, target, null, Long::decode, 0L);
        }

        @Nullable
        protected <T extends Number> Element createNumberBox(String key, ModConfigSpec.ValueSpec spec, Supplier<T> source, Consumer<T> target, @Nullable Predicate<T> tester, Function<String, T> parser, T zero) {
            ModConfigSpec.Range range = spec.getRange();
            class_342 box = new class_342(this.field_22793, 150, 20, (class_2561)this.getTranslationComponent(key));
            box.method_1888(true);
            box.method_1890(newValueString -> {
                try {
                    parser.apply((String)newValueString);
                    return true;
                }
                catch (NumberFormatException e) {
                    return this.isPartialNumber((String)newValueString, range == null || ((Comparable)((Object)((Number)range.getMin()))).compareTo(zero) < 0);
                }
            });
            box.method_47400(class_7919.method_47407((class_2561)this.getTooltipComponent(key, range)));
            box.method_1852(String.valueOf(source.get()));
            box.method_1863(newValueString -> {
                try {
                    Number newValue = (Number)parser.apply((String)newValueString);
                    if (tester != null ? tester.test(newValue) : newValue != null && (range == null || range.test(newValue)) && spec.test(newValue)) {
                        if (!newValue.equals(source.get())) {
                            this.undoManager.add(v -> {
                                target.accept(v);
                                this.onChanged(key);
                            }, newValue, v -> {
                                target.accept(v);
                                this.onChanged(key);
                            }, (Number)source.get());
                        }
                        box.method_1868(-2039584);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                box.method_1868(-65536);
            });
            return new Element((class_2561)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (class_339)box);
        }

        protected boolean isPartialNumber(String value, boolean allowNegative) {
            return switch (value) {
                case "" -> true;
                case "0" -> true;
                case "0x" -> true;
                case "0X" -> true;
                case "#" -> true;
                case "-" -> allowNegative;
                case "-0" -> allowNegative;
                case "-0x" -> allowNegative;
                case "-0X" -> allowNegative;
                default -> false;
            };
        }

        @Nullable
        protected Element createDoubleValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Double> source, Consumer<Double> target) {
            return this.createNumberBox(key, spec, source, target, null, Double::parseDouble, 0.0);
        }

        @Nullable
        protected Element createSection(String key, UnmodifiableConfig subconfig, UnmodifiableConfig subsection) {
            if (subconfig.isEmpty()) {
                return null;
            }
            return new Element((class_2561)class_2561.method_43469((String)ConfigurationScreen.SECTION, (Object[])new Object[]{this.getTranslationComponent(key)}), this.getTooltipComponent(key, null), (class_339)class_4185.method_46430((class_2561)class_2561.method_43469((String)ConfigurationScreen.SECTION, (Object[])new Object[]{class_2561.method_43471((String)translationChecker.check(this.getTranslationKey(key) + ".button", ConfigurationScreen.SECTION_TEXT))}), button -> this.field_22787.method_1507((class_437)this.sectionCache.computeIfAbsent(key, k -> new ConfigurationSectionScreen(this.context, (class_437)this, subconfig.valueMap(), key, subsection.entrySet(), (class_2561)class_2561.method_43471((String)this.getTranslationKey(key))).rebuild()))).method_46436(class_7919.method_47407((class_2561)this.getTooltipComponent(key, null))).method_46432(150).method_46431(), false);
        }

        @Nullable
        protected <T> Element createList(String key, ModConfigSpec.ListValueSpec spec, ModConfigSpec.ConfigValue<List<T>> list) {
            return new Element((class_2561)class_2561.method_43469((String)ConfigurationScreen.SECTION, (Object[])new Object[]{this.getTranslationComponent(key)}), this.getTooltipComponent(key, null), (class_339)class_4185.method_46430((class_2561)class_2561.method_43469((String)ConfigurationScreen.SECTION, (Object[])new Object[]{class_2561.method_43471((String)translationChecker.check(this.getTranslationKey(key) + ".button", ConfigurationScreen.SECTION_TEXT))}), button -> this.field_22787.method_1507((class_437)this.sectionCache.computeIfAbsent(key, k -> new ConfigurationListScreen(Context.list(this.context, (class_437)this), key, (class_2561)class_2561.method_43469((String)ConfigurationScreen.CRUMB, (Object[])new Object[]{this.method_25440(), CRUMB_SEPARATOR, this.getTranslationComponent(key)}), spec, list)).rebuild())).method_46436(class_7919.method_47407((class_2561)this.getTooltipComponent(key, null))).method_46431(), false);
        }

        public void method_25394(class_332 graphics, int p_281550_, int p_282878_, float p_282465_) {
            this.setUndoButtonstate(this.undoManager.canUndo());
            this.setResetButtonstate(this.isAnyNondefault());
            super.method_25394(graphics, p_281550_, p_282878_, p_282465_);
        }

        protected void method_31387() {
            if (this.undoButton != null || this.resetButton != null) {
                class_8667 linearlayout = (class_8667)this.field_49503.method_48996((class_8021)class_8667.method_52742().method_52735(8));
                if (this.undoButton != null) {
                    linearlayout.method_52736((class_8021)this.undoButton);
                }
                if (this.resetButton != null) {
                    linearlayout.method_52736((class_8021)this.resetButton);
                }
                linearlayout.method_52736((class_8021)this.doneButton);
            } else {
                super.method_31387();
            }
        }

        protected void createUndoButton() {
            this.undoButton = class_4185.method_46430((class_2561)UNDO, button -> {
                this.undoManager.undo();
                this.rebuild();
            }).method_46436(class_7919.method_47407((class_2561)UNDO_TOOLTIP)).method_46432(120).method_46431();
            this.undoButton.field_22763 = false;
        }

        protected void setUndoButtonstate(boolean state) {
            if (this.undoButton != null) {
                this.undoButton.field_22763 = state;
            }
        }

        protected void createResetButton() {
            this.resetButton = class_4185.method_46430((class_2561)RESET, button -> {
                ArrayList list = new ArrayList();
                for (UnmodifiableConfig.Entry entry : this.context.entries) {
                    Object patt0$temp = entry.getRawValue();
                    if (!(patt0$temp instanceof ModConfigSpec.ConfigValue)) continue;
                    ModConfigSpec.ConfigValue cv = (ModConfigSpec.ConfigValue)patt0$temp;
                    if (this.getValueSpec(entry.getKey()) instanceof ModConfigSpec.ListValueSpec || !this.isNonDefault(cv)) continue;
                    String key = entry.getKey();
                    list.add(this.undoManager.step(v -> {
                        cv.set(v);
                        this.onChanged(key);
                    }, this.getValueSpec(key).correct(null), v -> {
                        cv.set(v);
                        this.onChanged(key);
                    }, cv.getRaw()));
                }
                this.undoManager.add(list);
                this.rebuild();
            }).method_46436(class_7919.method_47407((class_2561)RESET_TOOLTIP)).method_46432(120).method_46431();
        }

        protected void setResetButtonstate(boolean state) {
            if (this.resetButton != null) {
                this.resetButton.field_22763 = state;
            }
        }

        public void method_25419() {
            if (this.changed) {
                ConfigurationSectionScreen parent;
                class_437 class_4372 = this.field_21335;
                if (class_4372 instanceof ConfigurationSectionScreen) {
                    parent = (ConfigurationSectionScreen)class_4372;
                    parent.changed = true;
                } else {
                    this.context.modSpec.save();
                }
                class_437 class_4373 = this.field_21335;
                if (class_4373 instanceof ConfigurationSectionScreen) {
                    parent = (ConfigurationSectionScreen)class_4373;
                    parent.needsRestart = parent.needsRestart.with(this.needsRestart);
                } else {
                    class_4373 = this.field_21335;
                    if (class_4373 instanceof ConfigurationScreen) {
                        ConfigurationScreen parent2 = (ConfigurationScreen)class_4373;
                        parent2.needsRestart = parent2.needsRestart.with(this.needsRestart);
                    }
                }
            }
            super.method_25419();
        }

        public static interface Filter {
            @Nullable
            public Element filterEntry(Context var1, String var2, Element var3);
        }

        public record Context(String modId, class_437 parent, ModConfig modConfig, ModConfigSpec modSpec, Set<? extends UnmodifiableConfig.Entry> entries, Map<String, Object> valueSpecs, List<String> keylist, Filter filter) {
            public static Context top(String modId, class_437 parent, ModConfig modConfig, Filter filter) {
                return new Context(modId, parent, modConfig, (ModConfigSpec)modConfig.getSpec(), ((ModConfigSpec)modConfig.getSpec()).getValues().entrySet(), ((ModConfigSpec)modConfig.getSpec()).getSpec().valueMap(), List.of(), filter);
            }

            public static Context section(Context parentContext, class_437 parent, Set<? extends UnmodifiableConfig.Entry> entries, Map<String, Object> valueSpecs, String key) {
                return new Context(parentContext.modId, parent, parentContext.modConfig, parentContext.modSpec, entries, valueSpecs, parentContext.makeKeyList(key), parentContext.filter);
            }

            public static Context list(Context parentContext, class_437 parent) {
                return new Context(parentContext.modId, parent, parentContext.modConfig, parentContext.modSpec, parentContext.entries, parentContext.valueSpecs, parentContext.keylist, null);
            }

            private ArrayList<String> makeKeyList(String key) {
                ArrayList<String> result = new ArrayList<String>(this.keylist);
                result.add(key);
                return result;
            }
        }

        public record Element(@Nullable class_2561 name, @Nullable class_2561 tooltip, @Nullable class_339 widget, @Nullable class_7172<?> option, boolean undoable) {
            public Element(@Nullable class_2561 name, @Nullable class_2561 tooltip, class_339 widget) {
                this(name, tooltip, widget, null, true);
            }

            public Element(@Nullable class_2561 name, @Nullable class_2561 tooltip, class_339 widget, boolean undoable) {
                this(name, tooltip, widget, null, undoable);
            }

            public Element(class_2561 name, class_2561 tooltip, class_7172<?> option) {
                this(name, tooltip, null, option, true);
            }

            public Element(class_2561 name, class_2561 tooltip, class_7172<?> option, boolean undoable) {
                this(name, tooltip, null, option, undoable);
            }

            public class_339 getWidget(class_315 options) {
                return this.widget != null ? this.widget : this.option.method_57701(options);
            }

            @Nullable
            public Object any() {
                return this.widget != null ? this.widget : this.option;
            }
        }

        public record Custom<T>(List<T> values) implements class_7172.class_7178<T>
        {
            public static final Custom<Boolean> BOOLEAN_VALUES_NO_PREFIX = new Custom(ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE));

            public Function<class_7172<T>, class_339> method_41756(class_7172.class_7277<T> tooltip, class_315 options, int x, int y, int width, Consumer<T> target) {
                return optionsInstance -> class_5676.method_32606((Function)optionsInstance.field_37864).method_42729(class_5676.class_5680.method_32627(this.values)).method_32618(tooltip).method_32616().method_32619(optionsInstance.method_41753()).method_32617(x, y, width, 20, optionsInstance.field_38280, (source, newValue) -> {
                    optionsInstance.method_41748(newValue);
                    options.method_1640();
                    target.accept(newValue);
                });
            }

            public Optional<T> method_41758(T value) {
                return this.values.contains(value) ? Optional.of(value) : Optional.empty();
            }

            public Codec<T> comp_675() {
                return null;
            }
        }
    }

    public static class TranslationChecker {
        private static final Logger LOGGER = LogManager.getLogger();
        private final Set<String> untranslatables = new HashSet<String>();
        private final Set<String> untranslatablesWithFallback = new HashSet<String>();

        public String check(String translationKey) {
            if (!class_1074.method_4663((String)translationKey)) {
                this.untranslatables.add(translationKey);
            }
            return translationKey;
        }

        public String check(String translationKey, String fallback) {
            if (!class_1074.method_4663((String)translationKey)) {
                this.untranslatablesWithFallback.add(translationKey);
                return this.check(fallback);
            }
            return translationKey;
        }

        public boolean existsWithFallback(String translationKey) {
            if (!class_1074.method_4663((String)translationKey)) {
                this.untranslatablesWithFallback.add(translationKey);
                return false;
            }
            return true;
        }

        public class_2561 optional(class_2561 prefix, String translationKey, class_124 ... style) {
            if (class_1074.method_4663((String)translationKey)) {
                return class_2561.method_43473().method_10852(prefix).method_10852((class_2561)class_2561.method_43471((String)translationKey).method_27695(style));
            }
            return class_2561.method_43473();
        }

        public void finish() {
            if (ForgeConfigApiPortConfig.getBoolConfigValue(ModConfigValues.LOG_UNTRANSLATED_CONFIGURATION_WARNINGS) && CommonAbstractions.INSTANCE.isDevelopmentEnvironment() && (!this.untranslatables.isEmpty() || !this.untranslatablesWithFallback.isEmpty())) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n\tDev warning - Untranslated configuration keys encountered. Please translate your configuration keys so users can properly configure your mod.\n");
                if (!this.untranslatables.isEmpty()) {
                    stringBuilder.append("\nUntranslated keys:");
                    for (String key : this.untranslatables) {
                        stringBuilder.append("\n  \"").append(key).append("\": \"\",");
                    }
                }
                if (!this.untranslatablesWithFallback.isEmpty()) {
                    stringBuilder.append("\nThe following keys have fallbacks. Please check if those are suitable, and translate them if they're not.");
                    for (String key : this.untranslatablesWithFallback) {
                        stringBuilder.append("\n  \"").append(key).append("\": \"\",");
                    }
                }
                LOGGER.warn((CharSequence)stringBuilder);
            }
            this.untranslatables.clear();
        }
    }

    private static final class TooltipConfirmScreen
    extends class_410 {
        private TooltipConfirmScreen(BooleanConsumer callback, class_2561 title, class_2561 message, class_2561 yesButton, class_2561 noButton) {
            super(callback, title, message, yesButton, noButton);
        }

        protected void method_37051(class_8667 layout) {
            super.method_37051(layout);
            this.field_61003.method_47400(class_7919.method_47407((class_2561)RESTART_NO_TOOLTIP));
        }
    }

    public static final class UndoManager {
        private final List<Step<?>> undos = new ArrayList();
        private final List<Step<?>> redos = new ArrayList();

        public void undo() {
            if (this.canUndo()) {
                Step<?> step = this.undos.removeLast();
                step.runUndo();
                this.redos.add(step);
            }
        }

        public void redo() {
            if (this.canRedo()) {
                Step<?> step = this.redos.removeLast();
                step.runRedo();
                this.undos.add(step);
            }
        }

        private void add(Step<?> step, boolean execute) {
            this.undos.add(step);
            this.redos.clear();
            if (execute) {
                step.runRedo();
            }
        }

        public <T> Step<T> step(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            return new Step<T>(run, newValue, undo, oldValue);
        }

        public <T> void add(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            this.add(this.step(run, newValue, undo, oldValue), true);
        }

        public <T> void addNoExecute(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            this.add(this.step(run, newValue, undo, oldValue), false);
        }

        public void add(Step<?> ... steps) {
            this.add((List<Step<?>>)ImmutableList.copyOf((Object[])steps));
        }

        public void add(List<Step<?>> steps) {
            this.add(new Step<Object>(n -> steps.forEach(Step::runRedo), null, n -> steps.forEach(Step::runUndo), null), true);
        }

        public boolean canUndo() {
            return !this.undos.isEmpty();
        }

        public boolean canRedo() {
            return !this.redos.isEmpty();
        }

        public record Step<T>(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            private void runUndo() {
                this.undo.accept(this.oldValue);
            }

            private void runRedo() {
                this.run.accept(this.newValue);
            }
        }
    }

    public static class ConfigurationListScreen<T>
    extends ConfigurationSectionScreen {
        protected final String key;
        protected final ModConfigSpec.ListValueSpec spec;
        protected final ModConfigSpec.ConfigValue<List<T>> valueList;
        protected List<T> cfgList;

        public ConfigurationListScreen(ConfigurationSectionScreen.Context context, String key, class_2561 title, ModConfigSpec.ListValueSpec spec, ModConfigSpec.ConfigValue<List<T>> valueList) {
            super(context, title);
            this.key = key;
            this.spec = spec;
            this.valueList = valueList;
            this.cfgList = new ArrayList<T>((Collection)valueList.getRaw());
        }

        @Override
        protected ConfigurationSectionScreen rebuild() {
            if (this.field_51824 != null) {
                this.field_51824.method_25339();
                for (int idx = 0; idx < this.cfgList.size(); ++idx) {
                    ConfigurationSectionScreen.Element element;
                    T entry;
                    T t = entry = this.cfgList.get(idx);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Integer.class, Long.class, Double.class, String.class}, t, n)) {
                        case -1: {
                            ConfigurationSectionScreen.Element element2 = null;
                            break;
                        }
                        case 0: {
                            Boolean value = (Boolean)t;
                            ConfigurationSectionScreen.Element element2 = this.createBooleanListValue(idx, value);
                            break;
                        }
                        case 1: {
                            Integer value = (Integer)t;
                            ConfigurationSectionScreen.Element element2 = this.createIntegerListValue(idx, value);
                            break;
                        }
                        case 2: {
                            Long value = (Long)t;
                            ConfigurationSectionScreen.Element element2 = this.createLongListValue(idx, value);
                            break;
                        }
                        case 3: {
                            Double value = (Double)t;
                            ConfigurationSectionScreen.Element element2 = this.createDoubleListValue(idx, value);
                            break;
                        }
                        case 4: {
                            String value = (String)t;
                            ConfigurationSectionScreen.Element element2 = this.createStringListValue(idx, value);
                            break;
                        }
                        default: {
                            ConfigurationSectionScreen.Element element2 = element = this.createOtherValue(idx, entry);
                        }
                    }
                    if (element == null) continue;
                    class_339 widget = element.getWidget(this.field_21336);
                    if (widget instanceof class_342) {
                        class_342 box = (class_342)widget;
                        box.method_1852(box.method_1882());
                    }
                    this.field_51824.method_20407(this.createListLabel(idx), widget);
                }
                this.createAddElementButton();
                if (this.undoButton == null) {
                    this.createUndoButton();
                    this.createResetButton();
                }
            }
            return this;
        }

        @Override
        protected boolean isAnyNondefault() {
            return !this.cfgList.equals(this.valueList.getDefault());
        }

        protected void createAddElementButton() {
            Supplier<?> newElement = this.spec.getNewElementSupplier();
            ModConfigSpec.Range<Integer> sizeRange = this.spec.getSizeRange();
            if (newElement != null && sizeRange.test((Object)(this.cfgList.size() + 1))) {
                this.field_51824.method_20407((class_339)new class_7842(150, 20, (class_2561)class_2561.method_43473(), this.field_22793), (class_339)class_4185.method_46430((class_2561)NEW_LIST_ELEMENT, button -> {
                    ArrayList<T> newValue = new ArrayList<T>(this.cfgList);
                    newValue.add(newElement.get());
                    this.undoManager.add(v -> {
                        this.cfgList = v;
                        this.onChanged(this.key);
                    }, newValue, v -> {
                        this.cfgList = v;
                        this.onChanged(this.key);
                    }, this.cfgList);
                    this.rebuild();
                }).method_46431());
            }
        }

        protected class_339 createListLabel(int idx) {
            return new ListLabelWidget(0, 0, 150, 20, (class_2561)class_2561.method_43469((String)ConfigurationScreen.LIST_ELEMENT, (Object[])new Object[]{idx}), idx);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createOtherValue(int idx, T entry) {
            class_7842 label = new class_7842(150, 20, (class_2561)class_2561.method_43470((String)Objects.toString(entry)), this.field_22793);
            label.method_47400(class_7919.method_47407((class_2561)UNSUPPORTED_ELEMENT));
            return new ConfigurationSectionScreen.Element((class_2561)this.getTranslationComponent(this.key), this.getTooltipComponent(this.key, null), (class_339)label, false);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createStringListValue(int idx, String value) {
            return this.createStringValue(this.key, v -> this.spec.test(List.of(v)), () -> value, newValue -> this.cfgList.set(idx, newValue));
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createDoubleListValue(int idx, Double value) {
            return this.createNumberBox(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue), v -> this.spec.test(List.of(v)), Double::parseDouble, 0.0);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createLongListValue(int idx, Long value) {
            return this.createNumberBox(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue), v -> this.spec.test(List.of(v)), Long::decode, 0L);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createIntegerListValue(int idx, Integer value) {
            return this.createNumberBox(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue), v -> this.spec.test(List.of(v)), Integer::decode, 0);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createBooleanListValue(int idx, Boolean value) {
            return this.createBooleanValue(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue));
        }

        protected boolean swap(int idx, boolean simulate) {
            ArrayList<T> values = new ArrayList<T>(this.cfgList);
            values.add(idx, values.remove(idx + 1));
            return this.addUndoListener(simulate, values);
        }

        protected boolean del(int idx, boolean simulate) {
            ArrayList<T> values = new ArrayList<T>(this.cfgList);
            values.remove(idx);
            return this.addUndoListener(simulate, values);
        }

        private boolean addUndoListener(boolean simulate, List<T> values) {
            boolean valid = this.spec.test(values);
            if (!simulate && valid) {
                this.undoManager.add(v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, values, v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, this.cfgList);
                this.rebuild();
            }
            return valid;
        }

        @Override
        public void method_25419() {
            if (this.changed && this.spec.test(this.cfgList)) {
                this.valueList.set(this.cfgList);
                class_437 class_4372 = this.context.parent;
                if (class_4372 instanceof ConfigurationSectionScreen) {
                    ConfigurationSectionScreen parent = (ConfigurationSectionScreen)class_4372;
                    parent.onChanged(this.key);
                }
            }
            super.method_25419();
        }

        @Override
        public void method_25394(class_332 graphics, int p_281550_, int p_282878_, float p_282465_) {
            this.doneButton.field_22763 = this.spec.test(this.cfgList);
            super.method_25394(graphics, p_281550_, p_282878_, p_282465_);
        }

        @Override
        protected void onChanged(String key) {
            this.changed = true;
        }

        @Override
        protected void createResetButton() {
            this.resetButton = class_4185.method_46430((class_2561)RESET, button -> {
                this.undoManager.add(v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, new ArrayList((List)this.getValueSpec(this.key).correct(null)), v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, this.cfgList);
                this.rebuild();
            }).method_46436(class_7919.method_47407((class_2561)RESET_TOOLTIP)).method_46432(120).method_46431();
        }

        public class ListLabelWidget
        extends class_9017 {
            protected final class_4185 upButton;
            protected final class_4185 downButton;
            protected final class_4185 delButton;
            protected final class_7842 label;
            protected final int idx;
            protected final boolean isFirst;
            protected final boolean isLast;

            public ListLabelWidget(int x, int y, int width, int height, class_2561 labelText, int idx) {
                super(x, y, width, height, labelText);
                this.upButton = class_4185.method_46430((class_2561)MOVE_LIST_ELEMENT_UP, this::up).method_46431();
                this.downButton = class_4185.method_46430((class_2561)MOVE_LIST_ELEMENT_DOWN, this::down).method_46431();
                this.delButton = class_4185.method_46430((class_2561)REMOVE_LIST_ELEMENT, this::rem).method_46431();
                this.label = new class_7842(0, 0, 0, 0, (class_2561)class_2561.method_43473(), ConfigurationListScreen.this.field_22793);
                this.idx = idx;
                this.isFirst = idx == 0;
                this.isLast = idx + 1 == ConfigurationListScreen.this.cfgList.size();
                this.label.method_25355(labelText);
                this.checkButtons();
                this.updateLayout();
            }

            public void method_46421(int pX) {
                super.method_46421(pX);
                this.updateLayout();
            }

            public void method_46419(int pY) {
                super.method_46419(pY);
                this.updateLayout();
            }

            public void method_53533(int pHeight) {
                super.method_53533(pHeight);
                this.updateLayout();
            }

            public void method_25358(int pWidth) {
                super.method_25358(pWidth);
                this.updateLayout();
            }

            public void method_55445(int pWidth, int pHeight) {
                super.method_55445(pWidth, pHeight);
                this.updateLayout();
            }

            protected void updateLayout() {
                this.upButton.method_46421(this.method_46426());
                this.downButton.method_46421(this.method_46426() + this.method_25364() + 2);
                this.delButton.method_46421(this.method_46426() + this.method_25368() - this.method_25364());
                this.label.method_46421(this.method_46426() + 44);
                this.upButton.method_46419(this.method_46427());
                this.downButton.method_46419(this.method_46427());
                this.delButton.method_46419(this.method_46427());
                this.label.method_46419(this.method_46427());
                this.upButton.method_53533(this.method_25364());
                this.downButton.method_53533(this.method_25364());
                this.delButton.method_53533(this.method_25364());
                this.label.method_53533(this.method_25364());
                this.upButton.method_25358(this.method_25364());
                this.downButton.method_25358(this.method_25364());
                this.delButton.method_25358(this.method_25364());
                this.label.method_25358(this.method_25368() - 3 * (this.method_25364() + 2));
            }

            void up(class_4185 button) {
                ConfigurationListScreen.this.swap(this.idx - 1, false);
            }

            void down(class_4185 button) {
                ConfigurationListScreen.this.swap(this.idx, false);
            }

            void rem(class_4185 button) {
                ConfigurationListScreen.this.del(this.idx, false);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.upButton, this.label, this.downButton, this.delButton);
            }

            protected void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                this.checkButtons();
                this.label.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                if (!this.isFirst) {
                    this.upButton.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
                if (!this.isLast) {
                    this.downButton.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
                this.delButton.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            }

            protected void checkButtons() {
                this.upButton.field_22764 = !this.isFirst;
                this.upButton.field_22763 = !this.isFirst && ConfigurationListScreen.this.swap(this.idx - 1, true);
                this.downButton.field_22764 = !this.isLast;
                this.downButton.field_22763 = !this.isLast && ConfigurationListScreen.this.swap(this.idx, true);
                ModConfigSpec.Range<Integer> sizeRange = ConfigurationListScreen.this.spec.getSizeRange();
                this.delButton.field_22763 = !ConfigurationListScreen.this.cfgList.isEmpty() && (sizeRange == null || sizeRange.test((Object)(ConfigurationListScreen.this.cfgList.size() - 1))) && ConfigurationListScreen.this.del(this.idx, true);
            }

            protected void method_47399(class_6382 pNarrationElementOutput) {
            }

            protected int method_44395() {
                return 0;
            }

            protected double method_44393() {
                return 4.0;
            }
        }
    }
}

