/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.thosea.badoptimizations.config;

import fabric.me.thosea.badoptimizations.config.Config;
import fabric.me.thosea.badoptimizations.config.ConfigOptimization;
import fabric.me.thosea.badoptimizations.config.ModIncompatibilities;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public final class ConfigLoadContext {
    public final ModIncompatibilities incompats = new ModIncompatibilities();
    public final int version;
    @Nullable
    public final Properties properties = Files.exists(Config.FILE, new LinkOption[0]) ? this.loadProp() : null;

    public ConfigLoadContext() {
        this.version = this.intOrDefault("config_version", 4);
    }

    private Properties loadProp() {
        Properties properties;
        block8: {
            Properties prop = new Properties();
            InputStream stream = Files.newInputStream(Config.FILE, new OpenOption[0]);
            try {
                prop.load(stream);
                properties = prop;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Config.LOGGER.error("Failed to load config from " + String.valueOf(Config.FILE) + ". If you need to, you can delete the file to generate a new one.", (Throwable)e);
                    System.exit(1);
                    return null;
                }
            }
            stream.close();
        }
        return properties;
    }

    public boolean boolOrDefault(String name, boolean def) {
        String value = this.str(name);
        if (value == null) {
            return def;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalStateException("Config option " + name + " is not \"true\" or \"false\" (\"" + name + "\")");
    }

    public int intOrDefault(String name, int def) {
        int result;
        String value = this.str(name);
        if (value == null) {
            return def;
        }
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Config number " + name + " is not a valid number (\"" + value + "\")");
        }
        if (result < 0) {
            throw new IllegalStateException("Config number " + name + " is negative (" + result + ")");
        }
        return result;
    }

    private String str(String name) {
        if (this.properties == null) {
            return null;
        }
        String str = this.properties.getProperty(name);
        if (str == null) {
            throw new IllegalStateException("Config option " + name + " not found");
        }
        return str;
    }

    public boolean fromExistingFile() {
        return this.properties != null;
    }

    public void dumpConfig() {
        if (this.properties == null) {
            Config.LOGGER.info("BadOptimizations is generating the config with default values");
        } else {
            Config.LOGGER.info("BadOptimizations config dump:");
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> Config.LOGGER.info("{}: {}", key, value)));
        }
    }

    public ConfigOptimization optimization(String option) {
        return new ConfigOptimization(this, option, true);
    }

    public ConfigOptimization optimization(String option, boolean loadCondition) {
        return new ConfigOptimization(this, option, loadCondition);
    }

    public boolean option(String option, boolean def) {
        return this.option(option, true, def);
    }

    public boolean option(String option, boolean loadCondition, boolean def) {
        if (loadCondition) {
            return this.boolOrDefault(option, def);
        }
        return def;
    }
}

