/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.mojang.serialization.DynamicOps;
import com.natamus.collective_common_neoforge.config.CollectiveConfigHandler;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.fakeplayer.FakePlayer;
import com.natamus.collective_common_neoforge.fakeplayer.FakePlayerFactory;
import com.natamus.collective_common_neoforge.functions.BlockFunctions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemFunctions {
    public static void generateEntityDropsFromLootTable(Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        GlobalVariables.entitydrops = new HashMap();
        FakePlayer fakeplayer = FakePlayerFactory.getMinecraft((ServerLevel)level);
        Vec3 vec = new Vec3(0.0, 0.0, 0.0);
        ItemStack lootingsword = new ItemStack((ItemLike)Items.DIAMOND_SWORD, 1);
        lootingsword.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING), 10);
        fakeplayer.setItemSlot(EquipmentSlot.MAINHAND, lootingsword);
        Set entitytypes = level.registryAccess().lookupOrThrow(Registries.ENTITY_TYPE).entrySet();
        for (Map.Entry entry : entitytypes) {
            try {
                Entity entity;
                EntityType type = (EntityType)entry.getValue();
                if (type == null || !((entity = type.create(level, EntitySpawnReason.COMMAND)) instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity;
                Optional optionalLootTableResourceKey = le.getType().getDefaultLootTable();
                if (optionalLootTableResourceKey.isEmpty()) continue;
                ResourceKey lootlocation = (ResourceKey)optionalLootTableResourceKey.get();
                LootTable loottable = server.reloadableRegistries().getLootTable(lootlocation);
                LootParams lootParams = new LootParams.Builder((ServerLevel)level).withLuck(1000000.0f).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)vec).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakeplayer).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().playerAttack((Player)fakeplayer)).create(LootContextParamSets.ENTITY);
                ArrayList<Item> alldrops = new ArrayList<Item>();
                for (int n = 0; n < CollectiveConfigHandler.loopsAmountUsedToGetAllEntityDrops; ++n) {
                    ObjectArrayList newdrops = loottable.getRandomItems(lootParams);
                    for (ItemStack newdrop : newdrops) {
                        Item newitem = newdrop.getItem();
                        if (alldrops.contains(newitem) || newitem.equals(Items.AIR)) continue;
                        alldrops.add(newitem);
                    }
                }
                GlobalVariables.entitydrops.put(type, alldrops);
            }
            catch (Exception exception) {}
        }
    }

    public static void shrinkGiveOrDropItemStack(Player player, InteractionHand hand, ItemStack used, ItemStack give) {
        used.shrink(1);
        if (used.isEmpty()) {
            Item giveitem = give.getItem();
            int maxstacksize = give.getMaxStackSize();
            NonNullList inventory = player.getInventory().getNonEquipmentItems();
            boolean increased = false;
            for (ItemStack slot : inventory) {
                int slotcount;
                if (!slot.getItem().equals(giveitem) || (slotcount = slot.getCount()) >= maxstacksize) continue;
                slot.setCount(slotcount + 1);
                increased = true;
                break;
            }
            if (!increased) {
                player.setItemInHand(hand, give);
            }
        } else if (!player.getInventory().add(give)) {
            player.drop(give, false);
        }
    }

    public static void giveOrDropItemStack(Player player, ItemStack give) {
        if (!player.getInventory().add(give)) {
            player.drop(give, false);
        }
    }

    public static void itemHurtBreakAndEvent(ItemStack itemStack, ServerPlayer player, InteractionHand hand, int damage) {
        ServerLevel level = player.level();
        if (level.isClientSide()) {
            return;
        }
        if (!player.getAbilities().instabuild && itemStack.isDamageableItem()) {
            itemStack.hurtAndBreak(damage, level, player, item -> {
                itemStack.shrink(1);
                itemStack.setDamageValue(0);
                player.awardStat(Stats.ITEM_BROKEN.get(item));
            });
        }
    }

    public static boolean isStoneTypeItem(Item item) {
        return GlobalVariables.stoneblockitems.contains(item);
    }

    public static String itemToReadableString(Item item, int amount) {
        String translationkey = item.getDescriptionId();
        if (translationkey.contains("block.")) {
            return BlockFunctions.blockToReadableString(Block.byItem((Item)item), amount);
        }
        String[] itemspl = translationkey.replace("item.", "").split("\\.");
        Object itemstring = itemspl.length > 1 ? itemspl[1] : itemspl[0];
        itemstring = ((String)itemstring).replace("_", " ");
        if (amount > 1) {
            itemstring = (String)itemstring + "s";
        }
        return itemstring;
    }

    public static String itemToReadableString(Item item) {
        return ItemFunctions.itemToReadableString(item, 1);
    }

    public static String getNBTStringFromItemStack(Level level, ItemStack itemStack) {
        return ItemFunctions.getNBTStringFromItemStack(level, itemStack, true);
    }

    public static String getNBTStringFromItemStack(Level level, ItemStack itemStack, boolean shouldSanitize) {
        Tag nbt = (Tag)ItemStack.CODEC.encodeStart((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)itemStack).getOrThrow();
        String nbtstring = nbt.toString();
        if (shouldSanitize) {
            nbtstring = nbtstring.replace(" : ", ": ");
        }
        return nbtstring;
    }

    public static void setItemCategory(Item item, CreativeModeTab category) {
    }

    public static UseOnContext getUseOnContext(Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return ItemFunctions.getUseOnContext(player.level(), player, interactionHand, player.getItemInHand(interactionHand), blockHitResult);
    }

    public static UseOnContext getUseOnContext(Player player, InteractionHand interactionHand, BlockPos blockPos, Direction direction) {
        return ItemFunctions.getUseOnContext(player.level(), player, interactionHand, player.getItemInHand(interactionHand), blockPos, direction);
    }

    public static UseOnContext getUseOnContext(Level level, @Nullable Player player, InteractionHand interactionHand, ItemStack itemStack, BlockPos blockPos, Direction direction) {
        return ItemFunctions.getUseOnContext(level, player, interactionHand, itemStack, new BlockHitResult(Vec3.atCenterOf((Vec3i)blockPos), direction, blockPos, false));
    }

    public static UseOnContext getUseOnContext(Level level, @Nullable Player player, InteractionHand interactionHand, ItemStack itemStack, BlockHitResult blockHitResult) {
        return new UseOnContext(level, player, interactionHand, itemStack, blockHitResult);
    }
}

