/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.tab;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.gui.render.ColorGradientRenderState;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.mixin.TabNavigationBarAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8209;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

public class ScrollableNavigationBar
extends class_8089 {
    private static final int NAVBAR_MARGIN = 28;
    private static final class_327 font = class_310.method_1551().field_1772;
    private int scrollOffset;
    private int maxScrollOffset;
    private final TabNavigationBarAccessor accessor = (TabNavigationBarAccessor)((Object)this);

    public ScrollableNavigationBar(int width, class_8088 tabManager, Iterable<? extends class_8087> tabs) {
        super(width, tabManager, (Iterable)ImmutableList.copyOf(tabs));
        for (class_8209 tabButton : this.accessor.yacl$getTabButtons()) {
            class_8087 class_80872 = tabButton.method_49609();
            if (!(class_80872 instanceof TabExt)) continue;
            TabExt tab = (TabExt)class_80872;
            tabButton.method_47400(tab.getTooltip());
        }
    }

    public void method_49613() {
        ImmutableList<class_8209> tabButtons = this.accessor.yacl$getTabButtons();
        int noScrollWidth = this.accessor.yacl$getWidth() - 56;
        int allTabsWidth = 0;
        for (class_8209 tabButton : tabButtons) {
            int buttonWidth = font.method_27525((class_5348)tabButton.method_25369()) + 20;
            allTabsWidth += buttonWidth;
            tabButton.method_25358(buttonWidth);
        }
        if (allTabsWidth < noScrollWidth) {
            int equalWidth = noScrollWidth / tabButtons.size();
            List<class_8209> smallTabs = tabButtons.stream().filter(btn -> btn.method_25368() < equalWidth).toList();
            List<class_8209> bigTabs = tabButtons.stream().filter(btn -> btn.method_25368() >= equalWidth).toList();
            int leftoverWidth = noScrollWidth - bigTabs.stream().mapToInt(class_339::method_25368).sum();
            int equalWidthForSmallTabs = leftoverWidth / smallTabs.size();
            for (class_8209 tabButton : smallTabs) {
                tabButton.method_25358(equalWidthForSmallTabs);
            }
            allTabsWidth = noScrollWidth;
        }
        class_8667 layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.method_48222();
        layout.method_46419(0);
        this.scrollOffset = 0;
        layout.method_46421(Math.max((this.accessor.yacl$getWidth() - allTabsWidth) / 2, 28));
        this.maxScrollOffset = Math.max(0, allTabsWidth - noScrollWidth);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        GuiUtils.pushPose(graphics);
        GuiUtils.translateZ(graphics, 10.0f);
        super.method_25394(graphics, mouseX, mouseY, delta);
        class_8667 layout = this.accessor.yacl$getLayout();
        if (this.scrollOffset < this.maxScrollOffset - 28) {
            int right = this.accessor.yacl$getWidth();
            ColorGradientRenderState.createHorizontal(graphics, right - 40, layout.method_46427(), right, layout.method_46427() + layout.method_25364(), 0, -16777216).submit(graphics);
            int n = layout.method_46427();
            int n2 = layout.method_25364();
            Objects.requireNonNull(font);
            graphics.method_51433(font, "\u2192", right - 10, n + (n2 - 9) / 2, -1, false);
        }
        if (this.scrollOffset > 28) {
            ColorGradientRenderState.createHorizontal(graphics, 0, layout.method_46427(), 40, layout.method_46427() + layout.method_25364(), -16777216, 0).submit(graphics);
            int n = layout.method_46427();
            int n3 = layout.method_25364();
            Objects.requireNonNull(font);
            graphics.method_51433(font, "\u2190", 5, n + (n3 - 9) / 2, -1, false);
        }
        GuiUtils.popPose(graphics);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        this.setScrollOffset(this.scrollOffset - (int)(vertical * 15.0) - (int)(horizontal * 15.0));
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY <= 24.0;
    }

    public void setScrollOffset(int scrollOffset) {
        class_8667 layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.method_46421(layout.method_46426() + this.scrollOffset);
        this.scrollOffset = class_3532.method_15340((int)scrollOffset, (int)0, (int)this.maxScrollOffset);
        layout.method_46421(layout.method_46426() - this.scrollOffset);
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void method_25395(@Nullable class_364 child) {
        super.method_25395(child);
        if (child instanceof class_8209) {
            class_8209 tabButton = (class_8209)child;
            this.ensureVisible(tabButton);
        }
    }

    protected void ensureVisible(class_8209 tabButton) {
        if (tabButton.method_46426() < 28) {
            this.setScrollOffset(this.scrollOffset - (28 - tabButton.method_46426()));
        } else if (tabButton.method_46426() + tabButton.method_25368() > this.accessor.yacl$getWidth() - 28) {
            this.setScrollOffset(this.scrollOffset + (tabButton.method_46426() + tabButton.method_25368() - (this.accessor.yacl$getWidth() - 28)));
        }
    }

    public ImmutableList<class_8087> getTabs() {
        return this.accessor.yacl$getTabs();
    }

    public class_8088 getTabManager() {
        return this.accessor.yacl$getTabManager();
    }
}

