/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.volume;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.VolumeTransitionConfig;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.duck.DuckSoundEngine;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_3419;

public class SmoothVolumeHandler {
    private static boolean active = false;
    private static boolean needsUpdating = false;
    private static final Map<class_3419, Float> currentOverrides = new HashMap<class_3419, Float>();

    public static void init() {
        if (active || !DynamicFPSConfig.INSTANCE.volumeTransitionSpeed().isActive()) {
            return;
        }
        active = true;
        Platform.getInstance().registerStartTickEvent(SmoothVolumeHandler::tickVolumes);
    }

    public static void onStateChange() {
        if (active) {
            needsUpdating = true;
        } else {
            for (class_3419 source : class_3419.values()) {
                SmoothVolumeHandler.updateVolume(source);
            }
        }
    }

    public static float volumeMultiplier(class_3419 source) {
        if (!active) {
            return DynamicFPSMod.volumeMultiplier(source);
        }
        return currentOverrides.getOrDefault(source, Float.valueOf(1.0f)).floatValue();
    }

    private static void tickVolumes() {
        if (!needsUpdating) {
            return;
        }
        boolean didUpdate = false;
        VolumeTransitionConfig config = DynamicFPSConfig.INSTANCE.volumeTransitionSpeed();
        for (class_3419 source : class_3419.values()) {
            float desired = DynamicFPSMod.volumeMultiplier(source);
            float current = currentOverrides.getOrDefault(source, Float.valueOf(1.0f)).floatValue();
            if (current == desired) continue;
            didUpdate = true;
            if (current < desired) {
                currentOverrides.put(source, Float.valueOf(Math.min(desired, current + config.getUp() / 20.0f)));
            } else {
                currentOverrides.put(source, Float.valueOf(Math.max(desired, current - config.getDown() / 20.0f)));
            }
            SmoothVolumeHandler.updateVolume(source);
        }
        if (!didUpdate) {
            needsUpdating = false;
        }
    }

    private static void updateVolume(class_3419 source) {
        class_310 minecraft = class_310.method_1551();
        ((DuckSoundEngine)minecraft.method_1483().field_5590).dynamic_fps$updateVolume(source);
    }
}

