package data.hardmode.recipes;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.item.*;
import net.minecraft.recipe.Ingredient;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HardmodeMod implements ModInitializer {
    public static final String MOD_ID = "hardmode";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    // Материалы инструментов
    public static final ToolMaterial BAMBOO_TOOL_MATERIAL = new ToolMaterial() {
        @Override public int getDurability() { return 10; }
        @Override public float getMiningSpeedMultiplier() { return 1.5f; }
        @Override public float getAttackDamage() { return 0.5f; }
        @Override public int getMiningLevel() { return 0; }
        @Override public int getEnchantability() { return 5; }
        @Override public Ingredient getRepairIngredient() { return Ingredient.ofItems(Items.BAMBOO); }
    };

    public static final ToolMaterial SHARP_STICK_MATERIAL = new ToolMaterial() {
        @Override public int getDurability() { return 30; }
        @Override public float getMiningSpeedMultiplier() { return 2.0f; }
        @Override public float getAttackDamage() { return 1.0f; }
        @Override public int getMiningLevel() { return 0; }
        @Override public int getEnchantability() { return 15; }
        @Override public Ingredient getRepairIngredient() { return Ingredient.ofItems(Items.STICK); }
    };

    public static final ToolMaterial FLINT_MATERIAL = new ToolMaterial() {
        @Override public int getDurability() { return 10; }
        @Override public float getMiningSpeedMultiplier() { return 0.5f; }
        @Override public float getAttackDamage() { return 1.0f; }
        @Override public int getMiningLevel() { return 0; }
        @Override public int getEnchantability() { return 5; }
        @Override public Ingredient getRepairIngredient() { return Ingredient.ofItems(Items.FLINT); }
    };

    public static final ToolMaterial BONE_MATERIAL = new ToolMaterial() {
        @Override public int getDurability() { return 25; }
        @Override public float getMiningSpeedMultiplier() { return 1.8f; }
        @Override public float getAttackDamage() { return 1.2f; }
        @Override public int getMiningLevel() { return 0; }
        @Override public int getEnchantability() { return 12; }
        @Override public Ingredient getRepairIngredient() { return Ingredient.ofItems(Items.BONE); }
    };

    // Инструменты и оружие
    public static final Item BAMBOO_SHOVEL = new CustomShovelItem(BAMBOO_TOOL_MATERIAL, 1.5f, -3.0f, new FabricItemSettings().maxDamage(10));
    public static final Item BAMBOO_FISHING_ROD = new FishingRodItem(new FabricItemSettings().maxDamage(32));
    public static final Item SHARP_STICK = new CustomSwordItem(SHARP_STICK_MATERIAL, 1, -1.8f, new FabricItemSettings().maxDamage(30));
    public static final Item SHORT_SHARP_STICK = new CustomSwordItem(SHARP_STICK_MATERIAL, 0, -1.2f, new FabricItemSettings().maxDamage(15));
    public static final Item SHARP_BAMBOO = new CustomSwordItem(BAMBOO_TOOL_MATERIAL, 2, -1.3f, new FabricItemSettings().maxDamage(10));
    public static final Item SHORT_SHARP_BAMBOO = new CustomSwordItem(BAMBOO_TOOL_MATERIAL, 1, -0.7f, new FabricItemSettings().maxDamage(5));
    public static final Item FLINT = new FlintToolItem(FLINT_MATERIAL, 1, -1.4f, new FabricItemSettings().maxDamage(10));
    public static final Item BONE_KNIFE = new CustomSwordItem(BONE_MATERIAL, 2, -1.6f, new FabricItemSettings().maxDamage(25));
    public static final Item BONE_FLINT_KNIFE = new CustomSwordItem(BONE_MATERIAL, 3, -1.8f, new FabricItemSettings().maxDamage(35));
    public static final Item SHARP_BONE = new CustomSwordItem(BONE_MATERIAL, 2, -1.5f, new FabricItemSettings().maxDamage(20));
    public static final Item SHORT_SHARP_BONE = new CustomSwordItem(BONE_MATERIAL, 1, -1.2f, new FabricItemSettings().maxDamage(15));

    // Ресурсы
    public static final Item BARK = new Item(new FabricItemSettings());
    public static final Item RESIN = new Item(new FabricItemSettings());
    public static final Item WOOD_CHIPS = new Item(new FabricItemSettings());
    public static final Item PLANK = new Item(new FabricItemSettings());
    public static final Item FIBER = new Item(new FabricItemSettings());
    public static final Item ACORN = new Item(new FabricItemSettings());
    public static final Item STICK = new Item(new FabricItemSettings());
    public static final Item BAMBOO = new Item(new FabricItemSettings());
    public static final Item FLINT_CONNECTOR = new Item(new FabricItemSettings());
    public static final Item SMOOTH_FLINT = new Item(new FabricItemSettings());
    public static final Item SHORT_THREAD = new Item(new FabricItemSettings());
    public static final Item SMALL_THREAD = new Item(new FabricItemSettings());
    public static final Item MEDIUM_THREAD = new Item(new FabricItemSettings());
    public static final Item THREAD = new Item(new FabricItemSettings());
    public static final Item LARGE_THREAD = new Item(new FabricItemSettings());
    public static final Item ROPE = new Item(new FabricItemSettings());
    public static final Item FLINT_FISHING_LINE = new Item(new FabricItemSettings());
    public static final Item SHARP_FLINT = new Item(new FabricItemSettings());
    public static final Item ZOMBIE_SLIME_BALL = new Item(new FabricItemSettings());
    public static final Item STICK_FLINT = new Item(new FabricItemSettings());
    public static final Item BAMBOO_DYE = new Item(new FabricItemSettings());

    // Новые предметы (кости)
    public static final Item LIGHT_BONE = new Item(new FabricItemSettings());
    public static final Item BONE = new Item(new FabricItemSettings());
    public static final Item SHORT_BONE = new Item(new FabricItemSettings());
    public static final Item SHORTED_BONE = new Item(new FabricItemSettings());
    public static final Item PIECE_BONE = new Item(new FabricItemSettings());
    public static final Item BONE_CHIPS = new Item(new FabricItemSettings());
    public static final Item STICK_BONE = new Item(new FabricItemSettings());
    public static final Item WOOD_SHAVINGS = new Item(new FabricItemSettings());
    public static final Item BONE_SHAVINGS = new Item(new FabricItemSettings());
    public static final Item FLINT_SHAVINGS = new Item(new FabricItemSettings());
    public static final Item ZOMBIE_BONE_GLUE = new Item(new FabricItemSettings());

    // Основная вкладка
    public static final ItemGroup HARDMODE_GROUP = FabricItemGroup.builder()
            .icon(() -> new ItemStack(HardmodeMod.BAMBOO_SHOVEL))
            .displayName(Text.translatable("itemGroup.hardmode.group"))
            .entries((context, entries) -> {
                // Добавляем предметы в определенном порядке

                // Ресурсы
                entries.add(BARK);
                entries.add(RESIN);
                entries.add(WOOD_CHIPS);
                entries.add(PLANK);
                entries.add(FIBER);
                entries.add(ACORN);
                entries.add(STICK);
                entries.add(BAMBOO);
                entries.add(FLINT_CONNECTOR);
                entries.add(SMOOTH_FLINT);

                // Нити и веревки
                entries.add(SHORT_THREAD);
                entries.add(SMALL_THREAD);
                entries.add(MEDIUM_THREAD);
                entries.add(THREAD);
                entries.add(LARGE_THREAD);
                entries.add(ROPE);
                entries.add(FLINT_FISHING_LINE);

                // Новые предметы
                entries.add(SHARP_FLINT);
                entries.add(ZOMBIE_SLIME_BALL);
                entries.add(STICK_FLINT);
                entries.add(BAMBOO_DYE);

                // Костные предметы
                entries.add(LIGHT_BONE);
                entries.add(BONE);
                entries.add(SHORT_BONE);
                entries.add(SHORTED_BONE);
                entries.add(PIECE_BONE);
                entries.add(BONE_CHIPS);
                entries.add(STICK_BONE);
                entries.add(WOOD_SHAVINGS);
                entries.add(BONE_SHAVINGS);
                entries.add(FLINT_SHAVINGS);
                entries.add(ZOMBIE_BONE_GLUE);

                // Инструменты
                entries.add(BAMBOO_SHOVEL);
                entries.add(BAMBOO_FISHING_ROD);
                entries.add(SHARP_STICK);
                entries.add(SHORT_SHARP_STICK);
                entries.add(SHARP_BAMBOO);
                entries.add(SHORT_SHARP_BAMBOO);
                entries.add(FLINT);
                entries.add(BONE_KNIFE);
                entries.add(BONE_FLINT_KNIFE);
                entries.add(SHARP_BONE);
                entries.add(SHORT_SHARP_BONE);
            })
            .build();

    // Вкладка для бамбука
    public static final ItemGroup BAMBOO_GROUP = FabricItemGroup.builder()
            .icon(() -> new ItemStack(HardmodeMod.BAMBOO))
            .displayName(Text.translatable("itemGroup.hardmode.bamboo"))
            .entries((context, entries) -> {
                entries.add(BAMBOO);
                entries.add(BAMBOO_SHOVEL);
                entries.add(BAMBOO_FISHING_ROD);
                entries.add(SHARP_BAMBOO);
                entries.add(SHORT_SHARP_BAMBOO);
                entries.add(BAMBOO_DYE);
            })
            .build();

    // Вкладка для дерева
    public static final ItemGroup WOOD_GROUP = FabricItemGroup.builder()
            .icon(() -> new ItemStack(HardmodeMod.STICK))
            .displayName(Text.translatable("itemGroup.hardmode.wood"))
            .entries((context, entries) -> {
                entries.add(BARK);
                entries.add(RESIN);
                entries.add(WOOD_CHIPS);
                entries.add(PLANK);
                entries.add(FIBER);
                entries.add(ACORN);
                entries.add(STICK);
                entries.add(SHARP_STICK);
                entries.add(SHORT_SHARP_STICK);
                entries.add(WOOD_SHAVINGS);
            })
            .build();

    // Вкладка для костей
    public static final ItemGroup BONE_GROUP = FabricItemGroup.builder()
            .icon(() -> new ItemStack(HardmodeMod.BONE))
            .displayName(Text.translatable("itemGroup.hardmode.bone"))
            .entries((context, entries) -> {
                entries.add(LIGHT_BONE);
                entries.add(BONE);
                entries.add(SHORT_BONE);
                entries.add(SHORTED_BONE);
                entries.add(PIECE_BONE);
                entries.add(BONE_CHIPS);
                entries.add(STICK_BONE);
                entries.add(BONE_SHAVINGS);
                entries.add(ZOMBIE_BONE_GLUE);
                entries.add(BONE_KNIFE);
                entries.add(BONE_FLINT_KNIFE);
                entries.add(SHARP_BONE);
                entries.add(SHORT_SHARP_BONE);
            })
            .build();

    // Вкладка для кремня
    public static final ItemGroup FLINT_GROUP = FabricItemGroup.builder()
            .icon(() -> new ItemStack(HardmodeMod.FLINT))
            .displayName(Text.translatable("itemGroup.hardmode.flint"))
            .entries((context, entries) -> {
                entries.add(FLINT_CONNECTOR);
                entries.add(SMOOTH_FLINT);
                entries.add(SHARP_FLINT);
                entries.add(STICK_FLINT);
                entries.add(FLINT_SHAVINGS);
                entries.add(FLINT);
                entries.add(FLINT_FISHING_LINE);
                entries.add(BONE_FLINT_KNIFE);
            })
            .build();

    @Override
    public void onInitialize() {
        LOGGER.info("Hardmode mod initialized!");

        registerItems();
        registerTools();
        registerBoneItems();

        // Регистрируем креативные вкладки
        Registry.register(Registries.ITEM_GROUP, new Identifier(MOD_ID, "hardmode_group"), HARDMODE_GROUP);
        Registry.register(Registries.ITEM_GROUP, new Identifier(MOD_ID, "bamboo_group"), BAMBOO_GROUP);
        Registry.register(Registries.ITEM_GROUP, new Identifier(MOD_ID, "wood_group"), WOOD_GROUP);
        Registry.register(Registries.ITEM_GROUP, new Identifier(MOD_ID, "bone_group"), BONE_GROUP);
        Registry.register(Registries.ITEM_GROUP, new Identifier(MOD_ID, "flint_group"), FLINT_GROUP);
    }

    private void registerItems() {
        registerItem("bark", BARK);
        registerItem("resin", RESIN);
        registerItem("wood_chips", WOOD_CHIPS);
        registerItem("plank", PLANK);
        registerItem("fiber", FIBER);
        registerItem("acorn", ACORN);
        registerItem("stick", STICK);
        registerItem("bamboo", BAMBOO);
        registerItem("flint_connector", FLINT_CONNECTOR);
        registerItem("smooth_flint", SMOOTH_FLINT);
        registerItem("short_thread", SHORT_THREAD);
        registerItem("small_thread", SMALL_THREAD);
        registerItem("medium_thread", MEDIUM_THREAD);
        registerItem("thread", THREAD);
        registerItem("large_thread", LARGE_THREAD);
        registerItem("rope", ROPE);
        registerItem("flint_fishing_line", FLINT_FISHING_LINE);
        registerItem("sharp_flint", SHARP_FLINT);
        registerItem("zombie_slime_ball", ZOMBIE_SLIME_BALL);
        registerItem("stick_flint", STICK_FLINT);
        registerItem("bamboo_dye", BAMBOO_DYE);
    }

    private void registerTools() {
        registerItem("bamboo_shovel", BAMBOO_SHOVEL);
        registerItem("bamboo_fishing_rod", BAMBOO_FISHING_ROD);
        registerItem("sharp_stick", SHARP_STICK);
        registerItem("short_sharp_stick", SHORT_SHARP_STICK);
        registerItem("sharp_bamboo", SHARP_BAMBOO);
        registerItem("short_sharp_bamboo", SHORT_SHARP_BAMBOO);
        registerItem("flint_tool", FLINT);
        registerItem("bone_knife", BONE_KNIFE);
        registerItem("bone_flint_knife", BONE_FLINT_KNIFE);
        registerItem("sharp_bone", SHARP_BONE);
        registerItem("short_sharp_bone", SHORT_SHARP_BONE);
    }

    private void registerBoneItems() {
        registerItem("light_bone", LIGHT_BONE);
        registerItem("bone", BONE);
        registerItem("short_bone", SHORT_BONE);
        registerItem("shorted_bone", SHORTED_BONE);
        registerItem("piece_bone", PIECE_BONE);
        registerItem("bone_chips", BONE_CHIPS);
        registerItem("stick_bone", STICK_BONE);
        registerItem("wood_shavings", WOOD_SHAVINGS);
        registerItem("bone_shavings", BONE_SHAVINGS);
        registerItem("flint_shavings", FLINT_SHAVINGS);
        registerItem("zombie_bone_glue", ZOMBIE_BONE_GLUE);
    }

    private void registerItem(String name, Item item) {
        Registry.register(Registries.ITEM, new Identifier(MOD_ID, name), item);
    }
}

// Кастомные классы инструментов
class CustomShovelItem extends ShovelItem {
    public CustomShovelItem(ToolMaterial material, float attackDamage, float attackSpeed, Settings settings) {
        super(material, attackDamage, attackSpeed, settings);
    }
}

class CustomSwordItem extends SwordItem {
    public CustomSwordItem(ToolMaterial material, int attackDamage, float attackSpeed, Settings settings) {
        super(material, attackDamage, attackSpeed, settings);
    }
}

class FlintToolItem extends SwordItem {
    public FlintToolItem(ToolMaterial material, int attackDamage, float attackSpeed, Settings settings) {
        super(material, attackDamage, attackSpeed, settings);
    }
}