/*
 * Decompiled with CFR 0.152.
 */
package keybindbugfixes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.minenash.rebind_all_the_keys.RebindAllTheKeys;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import keybindbugfixes.config.ConfigManager;
import keybindbugfixes.mixin.KeyBindingAccessor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11906;
import net.minecraft.class_310;
import net.minecraft.class_4666;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeybindBugFixes
implements ClientModInitializer {
    public static final String MOD_NAME = "KeybindBugFixes";
    public static final String MOD_ID = "keybindbugfixes";
    public static final Set<String> DISABLED_MIXIN_NAMES = Sets.newHashSet();
    public static final Set<String> DISABLED_OPTION_NAMES = Sets.newHashSet();
    private static final boolean IS_REBIND_ALL_THE_KEYS_MOD_LOADED;
    private static boolean loaded;
    public static class_310 client;
    public static final FabricLoader FABRIC_LOADER;
    public static final Logger LOGGER;
    public static final Gson GSON;
    public static final StickyKeyRevertMap STICKY_KEY_REVERT_MAP;
    public static boolean draggingPickKey;

    public static void preLoad() {
        if (loaded) {
            return;
        }
        loaded = true;
        ConfigManager.preInit();
        boolean isAmecsApiModLoaded = FABRIC_LOADER.isModLoaded("amecsapi");
        if (IS_REBIND_ALL_THE_KEYS_MOD_LOADED) {
            KeybindBugFixes.disableMixin("rebind_debug_keys");
        }
        if (!isAmecsApiModLoaded) {
            DISABLED_MIXIN_NAMES.add("fix_modifier_sticky_key.KeyBindingMixin");
        }
    }

    public static void disableMixin(String name) {
        DISABLED_MIXIN_NAMES.add(name);
        for (ConfigManager.Option<?> option : ConfigManager.OPTIONS) {
            if (!option.mixinName().equals(name)) continue;
            DISABLED_OPTION_NAMES.add(option.name());
        }
    }

    public static boolean shouldAddOption(ConfigManager.Option<?> option) {
        return !DISABLED_OPTION_NAMES.contains(option.name());
    }

    public static void revertStickyKeyBinding(int keycode) {
        Map<class_4666, Boolean> submap = STICKY_KEY_REVERT_MAP.filter(keycode);
        for (Map.Entry<class_4666, Boolean> entry : submap.entrySet()) {
            class_4666 keyBinding = entry.getKey();
            boolean initialValue = entry.getValue();
            KeyBindingAccessor accessor = (KeyBindingAccessor)keyBinding;
            accessor.setPressedState(initialValue);
            if (keyBinding.method_1435(KeybindBugFixes.client.field_1690.field_1867) && !initialValue) {
                KeybindBugFixes.client.field_1724.method_5728(false);
            }
            STICKY_KEY_REVERT_MAP.remove(keyBinding);
        }
    }

    public static void revertControlModifier() {
        KeybindBugFixes.revertStickyKeyBinding(class_11906.field_62587);
        KeybindBugFixes.revertStickyKeyBinding(class_11906.field_62588);
    }

    public static void revertDropStackModifier() {
        boolean isModifierPressed = IS_REBIND_ALL_THE_KEYS_MOD_LOADED ? RebindAllTheKeys.DROP_STACK_MODIFIER.method_1434() : client.method_74188();
        if (isModifierPressed) {
            if (IS_REBIND_ALL_THE_KEYS_MOD_LOADED) {
                KeyBindingAccessor accessor = (KeyBindingAccessor)RebindAllTheKeys.DROP_STACK_MODIFIER;
                KeybindBugFixes.revertStickyKeyBinding(accessor.getBoundKey().method_1444());
            } else {
                KeybindBugFixes.revertControlModifier();
            }
        }
    }

    public static void revertPickBlockModifier() {
        if (client.method_74188()) {
            KeybindBugFixes.revertControlModifier();
        }
    }

    public static void revertNarratorModifier() {
        KeybindBugFixes.revertControlModifier();
    }

    public void onInitializeClient() {
        client = class_310.method_1551();
        ConfigManager.init();
    }

    static {
        loaded = false;
        FABRIC_LOADER = FabricLoader.getInstance();
        LOGGER = LoggerFactory.getLogger((String)MOD_NAME);
        STICKY_KEY_REVERT_MAP = new StickyKeyRevertMap();
        draggingPickKey = false;
        GsonBuilder builder = new GsonBuilder();
        GSON = builder.serializeNulls().setPrettyPrinting().create();
        IS_REBIND_ALL_THE_KEYS_MOD_LOADED = FABRIC_LOADER.isModLoaded("rebind_all_the_keys");
        KeybindBugFixes.preLoad();
    }

    public static class StickyKeyRevertMap {
        public final Map<class_4666, Boolean> map = Maps.newHashMap();

        public void put(class_4666 keyBinding, Boolean value) {
            this.map.put(keyBinding, value);
        }

        public void remove(class_4666 keyBinding) {
            this.map.remove(keyBinding);
        }

        public Map<class_4666, Boolean> filter(int keycode) {
            HashMap result = Maps.newHashMap();
            for (Map.Entry<class_4666, Boolean> entry : this.map.entrySet()) {
                if (((KeyBindingAccessor)entry.getKey()).getBoundKey().method_1444() != keycode) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }
}

