/*
 * Decompiled with CFR 0.152.
 */
package keybindbugfixes.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import keybindbugfixes.KeybindBugFixes;
import keybindbugfixes.config.Config;
import keybindbugfixes.config.annotation.BugInfo;
import keybindbugfixes.config.annotation.CategoryInfo;
import keybindbugfixes.config.annotation.KeybindInfo;
import keybindbugfixes.config.annotation.TweakInfo;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3675;
import net.minecraft.class_407;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    public static boolean displayMissingConfigEntryError;
    public static final List<Category> CATEGORIES;
    public static final List<Option<?>> OPTIONS;
    public static final List<BugOption> BUG_OPTIONS;
    public static final List<KeybindOption> KEYBIND_OPTIONS;
    public static final MixinMap OPTION_MIXIN_MAP;

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("keybindbugfixes.json");
    }

    public static void initOptions() {
        Class<?>[] classes = Config.class.getClasses();
        List<Class<?>> classList = Arrays.asList(classes);
        Collections.reverse(classList);
        for (Class<?> categoryClass : classList) {
            if (!categoryClass.isAnnotationPresent(CategoryInfo.class)) continue;
            CategoryInfo categoryInfo = categoryClass.getAnnotation(CategoryInfo.class);
            String categoryName = categoryClass.getSimpleName().toLowerCase(Locale.ROOT);
            String entryName = categoryInfo.entryName();
            ArrayList options = Lists.newArrayList();
            for (Field field : categoryClass.getFields()) {
                if (field.isAnnotationPresent(BugInfo.class)) {
                    BugInfo bugInfo = field.getAnnotation(BugInfo.class);
                    options.add(new BugOption(field, entryName, bugInfo.mixin(), bugInfo.id()));
                    continue;
                }
                if (field.isAnnotationPresent(TweakInfo.class)) {
                    TweakInfo tweakInfo = field.getAnnotation(TweakInfo.class);
                    options.add(new TweakOption(field, entryName, tweakInfo.mixin()));
                    continue;
                }
                if (!field.isAnnotationPresent(KeybindInfo.class)) continue;
                KeybindInfo keybindInfo = field.getAnnotation(KeybindInfo.class);
                options.add(new KeybindOption(field, entryName, keybindInfo.mixin(), keybindInfo.modifier()));
            }
            CATEGORIES.add(new Category(categoryName, (Option[])options.toArray(Option[]::new)));
        }
    }

    public static void loadOptions() {
        Path configPath = ConfigManager.getConfigPath();
        try {
            boolean configFileExists;
            displayMissingConfigEntryError = configFileExists = Files.exists(configPath, new LinkOption[0]);
            if (configFileExists) {
                BufferedReader reader = Files.newBufferedReader(configPath);
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (Option<?> option : OPTIONS) {
                    JsonElement jsonElement = json.get(option.name());
                    option.load(jsonElement);
                }
            } else {
                for (Option<?> option : OPTIONS) {
                    option.load(null);
                }
            }
        }
        catch (Throwable e) {
            KeybindBugFixes.LOGGER.error("Couldn't load KeybindBugFixes configuration file");
        }
    }

    public static void initOptionValues() {
        for (Option<?> option : OPTIONS) {
            option.initValue();
        }
    }

    public static void loadOptionValues() {
        for (Option<?> option : OPTIONS) {
            option.loadValue();
        }
    }

    public static void saveOptionValues() {
        Path configPath = ConfigManager.getConfigPath();
        JsonObject json = new JsonObject();
        for (Option<?> option : OPTIONS) {
            option.write(json);
        }
        String jsonString = KeybindBugFixes.GSON.toJson((JsonElement)json);
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            writer.write(jsonString);
        }
        catch (IOException e) {
            KeybindBugFixes.LOGGER.error("Couldn't save KeybindBugFixes configuration file");
        }
    }

    public static void preInit() {
        ConfigManager.initOptions();
        ConfigManager.loadOptions();
        for (Map.Entry<String, Set<Option<?>>> entry : OPTION_MIXIN_MAP.entrySet()) {
            String mixinName = entry.getKey();
            boolean allOptionsDisabled = true;
            for (Option<?> option : entry.getValue()) {
                if (option.isDisabled()) {
                    KeybindBugFixes.DISABLED_OPTION_NAMES.add(option.name());
                    continue;
                }
                allOptionsDisabled = false;
            }
            if (!allOptionsDisabled) continue;
            KeybindBugFixes.DISABLED_MIXIN_NAMES.add(mixinName);
        }
    }

    public static void init() {
        ConfigManager.initOptionValues();
        ConfigManager.loadOptionValues();
        ConfigManager.saveOptionValues();
    }

    static {
        CATEGORIES = Lists.newArrayList();
        OPTIONS = Lists.newArrayList();
        BUG_OPTIONS = Lists.newArrayList();
        KEYBIND_OPTIONS = Lists.newArrayList();
        OPTION_MIXIN_MAP = new MixinMap();
    }

    public static class BugOption
    extends TweakOption {
        @Nullable
        private final String link;
        private final int id;

        public BugOption(Field field, String entryName, String mixinName, int id) {
            super(field, entryName, mixinName);
            this.id = id;
            this.link = id != -1 ? "https://bugs.mojang.com/browse/MC-" + id : null;
            BUG_OPTIONS.add(this);
        }

        public int id() {
            return this.id;
        }

        @Nullable
        public String link() {
            return this.link;
        }

        public void openLink(class_437 parent) {
            if (this.link != null) {
                class_407.method_49623((class_437)parent, (String)this.link);
            }
        }
    }

    public static class TweakOption
    extends Option<Boolean> {
        public TweakOption(Field field, String entryName, String mixinName) {
            super(field, entryName, mixinName);
        }

        @Override
        protected Class<Boolean> valueType() {
            return Boolean.class;
        }

        @Override
        protected Boolean disabledValue() {
            return false;
        }

        @Override
        public void writeToJson(JsonObject json) {
            json.addProperty(this.name, (Boolean)this.value);
        }

        @Override
        public boolean loadFromJson(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isBoolean()) {
                this.setValue(jsonElement.getAsBoolean());
                return true;
            }
            return false;
        }

        public void toggleValue() {
            this.setValue((Boolean)this.value == false);
        }
    }

    public static class KeybindOption
    extends Option<class_3675.class_306> {
        @Nullable
        private KeybindOption modifier;

        public KeybindOption(Field field, String entryName, String mixinName, String modifier) {
            super(field, entryName, mixinName);
            boolean processed = false;
            if (!modifier.isEmpty()) {
                String modifierName = this.entryName + "." + modifier.toLowerCase(Locale.ROOT);
                for (KeybindOption option : KEYBIND_OPTIONS) {
                    if (!option.name().equals(modifierName)) continue;
                    this.modifier = option;
                    processed = true;
                    break;
                }
            }
            if (!processed) {
                this.modifier = null;
            }
            KEYBIND_OPTIONS.add(this);
        }

        @Override
        protected Class<class_3675.class_306> valueType() {
            return class_3675.class_306.class;
        }

        @Override
        protected class_3675.class_306 disabledValue() {
            return (class_3675.class_306)this.defaultValue;
        }

        @Override
        public void writeToJson(JsonObject json) {
            json.addProperty(this.name, ((class_3675.class_306)this.value).method_1441());
        }

        @Override
        public boolean loadFromJson(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
                try {
                    this.setValue(class_3675.method_15981((String)jsonElement.getAsString()));
                    return true;
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
            return false;
        }

        @Nullable
        public KeybindOption modifier() {
            return this.modifier;
        }

        public boolean isUnbound() {
            return ((class_3675.class_306)this.value).equals((Object)class_3675.field_16237);
        }
    }

    public static class Category {
        private final String translationKey;
        private final List<Option<?>> options;

        public Category(String categoryName, Option<?>[] options) {
            this.translationKey = "keybindbugfixes.config.category." + categoryName;
            this.options = Lists.newArrayList((Object[])options);
        }

        public String translationKey() {
            return this.translationKey;
        }

        public List<Option<?>> options() {
            return this.options;
        }
    }

    public static abstract class Option<T> {
        protected final Field field;
        protected JsonElement jsonElement;
        protected final String name;
        protected final String translationKey;
        protected final String mixinName;
        protected final String entryName;
        protected boolean isDisabled;
        protected Consumer<T> changeCallback;
        protected T defaultValue;
        protected T value;

        public Option(Field field, String entryName, String mixinName) {
            this.field = field;
            String fieldName = field.getName().toLowerCase(Locale.ROOT);
            this.name = entryName + "." + fieldName;
            this.translationKey = "keybindbugfixes.config." + this.name;
            this.mixinName = mixinName.isEmpty() ? fieldName : mixinName;
            this.entryName = entryName;
            OPTION_MIXIN_MAP.put(this.mixinName, this);
            OPTIONS.add(this);
        }

        public String name() {
            return this.name;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public String mixinName() {
            return this.mixinName;
        }

        public boolean isDisabled() {
            return this.isDisabled;
        }

        protected abstract Class<T> valueType();

        protected abstract T disabledValue();

        public void initValue() {
            this.changeCallback = value -> {
                try {
                    this.field.set(null, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            try {
                Class<T> valueType = this.valueType();
                this.defaultValue = valueType.cast(this.field.get(valueType));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void loadValue() {
            if (this.isDisabled) {
                this.setValue(this.disabledValue());
            } else {
                boolean success = this.jsonElement != null ? this.loadFromJson(this.jsonElement) : false;
                if (!success) {
                    this.setValue(this.defaultValue);
                    if (displayMissingConfigEntryError) {
                        KeybindBugFixes.LOGGER.error("Couldn't load KeybindBugFixes configuration entry \"" + this.name + "\", resetting");
                    }
                }
            }
        }

        public T value() {
            return this.value;
        }

        public T defaultValue() {
            return this.defaultValue;
        }

        public boolean isDefault() {
            return this.value.equals(this.defaultValue);
        }

        public void setValue(T value) {
            if (this.value != value) {
                this.value = value;
                this.changeCallback.accept(this.value);
            }
        }

        public void resetValue() {
            this.setValue(this.defaultValue);
        }

        public void write(JsonObject json) {
            if (this.isDisabled) {
                json.add(this.name, null);
            } else {
                this.writeToJson(json);
            }
        }

        public void load(JsonElement jsonElement) {
            this.isDisabled = jsonElement == null ? false : jsonElement.isJsonNull();
            this.jsonElement = jsonElement;
        }

        protected abstract void writeToJson(JsonObject var1);

        protected abstract boolean loadFromJson(JsonElement var1);
    }

    public static class MixinMap {
        public final Map<String, Set<Option<?>>> map = Maps.newHashMap();

        public void put(String key, Option<?> option) {
            this.map.putIfAbsent(key, Sets.newHashSet());
            this.map.get(key).add(option);
        }

        public Set<Map.Entry<String, Set<Option<?>>>> entrySet() {
            return this.map.entrySet();
        }
    }
}

