/*
 * Decompiled with CFR 0.152.
 */
package keybindbugfixes.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import keybindbugfixes.KeybindBugFixes;
import keybindbugfixes.config.ConfigManager;
import keybindbugfixes.config.ConfigScreen;
import keybindbugfixes.mixin.KeyBindingAccessor;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_8662;

public class OptionListWidget
extends class_4265<WidgetEntry> {
    private final Set<KeybindWidgetEntry> keybindWidgets = Sets.newHashSet();
    private final ConfigScreen configScreen;
    private static final int OPTION_WIDTH = 174;
    private static final int BUTTON_WIDTH = 20;
    private static final int PADDING = 7;
    private static final int GAP = 4;

    public OptionListWidget(class_310 client, ConfigScreen screen) {
        super(client, screen.field_22789, screen.layout.method_57727(), screen.layout.method_48998(), 25);
        this.field_22744 = false;
        this.configScreen = screen;
    }

    private void addTitle(String key) {
        TitleWidgetEntry widget = new TitleWidgetEntry(this.field_22740, this.configScreen, key);
        this.method_25321((class_350.class_351)widget);
    }

    private void addOption(ConfigManager.Option<?> option) {
        if (option instanceof ConfigManager.BugOption) {
            ConfigManager.BugOption bugOption = (ConfigManager.BugOption)option;
            BugWidgetEntry widget = new BugWidgetEntry(this.field_22740, this.configScreen, bugOption);
            this.method_25321((class_350.class_351)widget);
        } else if (option instanceof ConfigManager.TweakOption) {
            ConfigManager.TweakOption tweakOption = (ConfigManager.TweakOption)option;
            TweakWidgetEntry widget = new TweakWidgetEntry(this.field_22740, this.configScreen, tweakOption);
            this.method_25321((class_350.class_351)widget);
        } else if (option instanceof ConfigManager.KeybindOption) {
            ConfigManager.KeybindOption keybindOption = (ConfigManager.KeybindOption)option;
            KeybindWidgetEntry widget = new KeybindWidgetEntry(this.field_22740, this.configScreen, keybindOption);
            this.keybindWidgets.add(widget);
            this.method_25321((class_350.class_351)widget);
        }
    }

    public void init(List<ConfigManager.Category> categories) {
        for (ConfigManager.Category category : categories) {
            boolean titleAdded = false;
            for (ConfigManager.Option<?> option : category.options()) {
                if (!KeybindBugFixes.shouldAddOption(option)) continue;
                if (!titleAdded) {
                    this.addTitle(category.translationKey());
                    titleAdded = true;
                }
                this.addOption(option);
            }
        }
    }

    private void updateKeybindWarnings() {
        for (KeybindWidgetEntry widget : this.keybindWidgets) {
            widget.updateButtonWarning();
        }
    }

    public int method_25322() {
        return this.configScreen.field_22789;
    }

    protected int method_65507() {
        return this.field_22758 - 7;
    }

    public static class TitleWidgetEntry
    extends WidgetEntry {
        private final class_310 client;
        private final ConfigScreen configScreen;
        private final String translationKey;

        public TitleWidgetEntry(class_310 client, ConfigScreen screen, String translationKey) {
            this.client = client;
            this.configScreen = screen;
            this.translationKey = translationKey;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_5250 text = class_2561.method_43471((String)this.translationKey);
            int centerX = this.configScreen.field_22789 / 2;
            context.method_27534(this.client.field_1772, (class_2561)text, centerX, this.method_46427() + 5, -1);
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }
    }

    public static class BugWidgetEntry
    extends WidgetEntry {
        private final ConfigManager.BugOption option;
        private final class_4185 optionButton;
        private final class_4185 resetButton;
        private final class_4185 linkButton;
        private final OptionWidget optionWidget;

        private class_2561 message() {
            boolean value = (Boolean)this.option.value();
            return class_2561.method_43471((String)(value ? "gui.yes" : "gui.no")).method_27692(value ? class_124.field_1060 : class_124.field_1061);
        }

        private class_7919 tooltip() {
            return class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.option.translationKey() + ".tooltip")));
        }

        private void updateButton() {
            this.optionButton.method_25355(this.message());
            this.resetButton.field_22763 = !this.option.isDefault();
        }

        public void toggleValue() {
            this.option.toggleValue();
            this.updateButton();
        }

        public void resetValue() {
            this.option.resetValue();
            this.updateButton();
        }

        public BugWidgetEntry(class_310 client, ConfigScreen screen, ConfigManager.BugOption option) {
            this.option = option;
            this.linkButton = class_8662.method_52723((class_2561)class_5244.field_39003, button -> this.option.openLink(screen), (boolean)true).method_52725(20).method_52727(class_2960.method_60654((String)"keybindbugfixes:icon/link"), 16, 16).method_52724();
            this.optionButton = class_4185.method_46430((class_2561)this.message(), button -> this.toggleValue()).method_46436(this.tooltip()).method_46431();
            this.resetButton = class_8662.method_52723((class_2561)class_5244.field_39003, button -> this.resetValue(), (boolean)true).method_52725(20).method_52727(class_2960.method_60654((String)"keybindbugfixes:icon/reset"), 16, 16).method_52724();
            this.resetButton.field_22763 = !this.option.isDefault();
            this.linkButton.field_22763 = this.option.link() != null;
            this.optionWidget = new OptionWidgetBuilder(client, screen, option, this.optionButton).addLeft(this.resetButton).addRight(this.linkButton).build();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            this.optionWidget.render(context, this.method_46427(), mouseX, mouseY, deltaTicks);
        }

        public List<? extends class_6379> method_37025() {
            return this.optionWidget.widgets();
        }

        public List<? extends class_364> method_25396() {
            return this.optionWidget.widgets();
        }
    }

    public static class TweakWidgetEntry
    extends WidgetEntry {
        private final ConfigManager.TweakOption option;
        private final class_4185 optionButton;
        private final class_4185 resetButton;
        private final OptionWidget optionWidget;

        private class_2561 message() {
            boolean value = (Boolean)this.option.value();
            return class_2561.method_43471((String)(value ? "gui.yes" : "gui.no")).method_27692(value ? class_124.field_1060 : class_124.field_1061);
        }

        private class_7919 tooltip() {
            return class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.option.translationKey() + ".tooltip")));
        }

        private void updateButton() {
            this.optionButton.method_25355(this.message());
            this.resetButton.field_22763 = !this.option.isDefault();
        }

        public void toggleValue() {
            this.option.toggleValue();
            this.updateButton();
        }

        public void resetValue() {
            this.option.resetValue();
            this.updateButton();
        }

        public TweakWidgetEntry(class_310 client, ConfigScreen screen, ConfigManager.TweakOption option) {
            this.option = option;
            this.optionButton = class_4185.method_46430((class_2561)this.message(), button -> this.toggleValue()).method_46436(this.tooltip()).method_46431();
            this.resetButton = class_8662.method_52723((class_2561)class_5244.field_39003, button -> this.resetValue(), (boolean)true).method_52725(20).method_52727(class_2960.method_60654((String)"keybindbugfixes:icon/reset"), 16, 16).method_52724();
            this.resetButton.field_22763 = !this.option.isDefault();
            this.optionWidget = new OptionWidgetBuilder(client, screen, option, this.optionButton).addLeft(this.resetButton).build();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.optionWidget.render(context, this.method_46427(), mouseX, mouseY, tickDelta);
        }

        public List<? extends class_6379> method_37025() {
            return this.optionWidget.widgets();
        }

        public List<? extends class_364> method_25396() {
            return this.optionWidget.widgets();
        }
    }

    public static class KeybindWidgetEntry
    extends WidgetEntry {
        private final class_310 client;
        private final ConfigScreen configScreen;
        private final ConfigManager.KeybindOption option;
        private final class_4185 optionButton;
        private final class_4185 resetButton;
        private final OptionWidget optionWidget;
        private class_5250 duplicateText;
        private Warning warning;

        private void updateWarning() {
            this.warning = Warning.NONE;
            this.duplicateText = class_2561.method_43473();
            if (this.option.isUnbound()) {
                return;
            }
            ConfigManager.KeybindOption modifier = this.option.modifier();
            class_3675.class_306 modifierKey = modifier != null ? (class_3675.class_306)modifier.value() : null;
            class_3675.class_306 key = (class_3675.class_306)this.option.value();
            if (modifier != null) {
                if (modifierKey.method_1444() == -1) {
                    this.warning = Warning.UNKNOWN_MODIFIER;
                    return;
                }
                if (modifierKey.equals((Object)key)) {
                    this.warning = Warning.SAME_MODIFIER;
                    return;
                }
            } else {
                for (class_304 keyBinding : this.client.field_1690.field_1839) {
                    if (!((KeyBindingAccessor)keyBinding).getBoundKey().equals((Object)key)) continue;
                    if (this.warning != Warning.DUPLICATE) {
                        this.warning = Warning.DUPLICATE;
                    } else {
                        this.duplicateText.method_27693(", ");
                    }
                    this.duplicateText.method_10852((class_2561)class_2561.method_43471((String)keyBinding.method_1431()));
                }
            }
            for (ConfigManager.KeybindOption option : ConfigManager.KEYBIND_OPTIONS) {
                class_3675.class_306 optionModifierKey;
                if (option == this.option) continue;
                ConfigManager.KeybindOption optionModifier = option.modifier();
                class_3675.class_306 class_3062 = optionModifierKey = optionModifier != null ? (class_3675.class_306)optionModifier.value() : null;
                if (!key.equals(option.value()) || !Objects.equals(modifierKey, optionModifierKey)) continue;
                if (this.warning != Warning.DUPLICATE) {
                    this.warning = Warning.DUPLICATE;
                } else {
                    this.duplicateText.method_27693(", ");
                }
                this.duplicateText.method_10852((class_2561)class_2561.method_43471((String)option.translationKey()));
            }
        }

        private class_2561 message() {
            class_5250 text = class_2561.method_43470((String)"[ ").method_10852((class_2561)((class_3675.class_306)this.option.value()).method_27445().method_27661().method_27692(class_124.field_1068)).method_27693(" ]");
            if (this.warning == Warning.DUPLICATE) {
                return text.method_27692(class_124.field_1054);
            }
            if (this.warning != Warning.NONE) {
                return text.method_27692(class_124.field_1061);
            }
            return ((class_3675.class_306)this.option.value()).method_27445();
        }

        private class_7919 tooltip() {
            ConfigManager.KeybindOption modifier = this.option.modifier();
            if (this.warning == Warning.DUPLICATE) {
                return class_7919.method_47407((class_2561)class_2561.method_43469((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{this.duplicateText}));
            }
            if (modifier != null) {
                if (this.warning == Warning.UNKNOWN_MODIFIER) {
                    return class_7919.method_47407((class_2561)class_2561.method_43469((String)"keybindbugfixes.config.keybinds.unknownModifier", (Object[])new Object[]{class_2561.method_43471((String)modifier.translationKey())}));
                }
                if (this.warning == Warning.SAME_MODIFIER) {
                    return class_7919.method_47407((class_2561)class_2561.method_43469((String)"keybindbugfixes.config.keybinds.sameModifier", (Object[])new Object[]{class_2561.method_43471((String)modifier.translationKey())}));
                }
            }
            return null;
        }

        public void updateButton() {
            this.configScreen.list.updateKeybindWarnings();
            this.resetButton.field_22763 = !this.option.isDefault();
        }

        public void updateButtonWarning() {
            this.updateWarning();
            this.optionButton.method_25355(this.message());
            this.optionButton.method_47400(this.tooltip());
        }

        public void selectButton() {
            this.configScreen.selectedKeybindWidget = this;
            this.optionButton.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)this.optionButton.method_25369().method_27661().method_27695(new class_124[]{class_124.field_1068, class_124.field_1073})).method_27693(" <").method_27692(class_124.field_1054));
        }

        public void resetValue() {
            this.option.resetValue();
            this.updateButton();
        }

        public KeybindWidgetEntry(class_310 client, ConfigScreen screen, ConfigManager.KeybindOption option) {
            this.client = client;
            this.configScreen = screen;
            this.option = option;
            this.updateWarning();
            this.optionButton = class_4185.method_46430((class_2561)this.message(), button -> this.selectButton()).method_46436(this.tooltip()).method_46431();
            this.resetButton = class_8662.method_52723((class_2561)class_5244.field_39003, button -> this.resetValue(), (boolean)true).method_52725(20).method_52727(class_2960.method_60654((String)"keybindbugfixes:icon/reset"), 16, 16).method_52724();
            this.resetButton.field_22763 = !this.option.isDefault();
            this.optionWidget = new OptionWidgetBuilder(client, screen, option, this.optionButton).addLeft(this.resetButton).build();
        }

        public ConfigManager.KeybindOption option() {
            return this.option;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.optionWidget.render(context, this.method_46427(), mouseX, mouseY, tickDelta);
        }

        public List<? extends class_6379> method_37025() {
            return this.optionWidget.widgets();
        }

        public List<? extends class_364> method_25396() {
            return this.optionWidget.widgets();
        }

        public static enum Warning {
            DUPLICATE,
            UNKNOWN_MODIFIER,
            SAME_MODIFIER,
            NONE;

        }
    }

    public static abstract class WidgetEntry
    extends class_4265.class_4266<WidgetEntry> {
    }

    public static class OptionWidgetBuilder {
        private final class_310 client;
        private final ConfigScreen configScreen;
        private final ConfigManager.Option<?> option;
        private final class_4185 centerWidget;
        private final List<class_4185> leftWidgets = Lists.newArrayList();
        private final List<class_4185> rightWidgets = Lists.newArrayList();

        public OptionWidgetBuilder(class_310 client, ConfigScreen configScreen, ConfigManager.Option<?> option, class_4185 centerWidget) {
            this.client = client;
            this.configScreen = configScreen;
            this.option = option;
            this.centerWidget = centerWidget;
        }

        public OptionWidgetBuilder addLeft(class_4185 widget) {
            this.leftWidgets.addFirst(widget);
            return this;
        }

        public OptionWidgetBuilder addRight(class_4185 widget) {
            this.rightWidgets.addLast(widget);
            return this;
        }

        public OptionWidget build() {
            ArrayList widgets = Lists.newArrayList();
            ArrayList offsets = Lists.newArrayList();
            widgets.addAll(this.rightWidgets);
            widgets.add(this.centerWidget);
            widgets.addAll(this.leftWidgets);
            int centerWidgetWidth = 174;
            for (class_4185 widget : this.leftWidgets) {
                centerWidgetWidth -= widget.method_25368() + 4;
            }
            for (class_4185 widget : this.rightWidgets) {
                centerWidgetWidth -= widget.method_25368() + 4;
            }
            this.centerWidget.method_25358(centerWidgetWidth);
            int lastOffset = 7;
            for (class_4185 widget : widgets) {
                offsets.add(lastOffset += widget.method_25368() + 4);
            }
            return new OptionWidget(this.client, this.configScreen, this.option, widgets, offsets);
        }
    }

    public static class OptionWidget {
        private final class_310 client;
        private final ConfigScreen configScreen;
        private final ConfigManager.Option<?> option;
        private final List<class_4185> widgets;
        private final List<Integer> offsets;

        public OptionWidget(class_310 client, ConfigScreen configScreen, ConfigManager.Option<?> option, List<class_4185> widgets, List<Integer> offsets) {
            this.client = client;
            this.configScreen = configScreen;
            this.option = option;
            this.widgets = widgets;
            this.offsets = offsets;
        }

        private static void drawText(class_327 textRenderer, class_332 context, class_2561 text, int wrapX, int y) {
            int textX = 11;
            int textY = y + 6;
            int textWidth = wrapX - textX;
            for (class_5481 orderedText : textRenderer.method_1728((class_5348)text, textWidth)) {
                context.method_51430(textRenderer, orderedText, textX, textY, -1, true);
                textY += 9;
            }
        }

        public void render(class_332 context, int y, int mouseX, int mouseY, float tickDelta) {
            for (int i = 0; i < this.widgets.size(); ++i) {
                class_4185 widget = this.widgets.get(i);
                int offset = this.offsets.get(i);
                widget.method_48229(this.configScreen.field_22789 - offset, y);
                widget.method_25394(context, mouseX, mouseY, tickDelta);
            }
            int wrapX = this.configScreen.field_22789 - 7 - 4 - 174 - 4;
            class_5250 text = class_2561.method_43471((String)this.option.translationKey());
            OptionWidget.drawText(this.client.field_1772, context, (class_2561)text, wrapX, y);
        }

        public List<class_4185> widgets() {
            return this.widgets;
        }
    }
}

