/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.kitchentools.blocks;

import com.keletu.kitchentools.KitchenTools;
import com.keletu.kitchentools.blocks.BlockBase;
import com.keletu.kitchentools.blocks.BlockMagmaSmeltery;
import com.keletu.kitchentools.init.KTBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPlaceholder
extends BlockBase {
    private Item drop;

    public BlockPlaceholder(String name, Material material, Item drop, SoundType sound, float hard, float res, int lightOp, String inst, int lvl) {
        super(name, material);
        this.func_149672_a(sound);
        this.func_149711_c(hard);
        this.func_149752_b(res);
        this.func_149713_g(lightOp);
        this.setHarvestLevel(inst, lvl);
        this.drop = drop;
        this.func_149647_a(null);
    }

    @Override
    public void registerModels() {
        KitchenTools.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() instanceof BlockPlaceholder && !BlockMagmaSmeltery.ignoreDestroy && !worldIn.field_72995_K) {
            this.destroyFurnace(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void destroyFurnace(World worldIn, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos targetPos = pos.func_177982_a(i, j, k);
                    IBlockState targetState = worldIn.func_180495_p(targetPos);
                    if (targetState.func_177230_c() != KTBlocks.FURNACE) continue;
                    BlockMagmaSmeltery.destroyFurnace(worldIn, targetPos, targetState, pos);
                    return;
                }
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity != null && world.func_180495_p(pos) != KTBlocks.AIR_PH.func_176223_P()) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.drop;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.drop);
    }
}

