/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.kitchentools.objects.machines.magmasmeltery;

import com.keletu.kitchentools.objects.machines.magmasmeltery.MagmaSmelteryRecipe;
import com.keletu.kitchentools.util.handlers.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.tiles.TileThaumcraftInventory;
import thaumcraft.common.tiles.devices.TileBellows;

public class TileEntityMagmaSmeltery
extends TileThaumcraftInventory
implements ITickable {
    float speedupTick = 0.0f;
    int processTick = 0;
    int recipeTime = 0;
    int fuel = 0;
    int tick = 0;
    boolean specialFuel;
    public boolean active = false;
    public int facingX = -5;
    public int facingZ = -5;
    public EnumFacing facing = EnumFacing.NORTH;

    public TileEntityMagmaSmeltery() {
        super(32);
    }

    private void setFacing() {
        this.facingX = 0;
        this.facingZ = 0;
        this.facing = EnumFacing.func_82600_a((int)(this.func_145832_p() & 7));
        this.facingX = this.facing.func_82601_c();
        this.facingZ = this.facing.func_82599_e();
    }

    public void addStackToInputs(ItemStack stack) {
        ThaumcraftInvHelper.insertStackAt((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EnumFacing)EnumFacing.UP, (ItemStack)stack, (boolean)false);
    }

    int getBellows() {
        int bellows = 0;
        for (EnumFacing fd : EnumFacing.field_176754_o) {
            int bz;
            int by;
            int bx = this.field_174879_c.func_177958_n() + fd.func_82601_c() * 2;
            BlockPos pos1 = new BlockPos(bx, (by = this.field_174879_c.func_177956_o() + fd.func_96559_d() * 2) - 1, bz = this.field_174879_c.func_177952_p() + fd.func_82599_e() * 2);
            if (!(this.field_145850_b.func_175625_s(pos1) instanceof TileBellows) || ((TileBellows)this.field_145850_b.func_175625_s(pos1)).getFacing() != fd.func_176734_d()) continue;
            ++bellows;
        }
        return bellows;
    }

    int calculateTime() {
        return Math.max(1, this.recipeTime / (this.speedupTick > 0.0f ? 2 : 1) - this.getBellows() * 40);
    }

    void outputItem(ItemStack item) {
        TileEntity inventory = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + this.facing.func_82601_c() * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + this.facing.func_82599_e() * 2));
        if (inventory instanceof IInventory) {
            item = ThaumcraftInvHelper.insertStackAt((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177967_a(this.facing, 2), (EnumFacing)this.facing.func_176734_d(), (ItemStack)item.func_77946_l(), (boolean)false);
        }
        if (item != null) {
            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)this.facing.func_82601_c() * 1.0 * 1.66, (double)this.func_174877_v().func_177956_o() + 0.2, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)this.facing.func_82599_e() * 1.0 * 1.66, item.func_77946_l());
            ei.field_70159_w = 0.075f * (float)this.facing.func_82601_c();
            ei.field_70181_x = 0.025000000372529;
            ei.field_70179_y = 0.075f * (float)this.facing.func_82599_e();
            this.field_145850_b.func_72838_d((Entity)ei);
        }
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 3, 0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.facingX == -5) {
            this.setFacing();
        }
        boolean cooking = false;
        if (this.processTick > 0) {
            int calc;
            --this.processTick;
            cooking = true;
            if (this.speedupTick > 0.0f) {
                this.speedupTick -= 1.0f;
            }
            if (this.processTick > (calc = this.calculateTime())) {
                this.processTick = calc;
            }
        }
        for (int a = 0; a < this.func_70302_i_(); ++a) {
            MagmaSmelteryRecipe recipe;
            ItemStack inputStack = this.func_70301_a(a);
            if (this.processTick > 0 || inputStack.func_190926_b()) continue;
            if (cooking) {
                recipe = MagmaSmelteryRecipe.getRecipeForInput(inputStack);
                ItemStack outputStack = recipe.getOutput();
                this.outputItem(outputStack);
                if (this.func_145831_w().field_73012_v.nextInt(20) == 0) {
                    AuraHelper.polluteAura((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(this.facing.func_176734_d()), (float)1.5f, (boolean)true);
                }
                if (recipe.getBonus() != null) {
                    ItemStack bonus = Utilities.copyStackWithSize(recipe.getBonus(), 0);
                    if (this.getBellows() == 0) {
                        if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                            bonus.func_190920_e(bonus.func_190916_E() + 1);
                        }
                    } else {
                        for (int b = 0; b < this.getBellows(); ++b) {
                            if (!(this.field_145850_b.field_73012_v.nextFloat() < 0.44f)) continue;
                            bonus.func_190920_e(bonus.func_190916_E() + 1);
                        }
                    }
                    this.outputItem(bonus);
                }
                if (this.field_145850_b.field_73012_v.nextInt(5) == 0 && !recipe.isSpecial()) {
                    this.outputItem(new ItemStack(ItemsTC.nuggets, 1, 10));
                }
                this.func_70298_a(a, 1);
                cooking = false;
                this.specialFuel = false;
                continue;
            }
            recipe = MagmaSmelteryRecipe.getRecipeForInput(inputStack);
            if (recipe != null) {
                this.recipeTime = recipe.getSmeltingTime();
                this.processTick = this.calculateTime();
                if (recipe.isSpecial()) {
                    this.specialFuel = true;
                }
            } else {
                this.func_70299_a(a, ItemStack.field_190927_a);
            }
            cooking = true;
        }
        if (cooking != this.active) {
            this.active = cooking;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 3, this.specialFuel ? 1 : 0);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 4, this.active ? 1 : 0);
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.fuel = tags.func_74762_e("fuel");
        this.speedupTick = tags.func_74760_g("speedupTick");
        this.processTick = tags.func_74762_e("processTick");
        this.recipeTime = tags.func_74762_e("recipeTime");
        this.facing = EnumFacing.func_82600_a((int)tags.func_74762_e("facing")).func_176734_d();
        this.active = tags.func_74767_n("active");
        this.specialFuel = tags.func_74767_n("specialFuel");
        this.tick = tags.func_74762_e("tick");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74768_a("fuel", this.fuel);
        tags.func_74776_a("speedupTick", this.speedupTick);
        tags.func_74768_a("processTick", this.processTick);
        tags.func_74768_a("recipeTime", this.recipeTime);
        tags.func_74768_a("facing", this.facing.ordinal());
        tags.func_74768_a("tick", this.tick);
        tags.func_74757_a("active", this.active);
        tags.func_74757_a("specialFuel", this.specialFuel);
        return tags;
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 3) {
            if (this.field_145850_b.field_72995_K) {
                for (int a = 0; a < 5; ++a) {
                    FXDispatcher.INSTANCE.furnaceLavaFx(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.facingX, this.facingZ);
                    this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.1f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.15f, false);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }
}

