/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.kitchentools.util.compat.crafttweaker;

import com.keletu.kitchentools.objects.machines.magmasmeltery.MagmaSmelteryRecipe;
import com.keletu.kitchentools.util.compat.crafttweaker.KTCrafttweaker;
import com.keletu.kitchentools.util.handlers.Utilities;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.kitchentools.MagmaSmeltery")
public class MagmaSmeltery {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int time, IItemStack bonus, boolean isSpecial) {
        Object oInput = KTCrafttweaker.toObject(input);
        if (oInput == null) {
            return;
        }
        Utilities.OreDictStack inputStack = oInput instanceof String ? new Utilities.OreDictStack((String)oInput, input.getAmount()) : (ItemStack)oInput;
        MagmaSmelteryRecipe r = new MagmaSmelteryRecipe(KTCrafttweaker.toStack(output), inputStack, time, isSpecial);
        if (bonus != null) {
            r.addBonus(KTCrafttweaker.toStack(bonus));
        }
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(KTCrafttweaker.toStack(output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<MagmaSmelteryRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = MagmaSmelteryRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing Magma Smeltery Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final MagmaSmelteryRecipe recipe;

        public Add(MagmaSmelteryRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MagmaSmelteryRecipe.addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Magma Smeltery Recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

