/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.kitchentools.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import baubles.api.render.IRenderBauble;
import com.keletu.kitchentools.KitchenTools;
import com.keletu.kitchentools.entity.model.ModelCape;
import com.keletu.kitchentools.items.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;

public class ItemCloak
extends ItemBase
implements IBauble,
IRenderBauble {
    @SideOnly(value=Side.CLIENT)
    private static ModelCape model;
    public static String[] subNames;

    public ItemCloak(String name) {
        super(name);
        this.func_77627_a(true);
        this.func_77625_d(1);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.initClient();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.func_185043_a(new ResourceLocation("type"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (stack.func_77960_j() == 3) {
                    return 1.0f;
                }
                if (stack.func_77960_j() == 4) {
                    return 2.0f;
                }
                return 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.BODY) {
            IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
            boolean armor = !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
            GlStateManager.func_179109_b((float)0.0f, (float)(armor ? -0.07f : -0.01f), (float)0.0f);
            float s = 0.0625f;
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            model = new ModelCape(ColorHandler.getItemColor(stack));
            GlStateManager.func_179145_e();
            GlStateManager.func_179091_B();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture(stack));
            model.renderCloak(1.0f);
        }
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound tagDisplay;
        if (stack.func_190926_b()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (tagDisplay = tag.func_74775_l("display")).func_74764_b("color")) {
            tagDisplay.func_82580_o("color");
        }
    }

    public void setColor(ItemStack stack, int colour) {
        if (stack.func_77960_j() == 3 || stack.func_77960_j() == 4) {
            return;
        }
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound displayTag = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_74764_b("display")) {
            nbttagcompound.func_74782_a("display", (NBTBase)displayTag);
        }
        displayTag.func_74768_a("color", colour);
    }

    public ResourceLocation getTexture(ItemStack itemstack) {
        if (itemstack.func_77960_j() < subNames.length) {
            if (subNames[itemstack.func_77960_j()].equals("wolf")) {
                return new ResourceLocation("kitchentools:textures/models/cape_wolf.png");
            }
            if (subNames[itemstack.func_77960_j()].equals("raven")) {
                return new ResourceLocation("kitchentools:textures/models/cape_raven.png");
            }
        }
        return new ResourceLocation("kitchentools:textures/models/cape.png");
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + subNames[stack.func_77960_j()];
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < subNames.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public ItemStack[] getStoredItems(ItemStack item) {
        ItemStack[] stackList = new ItemStack[27];
        if (item.func_77942_o()) {
            NBTTagList inv = item.func_77978_p().func_150295_c("InternalInventory", 10);
            for (int i = 0; i < inv.func_74745_c(); ++i) {
                NBTTagCompound tag = inv.func_150305_b(i);
                int slot = tag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= stackList.length) continue;
                stackList[slot] = new ItemStack(tag);
            }
        }
        return stackList;
    }

    public void setStoredItems(ItemStack item, ItemStack[] stackList) {
        NBTTagList inv = new NBTTagList();
        for (int i = 0; i < stackList.length; ++i) {
            if (stackList[i].func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stackList[i].func_77955_b(tag);
            inv.func_74742_a((NBTBase)tag);
        }
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        item.func_77978_p().func_74782_a("InternalInventory", (NBTBase)inv);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> list, ITooltipFlag advanced) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("noGlide")) {
            list.add("No Glide Mode");
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (stack.func_77960_j() < subNames.length) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (subNames[stack.func_77960_j()].equals("raven") && !player.field_70122_E && !player.field_71075_bZ.field_75100_b) {
                if (!(!(entity.field_70181_x < 0.0) || stack.func_77942_o() && stack.func_77978_p().func_74767_n("noGlide"))) {
                    float mod = entity.func_70093_af() ? 0.1f : 0.05f;
                    entity.field_70181_x = entity.field_70181_x * (entity.func_70093_af() ? 0.75 : 0.5);
                    double x = Math.cos(Math.toRadians(entity.field_70759_as + 90.0f)) * (double)mod;
                    double z = Math.sin(Math.toRadians(entity.field_70759_as + 90.0f)) * (double)mod;
                    entity.field_70159_w += x;
                    entity.field_70179_y += z;
                }
                entity.field_70143_R = 0.0f;
            }
            if (subNames[stack.func_77960_j()].equals("spectral") && !player.field_70170_p.field_72995_K && stack.func_77978_p().func_74767_n("isSpectral")) {
                List entities = player.field_70170_p.func_72872_a(EntityCreature.class, new AxisAlignedBB(player.field_70165_t - 16.0, player.field_70163_u - 16.0, player.field_70161_v - 16.0, player.field_70165_t + 16.0, player.field_70163_u + 16.0, player.field_70161_v + 16.0));
                for (EntityCreature e : entities) {
                    if (e == null || !e.func_184222_aU() || !player.equals((Object)e.func_70638_az())) continue;
                    ThaumcraftApi.internalMethods.drainVis(player.field_70170_p, player.func_180425_c(), 0.2f, false);
                    e.func_70624_b(null);
                }
            }
            if (subNames[stack.func_77960_j()].equals("wolf") && stack.func_77942_o() && stack.func_77978_p().func_74764_b("wolfPotion")) {
                int amp = stack.func_77978_p().func_74762_e("wolfPotion");
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 60, amp));
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 60, amp));
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 60, amp));
                stack.func_77978_p().func_82580_o("wolfPotion");
                if (stack.func_77978_p().func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
        }
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("isSpectral")) {
            stack.func_77978_p().func_74757_a("isSpectral", false);
        }
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void registerModels() {
        for (int i = 0; i < 5; ++i) {
            KitchenTools.proxy.registerItemRenderer(this, i, "inventory");
        }
    }

    private ItemStack getBaubleStack(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            ItemStack stack = baubles.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCloak)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void onUserDamaged(LivingHurtEvent event) {
        ItemStack stack;
        if (event.getEntityLiving() instanceof EntityPlayer && (stack = this.getBaubleStack((EntityPlayer)event.getEntityLiving())).func_77952_i() == 3) {
            int amp = 1;
            if (event.getAmount() >= 8.0f) {
                ++amp;
            }
            if (event.getAmount() >= 12.0f) {
                ++amp;
            }
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a("wolfPotion", amp);
        }
    }

    public static void activate(EntityPlayer player, ItemStack stack) {
        block4: {
            block6: {
                block5: {
                    if (stack.func_77952_i() >= subNames.length) break block4;
                    if (!subNames[stack.func_77952_i()].equals("storage") || player.field_70170_p.field_72995_K) break block5;
                    player.openGui((Object)KitchenTools.instance, 4, player.field_70170_p, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
                    break block4;
                }
                if (!subNames[stack.func_77952_i()].equals("raven") || player.field_70170_p.field_72995_K) break block6;
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a("noGlide", !stack.func_77978_p().func_74767_n("noGlide"));
                IBaublesItemHandler handler2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
                for (int i = 0; i < handler2.getSlots(); ++i) {
                    if (handler2.getStackInSlot(i) != stack) continue;
                    handler2.setChanged(i, true);
                    break block4;
                }
                break block4;
            }
            if (!subNames[stack.func_77952_i()].equals("spectral") || player.field_70170_p.field_72995_K) break block4;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a("isSpectral", !stack.func_77978_p().func_74767_n("isSpectral"));
            IBaublesItemHandler handler3 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < handler3.getSlots(); ++i) {
                if (handler3.getStackInSlot(i) != stack) continue;
                handler3.setChanged(i, true);
                break;
            }
        }
    }

    static {
        subNames = new String[]{"standard", "spectral", "storage", "wolf", "raven"};
    }

    @SideOnly(value=Side.CLIENT)
    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            return this.hasColor(stack) ? ColorHandler.getColor(stack) : 0xFFFFFF;
        }

        private boolean hasColor(ItemStack stack) {
            return stack.func_77960_j() != 3 && stack.func_77960_j() != 4;
        }

        private static int getColor(ItemStack stack) {
            if (stack.func_190926_b()) {
                return 0xFFFFFF;
            }
            int meta = stack.func_77960_j();
            if (meta == 0) {
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    return 1711943;
                }
                NBTTagCompound tagDisplay = tag.func_74775_l("display");
                return tagDisplay == null ? 1711943 : (tagDisplay.func_74764_b("color") ? tagDisplay.func_74762_e("color") : 1711943);
            }
            switch (meta) {
                case 1: {
                    return 0x1D1D1D;
                }
                case 2: {
                    return 0x787877;
                }
            }
            return 0xFFFFFF;
        }

        public static int getItemColor(ItemStack stack) {
            return ColorHandler.getColor(stack);
        }
    }
}

