/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.kitchentools;

import com.keletu.kitchentools.init.KTAspects;
import com.keletu.kitchentools.init.KTMulti;
import com.keletu.kitchentools.init.KTRecipes;
import com.keletu.kitchentools.objects.machines.magmasmeltery.MagmaSmelteryRecipe;
import com.keletu.kitchentools.proxy.CommonProxy;
import com.keletu.kitchentools.tabs.KitchenTab;
import com.keletu.kitchentools.util.handlers.NetworkHandler;
import com.keletu.kitchentools.util.handlers.PickUpHandler;
import com.keletu.kitchentools.util.handlers.RegistyHandler;
import com.keletu.kitchentools.util.handlers.TileEntityHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.research.ResearchCategories;

@Mod(modid="kitchentools", name="Kitchen Tools", version="0.4.2", dependencies="required-after:thaumcraft", acceptedMinecraftVersions="[1.12.2]")
public class KitchenTools {
    public static final String MODID = "kitchentools";
    @Mod.Instance
    public static KitchenTools instance;
    public static final CreativeTabs ITEMTAB;
    private static final ResourceLocation research_icon;
    private static final ResourceLocation research_background;
    @SidedProxy(clientSide="com.keletu.kitchentools.proxy.ClientProxy", serverSide="com.keletu.kitchentools.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void PreInit(FMLPreInitializationEvent event) {
        RegistyHandler.preInitRegistries();
        MinecraftForge.EVENT_BUS.register(PickUpHandler.class);
        MinecraftForge.EVENT_BUS.register(KTAspects.class);
        proxy.preInit();
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        TileEntityHandler.registerTileEntities();
        ResearchCategories.registerCategory((String)"KITCHENTS", (String)"UNLOCKINFUSION", null, (ResourceLocation)research_icon, (ResourceLocation)research_background);
        ResourceLocation loc = new ResourceLocation(MODID, "research/kitchen_tools");
        ThaumcraftApi.registerResearchLocation((ResourceLocation)loc);
        KTRecipes.InitRecipes();
        KTMulti.InitMultiblocks();
        proxy.init();
    }

    @Mod.EventHandler
    public static void PostInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        MagmaSmelteryRecipe.tryAddIngotImprovement("Iron", "Steel", true);
        MagmaSmelteryRecipe.tryAddSpecialOreMelting("Tungsten", "Tungsten", true);
        MagmaSmelteryRecipe.tryAddSpecialOreMelting("Rutile", "Titanium", true);
    }

    static {
        ITEMTAB = new KitchenTab("kitchen_tools");
        research_icon = new ResourceLocation(MODID, "textures/items/nether_cake.png");
        research_background = new ResourceLocation(MODID, "textures/gui/research/research_back.png");
    }
}

