/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.ServerPlayer;
import dev.amsam0.voicechatdiscord.BukkitHelper;
import dev.amsam0.voicechatdiscord.Component;
import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.EventListener;
import dev.amsam0.voicechatdiscord.PaperPlugin;
import dev.amsam0.voicechatdiscord.Platform;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PaperPlatform
implements Platform {
    private boolean shouldTryMoonrise = true;
    private boolean shouldTryGetBukkitEntityWithoutReflection = true;
    private Method CraftWorld$getHandle;
    private Method ServerLevel$getEntityLookup;
    private Method EntityLookup$get;
    private Method Entity$getBukkitEntity;
    private boolean printedReflectionFail = false;

    @Override
    public boolean isValidPlayer(CommandContext<?> sender) {
        return PaperPlugin.commandHelper.bukkitEntity(sender) instanceof Player;
    }

    @Override
    public ServerPlayer commandContextToPlayer(CommandContext<?> context) {
        return Core.api.fromServerPlayer((Object)PaperPlugin.commandHelper.bukkitEntity(context));
    }

    private net.minecraft.world.entity.Entity getNmsEntityOld(WorldServer nmsLevel, UUID uuid) {
        try {
            if (this.ServerLevel$getEntityLookup == null) {
                this.ServerLevel$getEntityLookup = nmsLevel.getClass().getDeclaredMethod("getEntityLookup", new Class[0]);
            }
            Object entityLookup = this.ServerLevel$getEntityLookup.invoke((Object)nmsLevel, new Object[0]);
            if (this.EntityLookup$get == null) {
                this.EntityLookup$get = entityLookup.getClass().getDeclaredMethod("get", UUID.class);
            }
            return (net.minecraft.world.entity.Entity)this.EntityLookup$get.invoke(entityLookup, uuid);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.debug("Failed to get nms entity", e);
            return nmsLevel.d(uuid);
        }
    }

    private Entity getBukkitEntityReflection(net.minecraft.world.entity.Entity nmsEntity) {
        try {
            if (this.Entity$getBukkitEntity == null) {
                this.Entity$getBukkitEntity = nmsEntity.getClass().getDeclaredMethod("getBukkitEntity", new Class[0]);
            }
            return (Entity)this.Entity$getBukkitEntity.invoke((Object)nmsEntity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (!this.printedReflectionFail) {
                this.error("Failed to get bukkit entity", e);
                this.printedReflectionFail = true;
            }
            return nmsEntity.getBukkitEntity();
        }
    }

    @Nullable
    private Position getEntityPosition(WorldServer nmsLevel, UUID uuid) {
        net.minecraft.world.entity.Entity nmsEntity = null;
        if (this.shouldTryMoonrise) {
            try {
                nmsEntity = nmsLevel.moonrise$getEntityLookup().get(uuid);
            }
            catch (NoSuchMethodError ignored) {
                this.shouldTryMoonrise = false;
                this.debug("Moonrise failed");
            }
        }
        if (!this.shouldTryMoonrise) {
            nmsEntity = this.getNmsEntityOld(nmsLevel, uuid);
        }
        if (nmsEntity == null) {
            return null;
        }
        CraftEntity bukkitEntity = null;
        if (this.shouldTryGetBukkitEntityWithoutReflection) {
            try {
                bukkitEntity = nmsEntity.getBukkitEntity();
            }
            catch (NoSuchMethodError ignored) {
                this.shouldTryGetBukkitEntityWithoutReflection = false;
                this.debug("Getting bukkit entity without reflection failed");
            }
        }
        if (!this.shouldTryGetBukkitEntityWithoutReflection) {
            bukkitEntity = this.getBukkitEntityReflection(nmsEntity);
        }
        if (bukkitEntity == null) {
            return null;
        }
        return Core.api.createPosition(bukkitEntity.getLocation().getX(), bukkitEntity.getLocation().getY(), bukkitEntity.getLocation().getZ());
    }

    @Override
    @Nullable
    public Position getEntityPosition(ServerLevel level, UUID uuid) {
        try {
            Object object = level.getServerLevel();
            if (object instanceof World) {
                World world = (World)object;
                if (this.CraftWorld$getHandle == null) {
                    this.CraftWorld$getHandle = BukkitHelper.getCraftWorld().getMethod("getHandle", new Class[0]);
                }
                WorldServer nmsLevel = (WorldServer)this.CraftWorld$getHandle.invoke((Object)world, new Object[0]);
                return this.getEntityPosition(nmsLevel, uuid);
            }
            object = level.getServerLevel();
            if (object instanceof WorldServer) {
                WorldServer nmsLevel = (WorldServer)object;
                return this.getEntityPosition(nmsLevel, uuid);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.error("level is not World or ServerLevel, it is " + level.getClass().getSimpleName() + ". Please report this on GitHub Issues!");
        return null;
    }

    @Override
    public boolean isOperator(CommandContext<?> sender) {
        return PaperPlugin.commandHelper.bukkitSender(sender).isOp();
    }

    @Override
    public boolean hasPermission(CommandContext<?> sender, String permission) {
        return PaperPlugin.commandHelper.bukkitSender(sender).hasPermission(permission);
    }

    @Override
    public void sendMessage(CommandContext<?> sender, Component ... message) {
        Entity entity = PaperPlugin.commandHelper.bukkitEntity(sender);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.sendMessage(this.toNative(message));
        } else {
            PaperPlugin.commandHelper.bukkitSender(sender).sendMessage(this.toNative(message));
        }
    }

    @Override
    public void sendMessage(de.maxhenkel.voicechat.api.Player player, Component ... message) {
        ((Player)player.getPlayer()).sendMessage(this.toNative(message));
    }

    public void sendMessage(CommandSender sender, Component ... message) {
        sender.sendMessage(this.toNative(message));
    }

    private net.kyori.adventure.text.Component toNative(Component ... message) {
        Object nativeComponent = null;
        for (Component component : message) {
            String string = component.text();
            TextComponent mapped = net.kyori.adventure.text.Component.text((String)string, (TextColor)(switch (component.color()) {
                default -> throw new MatchException(null, null);
                case Component.Color.WHITE -> NamedTextColor.WHITE;
                case Component.Color.RED -> NamedTextColor.RED;
                case Component.Color.YELLOW -> NamedTextColor.YELLOW;
                case Component.Color.GREEN -> NamedTextColor.GREEN;
            }));
            nativeComponent = nativeComponent == null ? mapped : nativeComponent.append((net.kyori.adventure.text.Component)mapped);
        }
        if (nativeComponent == null) {
            return net.kyori.adventure.text.Component.empty();
        }
        return nativeComponent;
    }

    @Override
    public String getName(de.maxhenkel.voicechat.api.Player player) {
        return ((Player)player.getPlayer()).getName();
    }

    @Override
    public void setOnPlayerLeaveHandler(Consumer<UUID> handler) {
        EventListener.onPlayerLeaveHandler = handler;
    }

    @Override
    @Nullable
    public String getSimpleVoiceChatVersion() {
        Plugin svcPlugin = Bukkit.getServer().getPluginManager().getPlugin("voicechat");
        if (svcPlugin == null) {
            this.error("Simple Voice Chat plugin is null");
            return null;
        }
        return svcPlugin.getDescription().getVersion();
    }

    @Override
    public String getConfigPath() {
        return "plugins/voicechat-discord/config.yml";
    }

    @Override
    public Platform.Loader getLoader() {
        return Platform.Loader.PAPER;
    }

    @Override
    public void info(String message) {
        PaperPlugin.LOGGER.info(message);
    }

    @Override
    public void warn(String message) {
        PaperPlugin.LOGGER.warn(message);
    }

    @Override
    public void error(String message) {
        PaperPlugin.LOGGER.error(message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        PaperPlugin.LOGGER.error(message, throwable);
    }
}

