/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import de.maxhenkel.voicechat.api.BukkitVoicechatService;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import dev.amsam0.voicechatdiscord.CommandHelper;
import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.EventListener;
import dev.amsam0.voicechatdiscord.PaperPlatform;
import dev.amsam0.voicechatdiscord.PaperVoicechatPlugin;
import dev.amsam0.voicechatdiscord.post_1_20_6.Post_1_20_6_CommandHelper;
import dev.amsam0.voicechatdiscord.pre_1_20_6.Pre_1_20_6_CommandHelper;
import dev.amsam0.voicechatdiscord.shadow.semver.ParseException;
import dev.amsam0.voicechatdiscord.shadow.semver.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PaperPlugin
extends JavaPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"voicechat-discord");
    public static PaperPlugin INSTANCE;
    public static CommandHelper commandHelper;
    private final EventListener eventListener = new EventListener();
    private PaperVoicechatPlugin voicechatPlugin;

    public static PaperPlugin get() {
        return INSTANCE;
    }

    public void onEnable() {
        INSTANCE = this;
        if (Core.platform == null) {
            Core.platform = new PaperPlatform();
        }
        String rawVersion = this.getServer().getMinecraftVersion().split(" ")[0];
        try {
            Version parsed = Version.parse(rawVersion, false);
            Version wantedCommandHelper = Version.of(1L, 20L, 6L);
            if (parsed.isHigherThanOrEquivalentTo(wantedCommandHelper)) {
                Core.platform.info("Server is >=1.20.6 (" + rawVersion + ")");
                commandHelper = new Post_1_20_6_CommandHelper();
            } else {
                Core.platform.info("Server is <1.20.6 (" + rawVersion + ")");
                commandHelper = new Pre_1_20_6_CommandHelper();
            }
        }
        catch (ParseException | IllegalArgumentException e) {
            Core.platform.error("Unable to parse server version (" + rawVersion + ")", e);
            if (rawVersion.equals("1.19.2") || rawVersion.equals("1.19.3") || rawVersion.equals("1.19.4") || rawVersion.equals("1.20") || rawVersion.equals("1.20.0") || rawVersion.equals("1.20.1") || rawVersion.equals("1.20.2") || rawVersion.equals("1.20.3") || rawVersion.equals("1.20.4") || rawVersion.equals("1.20.5")) {
                Core.platform.info("Server is most likely <1.20.6");
                commandHelper = new Pre_1_20_6_CommandHelper();
            }
            Core.platform.info("Server is most likely >=1.20.6");
            commandHelper = new Post_1_20_6_CommandHelper();
        }
        BukkitVoicechatService service = (BukkitVoicechatService)this.getServer().getServicesManager().load(BukkitVoicechatService.class);
        if (service == null) {
            LOGGER.error("Failed to register voicechat discord plugin");
            throw new RuntimeException("Failed to register voicechat discord plugin");
        }
        this.voicechatPlugin = new PaperVoicechatPlugin();
        service.registerPlugin((VoicechatPlugin)this.voicechatPlugin);
        LOGGER.info("Successfully registered voicechat discord plugin");
        Core.enable();
        Bukkit.getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)this);
        commandHelper.registerCommands();
    }

    public void onDisable() {
        Core.disable();
        if (this.voicechatPlugin != null) {
            this.getServer().getServicesManager().unregister((Object)this.voicechatPlugin);
            LOGGER.info("Successfully unregistered voicechat discord plugin");
        }
    }
}

