/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.audiolistener.AudioListener;
import de.maxhenkel.voicechat.api.audiosender.AudioSender;
import de.maxhenkel.voicechat.api.packets.EntitySoundPacket;
import de.maxhenkel.voicechat.api.packets.LocationalSoundPacket;
import de.maxhenkel.voicechat.api.packets.SoundPacket;
import de.maxhenkel.voicechat.api.packets.StaticSoundPacket;
import dev.amsam0.voicechatdiscord.Component;
import dev.amsam0.voicechatdiscord.Core;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public final class DiscordBot {
    private static final int MILLISECONDS_UNTIL_RESET = 1000;
    private final long vcId;
    private final long ptr;
    private ServerPlayer player;
    private AudioSender sender;
    private Thread senderThread;
    private Long lastTimeAudioProvidedToSVC;
    private Thread resetThread;
    private AudioListener listener;
    private int connectionNumber = 0;

    @Nullable
    public ServerPlayer player() {
        return this.player;
    }

    public boolean whispering() {
        return this.sender.isWhispering();
    }

    public void whispering(boolean set) {
        this.sender.whispering(set);
    }

    private static native long _new(String var0, long var1);

    public DiscordBot(String token, long vcId) {
        this.vcId = vcId;
        this.ptr = DiscordBot._new(token, vcId);
    }

    public void logInAndStart(ServerPlayer player) {
        this.player = player;
        if (this.logIn()) {
            this.start();
        }
    }

    private native boolean _isStarted(long var1);

    public boolean isStarted() {
        return this._isStarted(this.ptr);
    }

    private native void _logIn(long var1) throws Throwable;

    private boolean logIn() {
        try {
            this._logIn(this.ptr);
            Core.platform.debug("Logged into the bot with vc_id " + this.vcId);
            return true;
        }
        catch (Throwable e) {
            Core.platform.error("Failed to login to the bot with vc_id " + this.vcId, e);
            if (this.player != null) {
                Core.platform.sendMessage((Player)this.player, Component.red("Failed to login to the bot. Please contact your server owner and ask them to look at the console since they will be able to see the error message."));
                this.player = null;
            }
            return false;
        }
    }

    private native String _start(long var1) throws Throwable;

    private void start() {
        try {
            assert (this.player != null);
            String vcName = this._start(this.ptr);
            VoicechatConnection connection = Core.api.getConnectionOf(this.player);
            assert (connection != null);
            this.listener = Core.api.playerAudioListenerBuilder().setPacketListener(this::handlePacket).setPlayer(this.player.getUuid()).build();
            Core.api.registerAudioListener(this.listener);
            this.sender = Core.api.createAudioSender(connection);
            if (!Core.api.registerAudioSender(this.sender)) {
                Core.platform.error("Couldn't register audio sender. The player has the mod installed.");
                try {
                    if (this.player != null) {
                        Core.platform.sendMessage((Player)this.player, Component.red("It seems that you have Simple Voice Chat installed on your client. To use the addon, you must not have Simple Voice Chat installed on your client."));
                    }
                }
                catch (Throwable e) {
                    Core.platform.error("Couldn't send error message to player", e);
                }
                this.stop();
                return;
            }
            ++this.connectionNumber;
            this.resetThread = new Thread(() -> {
                int startConnectionNumber = this.connectionNumber;
                Core.platform.debug("reset thread " + startConnectionNumber + " starting");
                while (true) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ignored) {
                        Core.platform.debug("reset thread " + startConnectionNumber + " interrupted");
                        break;
                    }
                    if (this.sender == null || this.connectionNumber != startConnectionNumber) break;
                    if (this.lastTimeAudioProvidedToSVC != null && System.currentTimeMillis() - 1000L > this.lastTimeAudioProvidedToSVC) {
                        Core.platform.debugVerbose("resetting sender for player with UUID " + String.valueOf(this.player.getUuid()));
                        this.sender.reset();
                        this.lastTimeAudioProvidedToSVC = null;
                    }
                    this._resetSenders(this.ptr);
                }
                Core.platform.debug("reset thread " + startConnectionNumber + " ending");
            }, "voicechat-discord: Reset Thread #" + this.connectionNumber);
            this.resetThread.start();
            this.senderThread = new Thread(() -> {
                int startConnectionNumber = this.connectionNumber;
                Core.platform.debug("sender thread " + startConnectionNumber + " starting");
                while (true) {
                    byte[] data = this._blockForSpeakingBufferOpusData(this.ptr);
                    if (this.sender == null || this.connectionNumber != startConnectionNumber) break;
                    if (data.length <= 0) continue;
                    this.sender.send(data);
                    this.lastTimeAudioProvidedToSVC = System.currentTimeMillis();
                }
                Core.platform.debug("sender thread " + startConnectionNumber + " ending");
            }, "voicechat-discord: Sender Thread #" + this.connectionNumber);
            this.senderThread.start();
            connection.setConnected(true);
            Core.platform.info("Started voice chat for " + Core.platform.getName((Player)this.player) + " in channel " + vcName + " with bot with vc_id " + this.vcId);
            Core.platform.sendMessage((Player)this.player, Component.green("Started a voice chat! To stop it, use "), Component.white("/dvc stop"), Component.green(". If you are having issues, try restarting the session with "), Component.white("/dvc start"), Component.green(". Please join the following voice channel in discord: "), Component.white(vcName));
        }
        catch (Throwable e) {
            Core.platform.error("Failed to start voice connection for bot with vc_id " + this.vcId, e);
            try {
                if (this.player != null) {
                    Core.platform.sendMessage((Player)this.player, Component.red("Failed to start voice connection. Please contact your server owner since they will be able to see the error message."));
                }
            }
            catch (Throwable e2) {
                Core.platform.error("Couldn't send error message to player", e2);
            }
            this.stop();
        }
    }

    private native void _stop(long var1) throws Throwable;

    public void stop() {
        ++this.connectionNumber;
        try {
            if (this.listener != null) {
                Core.api.unregisterAudioListener(this.listener);
            }
        }
        catch (Throwable e) {
            Core.platform.error("Failed to stop bot with vc_id " + this.vcId + " (listener)", e);
        }
        try {
            if (this.sender != null) {
                this.sender.reset();
                Core.api.unregisterAudioSender(this.sender);
            }
        }
        catch (Throwable e) {
            Core.platform.error("Failed to stop bot with vc_id " + this.vcId + " (sender)", e);
        }
        try {
            if (this.resetThread != null) {
                this.resetThread.interrupt();
                for (int i = 0; i < 20 && this.resetThread != null && this.resetThread.isAlive(); ++i) {
                    try {
                        Core.platform.debug("waiting for reset thread to end");
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable e) {
            Core.platform.error("Failed to stop bot with vc_id " + this.vcId + " (reset thread)", e);
        }
        try {
            if (this.senderThread != null) {
                this.senderThread.interrupt();
                for (int i = 0; i < 20 && this.senderThread != null && this.senderThread.isAlive(); ++i) {
                    try {
                        Core.platform.debug("waiting for sender thread to end");
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable e) {
            Core.platform.error("Failed to stop bot with vc_id " + this.vcId + " (sender thread)", e);
        }
        try {
            VoicechatConnection connection;
            if (this.player != null && (connection = Core.api.getConnectionOf(this.player)) != null) {
                connection.setConnected(false);
            }
        }
        catch (Throwable e) {
            Core.platform.error("Failed to stop bot with vc_id " + this.vcId + " (connection)", e);
        }
        --this.connectionNumber;
        this.lastTimeAudioProvidedToSVC = null;
        this.listener = null;
        this.sender = null;
        this.resetThread = null;
        this.senderThread = null;
        this.player = null;
        try {
            this._stop(this.ptr);
        }
        catch (Throwable e) {
            Core.platform.error("Failed to stop bot with vc_id " + this.vcId, e);
        }
        Core.platform.debug("Stopped bot with vc_id " + this.vcId);
    }

    private native void _free(long var1);

    public void free() {
        this._free(this.ptr);
    }

    private native void _addAudioToHearingBuffer(long var1, int var3, byte[] var4, boolean var5, double var6, double var8);

    public void handlePacket(SoundPacket packet) {
        UUID senderId = packet.getSender();
        boolean shouldHavePosition = false;
        Position position = null;
        double maxDistance = 0.0;
        boolean whispering = false;
        Core.platform.debugExtremelyVerbose("packet is a " + packet.getClass().getSimpleName());
        if (packet instanceof EntitySoundPacket) {
            EntitySoundPacket sound = (EntitySoundPacket)packet;
            shouldHavePosition = true;
            position = Core.platform.getEntityPosition(this.player.getServerLevel(), sound.getEntityUuid());
            maxDistance = sound.getDistance();
            whispering = sound.isWhispering();
        } else if (packet instanceof LocationalSoundPacket) {
            LocationalSoundPacket sound = (LocationalSoundPacket)packet;
            position = sound.getPosition();
            maxDistance = sound.getDistance();
        } else if (!(packet instanceof StaticSoundPacket)) {
            Core.platform.warn("packet is not LocationalSoundPacket, StaticSoundPacket or EntitySoundPacket, it is " + packet.getClass().getSimpleName() + ". Please report this on GitHub Issues!");
        }
        if (shouldHavePosition && position == null) {
            Core.platform.debug("Position is null when non-null expected for " + String.valueOf(senderId));
            return;
        }
        if (whispering) {
            Core.platform.debugExtremelyVerbose("player is whispering, original max distance is " + maxDistance);
            maxDistance = Core.api.getServerConfig().hasKey("whisper_distance") ? Core.api.getServerConfig().getDouble("whisper_distance", maxDistance) : (maxDistance *= Core.api.getServerConfig().getDouble("whisper_distance_multiplier", 1.0));
            Core.platform.debugExtremelyVerbose("adjusted max distance is " + maxDistance);
        }
        double distance = position != null ? DiscordBot.distance(position, this.player.getPosition()) : 0.0;
        Core.platform.debugExtremelyVerbose("adding audio for " + String.valueOf(senderId));
        this._addAudioToHearingBuffer(this.ptr, senderId.hashCode(), packet.getOpusEncodedData(), position != null, distance, maxDistance);
    }

    private static double distance(Position pos1, Position pos2) {
        double dx = pos1.getX() - pos2.getX();
        double dy = pos1.getY() - pos2.getY();
        double dz = pos1.getZ() - pos2.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private native byte[] _blockForSpeakingBufferOpusData(long var1);

    private native void _resetSenders(long var1);
}

