/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

public class Version {
    private final long[] components = new long[3];

    public Version(long a, long b, long c) {
        this.components[0] = a;
        this.components[1] = b;
        this.components[2] = c;
    }

    public static Version parseChecked(String input) throws NumberFormatException {
        return Version.parseUnchecked(input);
    }

    public static Version parseUnchecked(String input) {
        Version version = new Version(0L, 0L, 0L);
        char[] chars = input.toCharArray();
        int charIndex = 0;
        for (int component = 0; charIndex < chars.length && component < version.components.length; ++component, ++charIndex) {
            StringBuilder rawComponent = new StringBuilder();
            while (charIndex < chars.length && Character.isDigit(chars[charIndex])) {
                rawComponent.append(chars[charIndex]);
                ++charIndex;
            }
            if (!rawComponent.isEmpty()) {
                version.components[component] = Long.parseLong(rawComponent.toString());
            }
            if (charIndex >= chars.length || chars[charIndex] != '.') break;
        }
        return version;
    }

    public String toString() {
        return this.components[0] + "." + this.components[1] + "." + this.components[2];
    }

    public boolean isLowerThan(Version other) {
        if (this.components[0] != other.components[0]) {
            return this.components[0] < other.components[0];
        }
        if (this.components[1] != other.components[1]) {
            return this.components[1] < other.components[1];
        }
        return this.components[2] < other.components[2];
    }

    public boolean isHigherThanOrEquivalentTo(Version other) {
        if (this.components[0] != other.components[0]) {
            return this.components[0] > other.components[0];
        }
        if (this.components[1] != other.components[1]) {
            return this.components[1] > other.components[1];
        }
        return this.components[2] >= other.components[2];
    }
}

