/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.ServerPlayer;
import dev.amsam0.voicechatdiscord.Component;
import dev.amsam0.voicechatdiscord.Core;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public interface Platform {
    @Nullable
    public Position getEntityPosition(ServerLevel var1, UUID var2);

    public boolean isValidPlayer(CommandContext<?> var1);

    public ServerPlayer commandContextToPlayer(CommandContext<?> var1);

    public boolean isOperator(CommandContext<?> var1);

    public boolean hasPermission(CommandContext<?> var1, String var2);

    public void sendMessage(CommandContext<?> var1, Component ... var2);

    public void sendMessage(Player var1, Component ... var2);

    public String getName(Player var1);

    public void setOnPlayerLeaveHandler(Consumer<UUID> var1);

    @Nullable
    public String getSimpleVoiceChatVersion();

    public String getConfigPath();

    public Loader getLoader();

    public void info(String var1);

    public void warn(String var1);

    public void error(String var1);

    public void error(String var1, Throwable var2);

    default public void debug(String message) {
        if (Core.debugLevel >= 1) {
            this.info("[DEBUG 1] " + message);
        }
    }

    default public void debugVerbose(String message) {
        if (Core.debugLevel >= 2) {
            this.info("[DEBUG 2] " + message);
        }
    }

    default public void debugExtremelyVerbose(String message) {
        if (Core.debugLevel >= 3) {
            this.info("[DEBUG 3] " + message);
        }
    }

    default public void debug(String message, Throwable throwable) {
        if (Core.debugLevel >= 1) {
            this.error("[DEBUG 1] " + message, throwable);
        }
    }

    public static enum Loader {
        PAPER("paper"),
        FABRIC("fabric");

        public final String modrinthName;

        private Loader(String modrinthName) {
            this.modrinthName = modrinthName;
        }
    }
}

