/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.events.CreateGroupEvent;
import de.maxhenkel.voicechat.api.events.JoinGroupEvent;
import de.maxhenkel.voicechat.api.events.LeaveGroupEvent;
import de.maxhenkel.voicechat.api.events.RemoveGroupEvent;
import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.util.BiMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public final class GroupManager {
    public static final BiMap<UUID, Integer> groupFriendlyIds = new BiMap();
    public static final Map<UUID, List<ServerPlayer>> groupPlayers = new HashMap<UUID, List<ServerPlayer>>();

    @Nullable
    public static String getPassword(Group group) {
        try {
            Field groupField = group.getClass().getDeclaredField("group");
            groupField.setAccessible(true);
            Object groupObject = groupField.get(group);
            Field passwordField = groupObject.getClass().getDeclaredField("password");
            passwordField.setAccessible(true);
            return (String)passwordField.get(groupObject);
        }
        catch (Throwable e) {
            Core.platform.error("Could not get password of group \"" + group.getName() + "\" (" + String.valueOf(group.getId()) + "): ", e);
            return null;
        }
    }

    private static List<ServerPlayer> getPlayers(Group group) {
        List<ServerPlayer> players = groupPlayers.putIfAbsent(group.getId(), new ArrayList());
        if (players == null) {
            players = groupPlayers.get(group.getId());
        }
        return players;
    }

    public static void onJoinGroup(JoinGroupEvent event) {
        Group group = event.getGroup();
        ServerPlayer player = event.getConnection().getPlayer();
        List<ServerPlayer> players = GroupManager.getPlayers(group);
        if (players.stream().noneMatch(serverPlayer -> serverPlayer.getUuid() == player.getUuid())) {
            Core.platform.debug(String.valueOf(player.getUuid()) + " (" + Core.platform.getName((Player)player) + ") joined " + String.valueOf(group.getId()) + " (" + group.getName() + ")");
            players.add(player);
        } else {
            Core.platform.debug(String.valueOf(player.getUuid()) + " (" + Core.platform.getName((Player)player) + ") already joined " + String.valueOf(group.getId()) + " (" + group.getName() + ")");
        }
    }

    public static void onLeaveGroup(LeaveGroupEvent event) {
        Group group = event.getGroup();
        ServerPlayer player = event.getConnection().getPlayer();
        if (group == null) {
            for (Map.Entry<UUID, List<ServerPlayer>> groupEntry : groupPlayers.entrySet()) {
                List<ServerPlayer> playerList = groupEntry.getValue();
                if (!playerList.stream().anyMatch(serverPlayer -> serverPlayer.getUuid() == player.getUuid())) continue;
                UUID playerGroup = groupEntry.getKey();
                Core.platform.debug(String.valueOf(player.getUuid()) + " (" + Core.platform.getName((Player)player) + ") left " + String.valueOf(playerGroup) + " (" + Core.api.getGroup(playerGroup).getName() + ")");
                playerList.remove(player);
                return;
            }
            Core.platform.debug(String.valueOf(player.getUuid()) + " (" + Core.platform.getName((Player)player) + ") left a group but we couldn't find the group they left");
            return;
        }
        Core.platform.debug(String.valueOf(player.getUuid()) + " (" + Core.platform.getName((Player)player) + ") left " + String.valueOf(group.getId()) + " (" + group.getName() + ")");
        List<ServerPlayer> players = GroupManager.getPlayers(group);
        players.remove(player);
    }

    public static void onGroupCreated(CreateGroupEvent event) {
        VoicechatConnection connection;
        Group group = event.getGroup();
        UUID groupId = group.getId();
        if (groupFriendlyIds.get(groupId) == null) {
            int friendlyId = 1;
            Collection friendlyIds = groupFriendlyIds.values();
            while (friendlyIds.contains(friendlyId)) {
                ++friendlyId;
            }
            groupFriendlyIds.put(groupId, friendlyId);
        }
        if ((connection = event.getConnection()) == null) {
            Core.platform.debug("someone created " + String.valueOf(groupId) + " (" + group.getName() + ")");
            return;
        }
        ServerPlayer player = connection.getPlayer();
        Core.platform.debug(String.valueOf(player.getUuid()) + " (" + Core.platform.getName((Player)player) + ") created " + String.valueOf(groupId) + " (" + group.getName() + ")");
        List<ServerPlayer> players = GroupManager.getPlayers(group);
        players.add(player);
    }

    public static void onGroupRemoved(RemoveGroupEvent event) {
        Group group = event.getGroup();
        UUID groupId = group.getId();
        Core.platform.debug(String.valueOf(groupId) + " (" + String.valueOf(groupFriendlyIds.get(groupId)) + ", " + group.getName() + ") was removed");
        groupPlayers.remove(groupId);
        groupFriendlyIds.remove(groupId);
    }
}

