/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.ServerPlayer;
import dev.amsam0.voicechatdiscord.Component;
import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.FabricVersionSpecific;
import dev.amsam0.voicechatdiscord.Platform;
import java.util.UUID;
import java.util.function.Consumer;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricPlatform
implements Platform {
    private static final Logger LOGGER = LoggerFactory.getLogger("voicechat-discord");
    protected static final String logPrefixAndFormatPlaceholder = "[voicechat-discord] {}";

    @Override
    public boolean isValidPlayer(CommandContext<?> sender) {
        return FabricVersionSpecific.getPlayerFromCommandSource((class_2168)sender.getSource()) != null;
    }

    @Override
    public ServerPlayer commandContextToPlayer(CommandContext<?> context) {
        return Core.api.fromServerPlayer((Object)FabricVersionSpecific.getPlayerFromCommandSource((class_2168)context.getSource()));
    }

    @Override
    @Nullable
    public Position getEntityPosition(ServerLevel level, UUID uuid) {
        class_3218 world = (class_3218)level.getServerLevel();
        class_1297 entity = world.method_14190(uuid);
        if (entity == null) {
            return null;
        }
        return Core.api.createPosition(entity.method_23317(), entity.method_23318(), entity.method_23321());
    }

    @Override
    public boolean isOperator(CommandContext<?> sender) {
        return ((class_2168)sender.getSource()).method_9259(2);
    }

    @Override
    public boolean hasPermission(CommandContext<?> sender, String permission) {
        return Permissions.check((class_2172)((class_2168)sender.getSource()), (String)permission);
    }

    @Override
    public void sendMessage(CommandContext<?> sender, Component ... message) {
        FabricVersionSpecific.sendMessage((class_2168)sender.getSource(), this.toNative(message));
    }

    @Override
    public void sendMessage(Player player, Component ... message) {
        FabricVersionSpecific.sendMessage((class_3222)player.getPlayer(), this.toNative(message));
    }

    private class_2561 toNative(Component ... message) {
        class_5250 nativeText = null;
        for (Component component : message) {
            class_5250 class_52502 = (class_5250)class_2561.method_30163((String)component.text());
            class_5250 mapped = class_52502.method_27692(switch (component.color()) {
                default -> throw new MatchException(null, null);
                case Component.Color.WHITE -> class_124.field_1068;
                case Component.Color.RED -> class_124.field_1061;
                case Component.Color.YELLOW -> class_124.field_1054;
                case Component.Color.GREEN -> class_124.field_1060;
            });
            nativeText = nativeText == null ? mapped : nativeText.method_10852((class_2561)mapped);
        }
        if (nativeText == null) {
            return class_2561.method_30163((String)null);
        }
        return nativeText;
    }

    @Override
    public String getName(Player player) {
        return ((class_1657)player.getPlayer()).method_5477().getString();
    }

    @Override
    public void setOnPlayerLeaveHandler(Consumer<UUID> handler) {
        ServerPlayConnectionEvents.DISCONNECT.register((minecraftHandler, server) -> handler.accept(minecraftHandler.field_14140.method_5667()));
    }

    @Override
    @Nullable
    public String getSimpleVoiceChatVersion() {
        ModContainer svcMod = FabricLoader.getInstance().getModContainer("voicechat").orElse(null);
        if (svcMod == null) {
            this.error("Simple Voice Chat mod is null");
            return null;
        }
        return svcMod.getMetadata().getVersion().toString();
    }

    @Override
    public String getConfigPath() {
        return "config/voicechat-discord.yml";
    }

    @Override
    public Platform.Loader getLoader() {
        return Platform.Loader.FABRIC;
    }

    @Override
    public void info(String message) {
        LOGGER.info(logPrefixAndFormatPlaceholder, (Object)message);
    }

    @Override
    public void warn(String message) {
        LOGGER.warn(logPrefixAndFormatPlaceholder, (Object)message);
    }

    @Override
    public void error(String message) {
        LOGGER.error(logPrefixAndFormatPlaceholder, (Object)message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        LOGGER.error(logPrefixAndFormatPlaceholder, (Object)message, (Object)throwable);
    }
}

