/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file;

import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.configuration.Configuration;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.configuration.InvalidConfigurationException;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.configuration.MemoryConfiguration;
import dev.amsam0.voicechatdiscord.shadow.yamlconfiguration.file.FileConfigurationOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileConfiguration
extends MemoryConfiguration {
    protected FileConfiguration() {
    }

    protected FileConfiguration(@Nullable Configuration defs) {
        super(defs);
    }

    public final void save(@NotNull File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("File has not been created at " + file.getPath());
        }
        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
        writer.write(this.saveToString());
        ((Writer)writer).close();
    }

    public final void save(@NotNull String path) throws IOException {
        this.save(new File(path));
    }

    @NotNull
    public abstract String saveToString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull Reader reader) throws IOException, InvalidConfigurationException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line).append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public final void load(@NotNull File file) throws IOException, InvalidConfigurationException {
        this.load(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
    }

    public final void load(@NotNull String path) throws IOException, InvalidConfigurationException {
        this.load(new File(path));
    }

    public abstract void loadFromString(@NotNull String var1) throws InvalidConfigurationException;

    @Override
    @NotNull
    public FileConfigurationOptions getOptions() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }
}

