/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.PaperPlugin;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class EntityTracker {
    private static final ConcurrentHashMap<UUID, Location> trackedEntityLocations = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> lastNeededTrackedEntityMillis = new ConcurrentHashMap();
    private static final long cleanupThresholdMillis = 60000L;
    private static Thread cleanupThread = null;
    private static boolean cleanupThreadRunning = false;

    private static void startCleanupThread() {
        if (cleanupThread != null) {
            return;
        }
        cleanupThreadRunning = true;
        cleanupThread = new Thread(() -> {
            Core.platform.debug("EntityTracker cleanup thread starting");
            while (cleanupThreadRunning) {
                Core.platform.debug("Checking for entities to remove - currently tracking " + trackedEntityLocations.size());
                for (Map.Entry<UUID, Location> entry : trackedEntityLocations.entrySet()) {
                    Long lastNeededMillis = lastNeededTrackedEntityMillis.get(entry.getKey());
                    if (lastNeededMillis != null && System.currentTimeMillis() - lastNeededMillis <= 60000L) continue;
                    Core.platform.debug("Removing entity " + String.valueOf(entry.getKey()));
                    trackedEntityLocations.remove(entry.getKey());
                    lastNeededTrackedEntityMillis.remove(entry.getKey());
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            Core.platform.debug("EntityTracker cleanup thread ending");
        }, "voicechat-discord: Tracked Entities Cleanup");
        cleanupThread.start();
    }

    public static void stopCleanupThread() {
        if (cleanupThread == null || !cleanupThreadRunning) {
            return;
        }
        try {
            cleanupThreadRunning = false;
            cleanupThread.interrupt();
            for (int i = 0; i < 20 && cleanupThread != null && cleanupThread.isAlive(); ++i) {
                try {
                    Core.platform.debug("waiting for cleanup thread to end");
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            Core.platform.error("Failed to stop EntityTracker cleanup thread", e);
        }
        cleanupThread = null;
    }

    @Nullable
    public static Location getEntityLocation(UUID uuid) {
        lastNeededTrackedEntityMillis.put(uuid, System.currentTimeMillis());
        return trackedEntityLocations.get(uuid);
    }

    public static void requestTracking(UUID uuid) {
        Core.platform.debug("Tracking " + String.valueOf(uuid));
        Bukkit.getGlobalRegionScheduler().execute((Plugin)PaperPlugin.get(), () -> {
            Entity entity = Bukkit.getServer().getEntity(uuid);
            if (entity == null) {
                return;
            }
            entity.getScheduler().execute((Plugin)PaperPlugin.get(), () -> {
                if (!trackedEntityLocations.containsKey(uuid)) {
                    trackedEntityLocations.put(uuid, entity.getLocation());
                    Core.platform.debug("Got initial location for " + String.valueOf(uuid));
                } else {
                    Core.platform.debug("Already had location for " + String.valueOf(uuid));
                }
            }, null, 0L);
        });
        EntityTracker.startCleanupThread();
    }

    public static void updateEntityLocation(UUID uuid, Location location) {
        if (trackedEntityLocations.containsKey(uuid)) {
            trackedEntityLocations.put(uuid, location);
            Core.platform.debugVerbose("Updating location of entity " + String.valueOf(uuid));
        }
    }
}

