/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.ServerPlayer;
import dev.amsam0.voicechatdiscord.Component;
import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.EntityTracker;
import dev.amsam0.voicechatdiscord.EventListener;
import dev.amsam0.voicechatdiscord.PaperPlugin;
import dev.amsam0.voicechatdiscord.Platform;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PaperPlatform
implements Platform {
    @Override
    public boolean isValidPlayer(CommandContext<?> sender) {
        return PaperPlugin.commandHelper.bukkitEntity(sender) instanceof Player;
    }

    @Override
    public ServerPlayer commandContextToPlayer(CommandContext<?> context) {
        return Core.api.fromServerPlayer((Object)PaperPlugin.commandHelper.bukkitEntity(context));
    }

    @Override
    @Nullable
    public Position getEntityPosition(ServerLevel level, UUID uuid) {
        Player player = Bukkit.getServer().getPlayer(uuid);
        if (player != null) {
            return Core.api.createPosition(player.getX(), player.getY(), player.getZ());
        }
        Location entityLocation = EntityTracker.getEntityLocation(uuid);
        if (entityLocation != null) {
            return Core.api.createPosition(entityLocation.getX(), entityLocation.getY(), entityLocation.getZ());
        }
        EntityTracker.requestTracking(uuid);
        return null;
    }

    @Override
    public boolean isOperator(CommandContext<?> sender) {
        return PaperPlugin.commandHelper.bukkitSender(sender).isOp();
    }

    @Override
    public boolean hasPermission(CommandContext<?> sender, String permission) {
        return PaperPlugin.commandHelper.bukkitSender(sender).hasPermission(permission);
    }

    @Override
    public void sendMessage(CommandContext<?> sender, Component ... message) {
        Entity entity = PaperPlugin.commandHelper.bukkitEntity(sender);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.sendMessage(this.toNative(message));
        } else {
            PaperPlugin.commandHelper.bukkitSender(sender).sendMessage(this.toNative(message));
        }
    }

    @Override
    public void sendMessage(de.maxhenkel.voicechat.api.Player player, Component ... message) {
        ((Player)player.getPlayer()).sendMessage(this.toNative(message));
    }

    public void sendMessage(CommandSender sender, Component ... message) {
        sender.sendMessage(this.toNative(message));
    }

    private net.kyori.adventure.text.Component toNative(Component ... message) {
        Object nativeComponent = null;
        for (Component component : message) {
            String string = component.text();
            TextComponent mapped = net.kyori.adventure.text.Component.text((String)string, (TextColor)(switch (component.color()) {
                default -> throw new MatchException(null, null);
                case Component.Color.WHITE -> NamedTextColor.WHITE;
                case Component.Color.RED -> NamedTextColor.RED;
                case Component.Color.YELLOW -> NamedTextColor.YELLOW;
                case Component.Color.GREEN -> NamedTextColor.GREEN;
            }));
            nativeComponent = nativeComponent == null ? mapped : nativeComponent.append((net.kyori.adventure.text.Component)mapped);
        }
        if (nativeComponent == null) {
            return net.kyori.adventure.text.Component.empty();
        }
        return nativeComponent;
    }

    @Override
    public String getName(de.maxhenkel.voicechat.api.Player player) {
        return ((Player)player.getPlayer()).getName();
    }

    @Override
    public void setOnPlayerLeaveHandler(Consumer<UUID> handler) {
        EventListener.onPlayerLeaveHandler = handler;
    }

    @Override
    @Nullable
    public String getSimpleVoiceChatVersion() {
        Plugin svcPlugin = Bukkit.getServer().getPluginManager().getPlugin("voicechat");
        if (svcPlugin == null) {
            this.error("Simple Voice Chat plugin is null");
            return null;
        }
        return svcPlugin.getDescription().getVersion();
    }

    @Override
    public String getConfigPath() {
        return "plugins/voicechat-discord/config.yml";
    }

    @Override
    public Platform.Loader getLoader() {
        return Platform.Loader.PAPER;
    }

    @Override
    public void info(String message) {
        PaperPlugin.LOGGER.info(message);
    }

    @Override
    public void warn(String message) {
        PaperPlugin.LOGGER.warn(message);
    }

    @Override
    public void error(String message) {
        PaperPlugin.LOGGER.error(message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        PaperPlugin.LOGGER.error(message, throwable);
    }
}

