/*
 * Decompiled with CFR 0.152.
 */
package dev.amsam0.voicechatdiscord;

import de.maxhenkel.voicechat.api.BukkitVoicechatService;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import dev.amsam0.voicechatdiscord.CommandHelper;
import dev.amsam0.voicechatdiscord.Core;
import dev.amsam0.voicechatdiscord.EntityTracker;
import dev.amsam0.voicechatdiscord.EventListener;
import dev.amsam0.voicechatdiscord.PaperPlatform;
import dev.amsam0.voicechatdiscord.PaperVoicechatPlugin;
import dev.amsam0.voicechatdiscord.Version;
import dev.amsam0.voicechatdiscord.post_1_20_6.Post_1_20_6_CommandHelper;
import dev.amsam0.voicechatdiscord.pre_1_20_6.Pre_1_20_6_CommandHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PaperPlugin
extends JavaPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"voicechat-discord");
    public static PaperPlugin INSTANCE;
    public static CommandHelper commandHelper;
    private final EventListener eventListener = new EventListener();
    private PaperVoicechatPlugin voicechatPlugin;

    public static PaperPlugin get() {
        return INSTANCE;
    }

    public void onEnable() {
        INSTANCE = this;
        if (Core.platform == null) {
            Core.platform = new PaperPlatform();
        }
        String originalVersion = this.getServer().getMinecraftVersion();
        Core.platform.info("Original Minecraft version: " + originalVersion);
        try {
            Version parsedVersion = Version.parseChecked(originalVersion);
            Core.platform.info("Parsed Minecraft version: " + String.valueOf(parsedVersion));
            Version wantedCommandHelper = new Version(1L, 20L, 6L);
            if (parsedVersion.isHigherThanOrEquivalentTo(wantedCommandHelper)) {
                Core.platform.info("Server is >=1.20.6");
                commandHelper = new Post_1_20_6_CommandHelper();
            } else {
                Core.platform.info("Server is <1.20.6");
                commandHelper = new Pre_1_20_6_CommandHelper();
            }
        }
        catch (NumberFormatException e) {
            Core.platform.error("Unable to parse server version", e);
            if (originalVersion.equals("1.8") || originalVersion.startsWith("1.8.") || originalVersion.equals("1.9") || originalVersion.startsWith("1.9.") || originalVersion.equals("1.10") || originalVersion.startsWith("1.10.") || originalVersion.equals("1.11") || originalVersion.startsWith("1.11.") || originalVersion.equals("1.12") || originalVersion.startsWith("1.12.") || originalVersion.equals("1.13") || originalVersion.startsWith("1.13.") || originalVersion.equals("1.14") || originalVersion.startsWith("1.14.") || originalVersion.equals("1.15") || originalVersion.startsWith("1.15.") || originalVersion.equals("1.16") || originalVersion.startsWith("1.16.") || originalVersion.equals("1.17") || originalVersion.startsWith("1.17.") || originalVersion.equals("1.18") || originalVersion.startsWith("1.18.") || originalVersion.equals("1.19") || originalVersion.startsWith("1.19.") || originalVersion.equals("1.20") || originalVersion.equals("1.20.0") || originalVersion.equals("1.20.1") || originalVersion.equals("1.20.2") || originalVersion.equals("1.20.3") || originalVersion.equals("1.20.4") || originalVersion.equals("1.20.5")) {
                Core.platform.info("Server is most likely <1.20.6");
                commandHelper = new Pre_1_20_6_CommandHelper();
            }
            Core.platform.info("Server is most likely >=1.20.6");
            commandHelper = new Post_1_20_6_CommandHelper();
        }
        BukkitVoicechatService service = (BukkitVoicechatService)this.getServer().getServicesManager().load(BukkitVoicechatService.class);
        if (service == null) {
            Core.platform.error("Failed to register voicechat discord plugin");
            throw new RuntimeException("Failed to register voicechat discord plugin");
        }
        this.voicechatPlugin = new PaperVoicechatPlugin();
        service.registerPlugin((VoicechatPlugin)this.voicechatPlugin);
        Core.platform.info("Successfully registered voicechat discord plugin");
        Core.enable();
        Bukkit.getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)this);
        commandHelper.registerCommands();
    }

    public void onDisable() {
        Core.disable();
        if (this.voicechatPlugin != null) {
            this.getServer().getServicesManager().unregister((Object)this.voicechatPlugin);
            Core.platform.info("Successfully unregistered voicechat discord plugin");
        }
        EntityTracker.stopCleanupThread();
    }
}

