/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.structurevoidtoggle.behaviors;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.structurevoidtoggle.behaviors.ShapeInterface;
import com.telepathicgrunt.structurevoidtoggle.behaviors.StructureVoidBlockShape;
import java.util.HashMap;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10799;
import net.minecraft.class_11282;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_746;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class ToggleBehavior {
    public static STRUCTURE_BLOCK_MODE MODE = STRUCTURE_BLOCK_MODE.DEFAULT;
    public static boolean VISIBLE = true;
    public static boolean FORCED_RENDERING = false;
    public static class_304.class_11900 STRUCTURE_VOID_TOGGLE_KEY_CATEGORY = null;
    public static final class_304 KEY_BIND_STRUCTURE_VOID_TOGGLE = new class_304("key.structure_void", 96, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final class_304 KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE = new class_304("key.structure_void_render", 260, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final class_304 KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE = new class_304("key.forced_render", 261, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final class_304 KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE = new class_304("key.non_replacing", 266, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);

    public static void registerKeyMappingCategory() {
        STRUCTURE_VOID_TOGGLE_KEY_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"structure_void_toggle", (String)"key.categories.structure_void_toggle"));
    }

    public static void toggle(int key) {
        if (KEY_BIND_STRUCTURE_VOID_TOGGLE.method_1434()) {
            ToggleBehavior.toggleHitbox();
        }
        if (KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE.method_1434()) {
            ToggleBehavior.toggleRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE.method_1434()) {
            ToggleBehavior.toggleForcedRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE.method_1434()) {
            ToggleBehavior.toggleNonReplaceable();
        }
    }

    private static void toggleHitbox() {
        MODE = MODE.next();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        switch (MODE.ordinal()) {
            case 0: {
                player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.default_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
                ((ShapeInterface)class_2246.field_10499).setShape(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)class_2246.field_31037).setShape(class_2248.method_9541((double)-2.0, (double)-2.0, (double)-2.0, (double)-1.0, (double)-1.0, (double)-1.0));
                break;
            }
            case 1: {
                player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.no_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                ((ShapeInterface)class_2246.field_10499).setShape(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                ((ShapeInterface)class_2246.field_31037).setShape(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                break;
            }
            case 2: {
                player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.small_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
                ((ShapeInterface)class_2246.field_10499).setShape(class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                ((ShapeInterface)class_2246.field_31037).setShape(class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                break;
            }
            case 3: {
                player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.full_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                ((ShapeInterface)class_2246.field_10499).setShape(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)class_2246.field_31037).setShape(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                break;
            }
        }
    }

    private static void toggleRender() {
        VISIBLE = !VISIBLE;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (VISIBLE) {
            player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.structure_block_visible"), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.structure_block_invisible"), true);
        }
    }

    private static void toggleForcedRender() {
        FORCED_RENDERING = !FORCED_RENDERING;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (FORCED_RENDERING) {
            player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.invisible_blocks_forced_render"), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.invisible_blocks_disabled_forced_render"), true);
        }
    }

    private static void toggleNonReplaceable() {
        StructureVoidBlockShape.FORCED_NON_REPLACEABLE = !StructureVoidBlockShape.FORCED_NON_REPLACEABLE;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (StructureVoidBlockShape.FORCED_NON_REPLACEABLE) {
            player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.invisible_blocks_non_replaceable"), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"system.structure_void_toggle.invisible_blocks_replaceable"), true);
        }
    }

    public static void forceRenderInvisibleBlocks(class_1937 level, class_243 cameraPos, class_4604 frustum, class_4587 poseStack, boolean clearRenderState) {
        if (FORCED_RENDERING) {
            double drawRadius = MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX ? 0.4 : 0.05;
            double minCorner = 0.5 - drawRadius;
            double maxCorner = 0.5 + drawRadius;
            Vector4d vector4dMin = new Vector4d(minCorner, minCorner, minCorner, 1.0);
            Vector4d vector4dMax = new Vector4d(maxCorner, maxCorner, maxCorner, 1.0);
            int radius = 40;
            class_2338 centerPos = class_2338.method_49638((class_2374)cameraPos);
            HashMap<class_1923, Boolean> chunkAllowedMap = new HashMap<class_1923, Boolean>();
            class_2338.class_2339 worldSpot = new class_2338.class_2339();
            poseStack.method_22903();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX ? tesselator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576) : tesselator.method_60827(VertexFormat.class_5596.field_27377, class_290.field_29337);
            boolean addedVertex = false;
            int radiusSq = radius * radius;
            for (int x = -radius; x <= radius; ++x) {
                block11: for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        boolean flag4;
                        int distSq = x * x + y * y + z * z;
                        if (distSq > radiusSq) continue;
                        worldSpot.method_10103(centerPos.method_10263() + x, centerPos.method_10264() + y, centerPos.method_10260() + z);
                        class_1923 chunkPos = new class_1923((class_2338)worldSpot);
                        boolean isValidChunk = chunkAllowedMap.computeIfAbsent(chunkPos, c -> {
                            for (class_2826 levelChunkSection : level.method_8497(chunkPos.field_9181, chunkPos.field_9180).method_12006()) {
                                if (!levelChunkSection.method_12265().method_19526(b -> b.method_27852(class_2246.field_10369) || b.method_27852(class_2246.field_10499) || b.method_27852(class_2246.field_31037))) continue;
                                return true;
                            }
                            return false;
                        });
                        if (!isValidChunk) {
                            z = ((worldSpot.method_10260() >> 4) + 1 << 4) - 1 - centerPos.method_10260();
                            continue block11;
                        }
                        if (!frustum.method_23093(new class_238((double)worldSpot.method_10263() + minCorner, (double)worldSpot.method_10264() + minCorner, (double)worldSpot.method_10260() + minCorner, (double)worldSpot.method_10263() + maxCorner, (double)worldSpot.method_10264() + maxCorner, (double)worldSpot.method_10260() + maxCorner))) continue;
                        class_2680 blockstate = level.method_8320((class_2338)worldSpot);
                        boolean flag1 = blockstate.method_27852(class_2246.field_10369);
                        boolean flag2 = blockstate.method_27852(class_2246.field_10499);
                        boolean flag3 = blockstate.method_27852(class_2246.field_31037);
                        boolean bl = flag4 = flag1 || flag2 || flag3;
                        if (!flag4) continue;
                        int red = 255;
                        int green = 255;
                        int blue = 255;
                        int alpha = 255;
                        if (flag1) {
                            green = 190;
                            blue = 190;
                        } else if (flag2) {
                            green = 0;
                            blue = 0;
                        } else if (flag3) {
                            blue = 0;
                        }
                        if (MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX) {
                            float distanceMult = Math.max(1.0f - (float)distSq * 6.0f / (float)radiusSq, 0.5f);
                            ToggleBehavior.renderQuadBox(bufferbuilder, poseStack.method_23760().method_23761(), (float)(vector4dMin.x() + (double)worldSpot.method_10263() - cameraPos.method_10216()), (float)(vector4dMin.y() + (double)worldSpot.method_10264() - cameraPos.method_10214()), (float)(vector4dMin.z() + (double)worldSpot.method_10260() - cameraPos.method_10215()), (float)(vector4dMax.x() + (double)worldSpot.method_10263() - cameraPos.method_10216()), (float)(vector4dMax.y() + (double)worldSpot.method_10264() - cameraPos.method_10214()), (float)(vector4dMax.z() + (double)worldSpot.method_10260() - cameraPos.method_10215()), (int)((float)red * distanceMult), (int)((float)green * distanceMult), (int)((float)blue * distanceMult), alpha);
                        } else {
                            ToggleBehavior.renderLineBox(bufferbuilder, poseStack.method_23760().method_23761(), (float)(vector4dMin.x() + (double)worldSpot.method_10263() - cameraPos.method_10216()), (float)(vector4dMin.y() + (double)worldSpot.method_10264() - cameraPos.method_10214()), (float)(vector4dMin.z() + (double)worldSpot.method_10260() - cameraPos.method_10215()), (float)(vector4dMax.x() + (double)worldSpot.method_10263() - cameraPos.method_10216()), (float)(vector4dMax.y() + (double)worldSpot.method_10264() - cameraPos.method_10214()), (float)(vector4dMax.z() + (double)worldSpot.method_10260() - cameraPos.method_10215()), red, green, blue, alpha);
                        }
                        addedVertex = true;
                    }
                }
            }
            if (addedVertex) {
                try (class_9801 meshData = bufferbuilder.method_60800();){
                    GpuBufferSlice[] gpubufferslice;
                    RenderPipeline pipeline;
                    RenderSystem.class_5590 storageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
                    if (MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX) {
                        pipeline = class_10799.field_56865;
                        gpubufferslice = new GpuBufferSlice[]{RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f)};
                    } else {
                        pipeline = class_10799.field_56833;
                        RenderSystem.lineWidth((float)1.5f);
                        gpubufferslice = RenderSystem.getDynamicUniforms().method_71107(new class_11282.class_11283[]{new class_11282.class_11283((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 2.0f)});
                    }
                    GpuBuffer gpuBuffer = pipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
                    GpuBuffer gpuBuffer2 = meshData.method_60821() == null ? storageIndexBuffer.method_68274(meshData.method_60822().comp_751()) : pipeline.getVertexFormat().uploadImmediateIndexBuffer(meshData.method_60821());
                    try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Structure Void Toggle Render Cubes", class_310.method_1551().method_1522().method_71639(), OptionalInt.empty(), class_310.method_1551().method_1522().method_71640(), OptionalDouble.empty());){
                        GpuBuffer gpubuffer3;
                        renderPass.setPipeline(pipeline);
                        RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                        GpuBufferSlice gpubufferslice2 = RenderSystem.getProjectionMatrixBuffer();
                        if (gpubufferslice2 != null) {
                            renderPass.setUniform("Projection", gpubufferslice2);
                        }
                        if ((gpubuffer3 = RenderSystem.getGlobalSettingsUniform()) != null) {
                            renderPass.setUniform("Globals", gpubuffer3);
                        }
                        renderPass.setVertexBuffer(0, gpuBuffer);
                        renderPass.setIndexBuffer(gpuBuffer2, storageIndexBuffer.method_31924());
                        renderPass.setUniform("DynamicTransforms", gpubufferslice[0]);
                        renderPass.drawIndexed(0, 0, meshData.method_60822().comp_751(), 1);
                        RenderSystem.lineWidth((float)1.0f);
                    }
                }
            }
            poseStack.method_22909();
            if (clearRenderState) {
                class_1921.method_23581().method_23518();
            }
        }
    }

    private static void renderQuadBox(class_287 builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue, int alpha) {
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 1.0f, 0.0f);
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 1.0f);
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 1.0f);
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 1.0f);
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 1.0f);
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
    }

    private static void renderLineBox(class_287 builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue, int alpha) {
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(-1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(-1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, -1.0f, 0.0f);
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, -1.0f, 0.0f);
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, -1.0f);
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, -1.0f);
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(1.0f, 0.0f, 0.0f);
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 1.0f, 0.0f);
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, alpha).method_22914(0.0f, 0.0f, 1.0f);
    }

    public static enum STRUCTURE_BLOCK_MODE {
        DEFAULT,
        NO_HITBOX,
        SMALL_HITBOX,
        FULL_HITBOX;


        public STRUCTURE_BLOCK_MODE next() {
            if (this.ordinal() + 1 == STRUCTURE_BLOCK_MODE.values().length) {
                return STRUCTURE_BLOCK_MODE.values()[0];
            }
            return STRUCTURE_BLOCK_MODE.values()[this.ordinal() + 1];
        }
    }
}

