/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.structurevoidtoggle.behaviors;

import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.structurevoidtoggle.behaviors.ShapeInterface;
import com.telepathicgrunt.structurevoidtoggle.behaviors.StructureVoidBlockShape;
import java.util.HashMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.gizmos.GizmoStyle;
import net.minecraft.gizmos.Gizmos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4d;

public class ToggleBehavior {
    public static STRUCTURE_BLOCK_MODE MODE = STRUCTURE_BLOCK_MODE.DEFAULT;
    public static boolean VISIBLE = true;
    public static boolean FORCED_RENDERING = false;
    public static KeyMapping.Category STRUCTURE_VOID_TOGGLE_KEY_CATEGORY = null;
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_TOGGLE = new KeyMapping("key.structure_void", 96, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE = new KeyMapping("key.structure_void_render", 260, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE = new KeyMapping("key.forced_render", 261, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE = new KeyMapping("key.non_replacing", 266, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);

    public static void registerKeyMappingCategory() {
        STRUCTURE_VOID_TOGGLE_KEY_CATEGORY = KeyMapping.Category.register((Identifier)Identifier.fromNamespaceAndPath((String)"structure_void_toggle", (String)"key.categories.structure_void_toggle"));
    }

    public static void toggle(int key) {
        if (KEY_BIND_STRUCTURE_VOID_TOGGLE.isDown()) {
            ToggleBehavior.toggleHitbox();
        }
        if (KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE.isDown()) {
            ToggleBehavior.toggleRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE.isDown()) {
            ToggleBehavior.toggleForcedRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE.isDown()) {
            ToggleBehavior.toggleNonReplaceable();
        }
    }

    private static void toggleHitbox() {
        MODE = MODE.next();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        switch (MODE.ordinal()) {
            case 0: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.default_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)-2.0, (double)-2.0, (double)-2.0, (double)-1.0, (double)-1.0, (double)-1.0));
                break;
            }
            case 1: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.no_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                break;
            }
            case 2: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.small_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                break;
            }
            case 3: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.full_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                break;
            }
        }
    }

    private static void toggleRender() {
        VISIBLE = !VISIBLE;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (VISIBLE) {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.structure_block_visible"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.structure_block_invisible"), true);
        }
    }

    private static void toggleForcedRender() {
        FORCED_RENDERING = !FORCED_RENDERING;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (FORCED_RENDERING) {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_forced_render"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_disabled_forced_render"), true);
        }
    }

    private static void toggleNonReplaceable() {
        StructureVoidBlockShape.FORCED_NON_REPLACEABLE = !StructureVoidBlockShape.FORCED_NON_REPLACEABLE;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (StructureVoidBlockShape.FORCED_NON_REPLACEABLE) {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_non_replaceable"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_replaceable"), true);
        }
    }

    public static void forceRenderInvisibleBlocks(Level level, Vec3 cameraPos, Frustum frustum, PoseStack poseStack, boolean clearRenderState) {
        if (FORCED_RENDERING) {
            double drawRadius = MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX ? 0.4 : 0.05;
            double minCorner = 0.5 - drawRadius;
            double maxCorner = 0.5 + drawRadius;
            Vector4d vector4dMin = new Vector4d(minCorner, minCorner, minCorner, 1.0);
            Vector4d vector4dMax = new Vector4d(maxCorner, maxCorner, maxCorner, 1.0);
            int radius = 40;
            BlockPos centerPos = BlockPos.containing((Position)cameraPos);
            HashMap<ChunkPos, Boolean> chunkAllowedMap = new HashMap<ChunkPos, Boolean>();
            BlockPos.MutableBlockPos worldSpot = new BlockPos.MutableBlockPos();
            int radiusSq = radius * radius;
            for (int x = -radius; x <= radius; ++x) {
                block1: for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        float distanceMult;
                        boolean flag4;
                        int distSq = x * x + y * y + z * z;
                        if (distSq > radiusSq) continue;
                        worldSpot.set(centerPos.getX() + x, centerPos.getY() + y, centerPos.getZ() + z);
                        ChunkPos chunkPos = new ChunkPos((BlockPos)worldSpot);
                        boolean isValidChunk = chunkAllowedMap.computeIfAbsent(chunkPos, c -> {
                            for (LevelChunkSection levelChunkSection : level.getChunk(chunkPos.x, chunkPos.z).getSections()) {
                                if (!levelChunkSection.getStates().maybeHas(b -> b.is(Blocks.STRUCTURE_VOID) || b.is(Blocks.BARRIER) || b.is(Blocks.LIGHT))) continue;
                                return true;
                            }
                            return false;
                        });
                        if (!isValidChunk) {
                            z = ((worldSpot.getZ() >> 4) + 1 << 4) - 1 - centerPos.getZ();
                            continue block1;
                        }
                        if (!frustum.isVisible(new AABB((double)worldSpot.getX() + minCorner, (double)worldSpot.getY() + minCorner, (double)worldSpot.getZ() + minCorner, (double)worldSpot.getX() + maxCorner, (double)worldSpot.getY() + maxCorner, (double)worldSpot.getZ() + maxCorner))) continue;
                        BlockState blockstate = level.getBlockState((BlockPos)worldSpot);
                        boolean flag1 = blockstate.is(Blocks.STRUCTURE_VOID);
                        boolean flag2 = blockstate.is(Blocks.BARRIER);
                        boolean flag3 = blockstate.is(Blocks.LIGHT);
                        boolean bl = flag4 = flag1 || flag2 || flag3;
                        if (!flag4) continue;
                        int red = 255;
                        int green = 255;
                        int blue = 255;
                        int alpha = 255;
                        if (flag1) {
                            green = 190;
                            blue = 190;
                        } else if (flag2) {
                            green = 0;
                            blue = 0;
                        } else if (flag3) {
                            blue = 0;
                        }
                        if (MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX) {
                            distanceMult = Math.max(1.0f - (float)distSq * 6.0f / (float)radiusSq, 0.5f);
                            Gizmos.cuboid((AABB)new AABB(vector4dMin.x() + (double)worldSpot.getX(), vector4dMin.y() + (double)worldSpot.getY(), vector4dMin.z() + (double)worldSpot.getZ(), vector4dMax.x() + (double)worldSpot.getX(), vector4dMax.y() + (double)worldSpot.getY(), vector4dMax.z() + (double)worldSpot.getZ()), (GizmoStyle)GizmoStyle.fill((int)ARGB.color((int)alpha, (int)((int)((float)red * distanceMult)), (int)((int)((float)green * distanceMult)), (int)((int)((float)blue * distanceMult)))));
                            continue;
                        }
                        distanceMult = Math.clamp(1.0f - (float)(distSq * 40) / (float)radiusSq, 0.0f, 1.0f);
                        Gizmos.cuboid((AABB)new AABB(vector4dMin.x() + (double)worldSpot.getX(), vector4dMin.y() + (double)worldSpot.getY(), vector4dMin.z() + (double)worldSpot.getZ(), vector4dMax.x() + (double)worldSpot.getX(), vector4dMax.y() + (double)worldSpot.getY(), vector4dMax.z() + (double)worldSpot.getZ()), (GizmoStyle)GizmoStyle.stroke((int)ARGB.color((int)alpha, (int)red, (int)green, (int)blue), (float)(1.5f + 2.0f * distanceMult)));
                    }
                }
            }
        }
    }

    public static enum STRUCTURE_BLOCK_MODE {
        DEFAULT,
        NO_HITBOX,
        SMALL_HITBOX,
        FULL_HITBOX;


        public STRUCTURE_BLOCK_MODE next() {
            if (this.ordinal() + 1 == STRUCTURE_BLOCK_MODE.values().length) {
                return STRUCTURE_BLOCK_MODE.values()[0];
            }
            return STRUCTURE_BLOCK_MODE.values()[this.ordinal() + 1];
        }
    }
}

