/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.structurevoidtoggle.mixin;

import com.telepathicgrunt.structurevoidtoggle.behaviors.ShapeInterface;
import com.telepathicgrunt.structurevoidtoggle.behaviors.StructureVoidBlockShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LightBlock.class})
public class LightBlockMixin
extends Block
implements ShapeInterface {
    @Unique
    private static VoxelShape STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)-2.0, (double)-2.0, (double)-2.0, (double)-1.0, (double)-1.0, (double)-1.0);

    public LightBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (STRUCTURE_VOID_TOGGLE$SHAPE.isEmpty() || STRUCTURE_VOID_TOGGLE$SHAPE.max(Direction.Axis.X) >= 0.0) {
            return STRUCTURE_VOID_TOGGLE$SHAPE;
        }
        return collisionContext.isHoldingItem(Items.LIGHT) ? Shapes.block() : Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (STRUCTURE_VOID_TOGGLE$SHAPE.isEmpty() || STRUCTURE_VOID_TOGGLE$SHAPE.max(Direction.Axis.X) >= 0.0) {
            return Shapes.empty();
        }
        return super.getCollisionShape(blockState, blockGetter, blockPos, collisionContext);
    }

    public InteractionResult useItemOn(ItemStack heldItem, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!heldItem.is(Items.LIGHT)) {
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(heldItem, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext context) {
        if (StructureVoidBlockShape.FORCED_NON_REPLACEABLE) {
            return false;
        }
        return super.canBeReplaced(blockState, context);
    }

    @Override
    public void setShape(VoxelShape shape) {
        STRUCTURE_VOID_TOGGLE$SHAPE = shape;
    }

    @Override
    public VoxelShape getShape() {
        return STRUCTURE_VOID_TOGGLE$SHAPE;
    }
}

