/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.structurevoidtoggle.behaviors;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.structurevoidtoggle.behaviors.ShapeInterface;
import com.telepathicgrunt.structurevoidtoggle.behaviors.StructureVoidBlockShape;
import java.util.HashMap;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class ToggleBehavior {
    public static STRUCTURE_BLOCK_MODE MODE = STRUCTURE_BLOCK_MODE.DEFAULT;
    public static boolean VISIBLE = true;
    public static boolean FORCED_RENDERING = false;
    public static KeyMapping.Category STRUCTURE_VOID_TOGGLE_KEY_CATEGORY = null;
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_TOGGLE = new KeyMapping("key.structure_void", 96, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE = new KeyMapping("key.structure_void_render", 260, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE = new KeyMapping("key.forced_render", 261, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);
    public static final KeyMapping KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE = new KeyMapping("key.non_replacing", 266, STRUCTURE_VOID_TOGGLE_KEY_CATEGORY);

    public static void registerKeyMappingCategory() {
        STRUCTURE_VOID_TOGGLE_KEY_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"structure_void_toggle", (String)"key.categories.structure_void_toggle"));
    }

    public static void toggle(int key) {
        if (KEY_BIND_STRUCTURE_VOID_TOGGLE.isDown()) {
            ToggleBehavior.toggleHitbox();
        }
        if (KEY_BIND_STRUCTURE_VOID_RENDER_TOGGLE.isDown()) {
            ToggleBehavior.toggleRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_FORCED_RENDER_TOGGLE.isDown()) {
            ToggleBehavior.toggleForcedRender();
        }
        if (KEY_BIND_STRUCTURE_VOID_NON_REPLACING_TOGGLE.isDown()) {
            ToggleBehavior.toggleNonReplaceable();
        }
    }

    private static void toggleHitbox() {
        MODE = MODE.next();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        switch (MODE.ordinal()) {
            case 0: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.default_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)-2.0, (double)-2.0, (double)-2.0, (double)-1.0, (double)-1.0, (double)-1.0));
                break;
            }
            case 1: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.no_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
                break;
            }
            case 2: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.small_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
                break;
            }
            case 3: {
                player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.full_hitbox"), true);
                StructureVoidBlockShape.STRUCTURE_VOID_TOGGLE$SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                ((ShapeInterface)Blocks.BARRIER).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                ((ShapeInterface)Blocks.LIGHT).setShape(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                break;
            }
        }
    }

    private static void toggleRender() {
        VISIBLE = !VISIBLE;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (VISIBLE) {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.structure_block_visible"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.structure_block_invisible"), true);
        }
    }

    private static void toggleForcedRender() {
        FORCED_RENDERING = !FORCED_RENDERING;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (FORCED_RENDERING) {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_forced_render"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_disabled_forced_render"), true);
        }
    }

    private static void toggleNonReplaceable() {
        StructureVoidBlockShape.FORCED_NON_REPLACEABLE = !StructureVoidBlockShape.FORCED_NON_REPLACEABLE;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (StructureVoidBlockShape.FORCED_NON_REPLACEABLE) {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_non_replaceable"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"system.structure_void_toggle.invisible_blocks_replaceable"), true);
        }
    }

    public static void forceRenderInvisibleBlocks(Level level, Vec3 cameraPos, Frustum frustum, PoseStack poseStack, boolean clearRenderState) {
        if (FORCED_RENDERING) {
            double drawRadius = MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX ? 0.4 : 0.05;
            double minCorner = 0.5 - drawRadius;
            double maxCorner = 0.5 + drawRadius;
            Vector4d vector4dMin = new Vector4d(minCorner, minCorner, minCorner, 1.0);
            Vector4d vector4dMax = new Vector4d(maxCorner, maxCorner, maxCorner, 1.0);
            int radius = 40;
            BlockPos centerPos = BlockPos.containing((Position)cameraPos);
            HashMap<ChunkPos, Boolean> chunkAllowedMap = new HashMap<ChunkPos, Boolean>();
            BlockPos.MutableBlockPos worldSpot = new BlockPos.MutableBlockPos();
            poseStack.pushPose();
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX ? tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR) : tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
            boolean addedVertex = false;
            int radiusSq = radius * radius;
            for (int x = -radius; x <= radius; ++x) {
                block11: for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        boolean flag4;
                        int distSq = x * x + y * y + z * z;
                        if (distSq > radiusSq) continue;
                        worldSpot.set(centerPos.getX() + x, centerPos.getY() + y, centerPos.getZ() + z);
                        ChunkPos chunkPos = new ChunkPos((BlockPos)worldSpot);
                        boolean isValidChunk = chunkAllowedMap.computeIfAbsent(chunkPos, c -> {
                            for (LevelChunkSection levelChunkSection : level.getChunk(chunkPos.x, chunkPos.z).getSections()) {
                                if (!levelChunkSection.getStates().maybeHas(b -> b.is(Blocks.STRUCTURE_VOID) || b.is(Blocks.BARRIER) || b.is(Blocks.LIGHT))) continue;
                                return true;
                            }
                            return false;
                        });
                        if (!isValidChunk) {
                            z = ((worldSpot.getZ() >> 4) + 1 << 4) - 1 - centerPos.getZ();
                            continue block11;
                        }
                        if (!frustum.isVisible(new AABB((double)worldSpot.getX() + minCorner, (double)worldSpot.getY() + minCorner, (double)worldSpot.getZ() + minCorner, (double)worldSpot.getX() + maxCorner, (double)worldSpot.getY() + maxCorner, (double)worldSpot.getZ() + maxCorner))) continue;
                        BlockState blockstate = level.getBlockState((BlockPos)worldSpot);
                        boolean flag1 = blockstate.is(Blocks.STRUCTURE_VOID);
                        boolean flag2 = blockstate.is(Blocks.BARRIER);
                        boolean flag3 = blockstate.is(Blocks.LIGHT);
                        boolean bl = flag4 = flag1 || flag2 || flag3;
                        if (!flag4) continue;
                        int red = 255;
                        int green = 255;
                        int blue = 255;
                        int alpha = 255;
                        if (flag1) {
                            green = 190;
                            blue = 190;
                        } else if (flag2) {
                            green = 0;
                            blue = 0;
                        } else if (flag3) {
                            blue = 0;
                        }
                        if (MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX) {
                            float distanceMult = Math.max(1.0f - (float)distSq * 6.0f / (float)radiusSq, 0.5f);
                            ToggleBehavior.renderQuadBox(bufferbuilder, poseStack.last().pose(), (float)(vector4dMin.x() + (double)worldSpot.getX() - cameraPos.x()), (float)(vector4dMin.y() + (double)worldSpot.getY() - cameraPos.y()), (float)(vector4dMin.z() + (double)worldSpot.getZ() - cameraPos.z()), (float)(vector4dMax.x() + (double)worldSpot.getX() - cameraPos.x()), (float)(vector4dMax.y() + (double)worldSpot.getY() - cameraPos.y()), (float)(vector4dMax.z() + (double)worldSpot.getZ() - cameraPos.z()), (int)((float)red * distanceMult), (int)((float)green * distanceMult), (int)((float)blue * distanceMult), alpha);
                        } else {
                            ToggleBehavior.renderLineBox(bufferbuilder, poseStack.last().pose(), (float)(vector4dMin.x() + (double)worldSpot.getX() - cameraPos.x()), (float)(vector4dMin.y() + (double)worldSpot.getY() - cameraPos.y()), (float)(vector4dMin.z() + (double)worldSpot.getZ() - cameraPos.z()), (float)(vector4dMax.x() + (double)worldSpot.getX() - cameraPos.x()), (float)(vector4dMax.y() + (double)worldSpot.getY() - cameraPos.y()), (float)(vector4dMax.z() + (double)worldSpot.getZ() - cameraPos.z()), red, green, blue, alpha);
                        }
                        addedVertex = true;
                    }
                }
            }
            if (addedVertex) {
                try (MeshData meshData = bufferbuilder.buildOrThrow();){
                    GpuBufferSlice[] gpubufferslice;
                    RenderPipeline pipeline;
                    RenderSystem.AutoStorageIndexBuffer storageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)meshData.drawState().mode());
                    if (MODE == STRUCTURE_BLOCK_MODE.FULL_HITBOX) {
                        pipeline = RenderPipelines.DEBUG_QUADS;
                        gpubufferslice = new GpuBufferSlice[]{RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f)};
                    } else {
                        pipeline = RenderPipelines.LINES;
                        RenderSystem.lineWidth((float)1.5f);
                        gpubufferslice = RenderSystem.getDynamicUniforms().writeTransforms(new DynamicUniforms.Transform[]{new DynamicUniforms.Transform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 2.0f)});
                    }
                    GpuBuffer gpuBuffer = pipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.vertexBuffer());
                    GpuBuffer gpuBuffer2 = meshData.indexBuffer() == null ? storageIndexBuffer.getBuffer(meshData.drawState().indexCount()) : pipeline.getVertexFormat().uploadImmediateIndexBuffer(meshData.indexBuffer());
                    try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Structure Void Toggle Render Cubes", Minecraft.getInstance().getMainRenderTarget().getColorTextureView(), OptionalInt.empty(), Minecraft.getInstance().getMainRenderTarget().getDepthTextureView(), OptionalDouble.empty());){
                        GpuBuffer gpubuffer3;
                        renderPass.setPipeline(pipeline);
                        RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                        GpuBufferSlice gpubufferslice2 = RenderSystem.getProjectionMatrixBuffer();
                        if (gpubufferslice2 != null) {
                            renderPass.setUniform("Projection", gpubufferslice2);
                        }
                        if ((gpubuffer3 = RenderSystem.getGlobalSettingsUniform()) != null) {
                            renderPass.setUniform("Globals", gpubuffer3);
                        }
                        renderPass.setVertexBuffer(0, gpuBuffer);
                        renderPass.setIndexBuffer(gpuBuffer2, storageIndexBuffer.type());
                        renderPass.setUniform("DynamicTransforms", gpubufferslice[0]);
                        renderPass.drawIndexed(0, 0, meshData.drawState().indexCount(), 1);
                        RenderSystem.lineWidth((float)1.0f);
                    }
                }
            }
            poseStack.popPose();
            if (clearRenderState) {
                RenderType.cutout().clearRenderState();
            }
        }
    }

    private static void renderQuadBox(BufferBuilder builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue, int alpha) {
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 1.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void renderLineBox(BufferBuilder builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue, int alpha) {
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(-1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(-1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, -1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 1.0f);
    }

    public static enum STRUCTURE_BLOCK_MODE {
        DEFAULT,
        NO_HITBOX,
        SMALL_HITBOX,
        FULL_HITBOX;


        public STRUCTURE_BLOCK_MODE next() {
            if (this.ordinal() + 1 == STRUCTURE_BLOCK_MODE.values().length) {
                return STRUCTURE_BLOCK_MODE.values()[0];
            }
            return STRUCTURE_BLOCK_MODE.values()[this.ordinal() + 1];
        }
    }
}

