/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.dragonmine;

import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class DragonMine
extends JavaPlugin
implements Listener {
    private boolean requireSilkTouch;
    private boolean playSound;
    private String soundEffect;
    private boolean particleEffects;
    private double dropChance;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getLogger().info("DragonMine has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("DragonMine has been disabled!");
    }

    private void loadConfiguration() {
        FileConfiguration config = this.getConfig();
        this.requireSilkTouch = config.getBoolean("require-silk-touch", false);
        this.playSound = config.getBoolean("effects.play-sound", true);
        this.soundEffect = config.getString("effects.sound-effect", "ENTITY_ENDER_DRAGON_GROWL");
        this.particleEffects = config.getBoolean("effects.particles", true);
        this.dropChance = config.getDouble("drop-chance", 100.0);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (block == null || block.getType() != Material.DRAGON_EGG) {
            return;
        }
        if (this.isPickaxe(player.getInventory().getItemInMainHand().getType())) {
            if (this.requireSilkTouch && !this.hasSilkTouch(player.getInventory().getItemInMainHand())) {
                return;
            }
            event.setCancelled(true);
            block.setType(Material.AIR);
            if (Math.random() * 100.0 <= this.dropChance) {
                block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.DRAGON_EGG, 1));
            }
            if (this.playSound) {
                try {
                    Sound sound = Sound.valueOf(this.soundEffect);
                    player.getWorld().playSound(block.getLocation(), sound, 1.0f, 0.5f);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid sound effect in config: " + this.soundEffect);
                }
            }
            if (this.particleEffects) {
                block.getWorld().spawnParticle(Particle.DRAGON_BREATH, block.getLocation().add(0.5, 0.5, 0.5), 30, 0.5, 0.5, 0.5, 0.05);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block.getType() == Material.DRAGON_EGG && this.isPickaxe(player.getInventory().getItemInMainHand().getType())) {
            if (this.requireSilkTouch && !this.hasSilkTouch(player.getInventory().getItemInMainHand())) {
                return;
            }
            event.setCancelled(true);
            block.setType(Material.AIR);
            if (Math.random() * 100.0 <= this.dropChance) {
                block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.DRAGON_EGG, 1));
            }
            if (this.playSound) {
                try {
                    Sound sound = Sound.valueOf(this.soundEffect);
                    player.getWorld().playSound(block.getLocation(), sound, 1.0f, 0.5f);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid sound effect in config: " + this.soundEffect);
                }
            }
            if (this.particleEffects) {
                block.getWorld().spawnParticle(Particle.DRAGON_BREATH, block.getLocation().add(0.5, 0.5, 0.5), 30, 0.5, 0.5, 0.5, 0.05);
            }
        }
    }

    private boolean isPickaxe(Material material) {
        return material == Material.WOODEN_PICKAXE || material == Material.STONE_PICKAXE || material == Material.IRON_PICKAXE || material == Material.GOLDEN_PICKAXE || material == Material.DIAMOND_PICKAXE || material == Material.NETHERITE_PICKAXE;
    }

    private boolean hasSilkTouch(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        if (!item.getItemMeta().hasEnchants()) {
            return false;
        }
        return item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
    }
}

